#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/12
@file: machine_portal.py
@function:
@modify:
"""
import logging

from flask import Blueprint, g, request, jsonify

from config.commen_config import DISCOUNTS_TYPES
from models.base_model import db
from models.models import AdminMachine, Machine, AdminAccount
from utils.error_code import MACHINE_NOT_EXIST_ERROR, ACCOUNT_NOT_EXISTS_ERROR
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

machine_route = Blueprint('machine', __name__)


@machine_route.route("machine_list", methods=["POST"])
def run_machine_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", None)
    page_size = json_data.get("pageSize", None)
    keyword = json_data.get("keyword", None)

    admin = g.user
    select_sql = """select machine.id, machine.machine_no, machine.device_id, machine.qrcode_no,machine.status,
                        machine.mac, machine.power, machine.hatch_number, machine.type,machine.place_id, 
                        place.place_name, machine.discounts_id
        """
    count_sql = "select count(machine.id) as total_count"
    from_sql = """ from machine  left join place on machine.place_id = place.id
                        where machine.machine_no in ( select machine_no from admin_machine where  
                        admin_machine.user_id = {user_id} and admin_machine.status = 1)  
                         """.format(user_id=admin.id)

    where_sql = " "
    if keyword:
        where_sql += """
                        and CONCAT(machine.machine_no,ifnull(machine.qrcode_no,'')) LIKE '%{keyword}%'

                            """.format(keyword=keyword)
    order_sql = "  ORDER BY machine.id ASC, machine.status ASC"
    limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count
    print(select_sql + from_sql + where_sql + order_sql + limit_sql)
    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    for info in result:
        return_data.append(
            {"machine_no": info.machine_no, "device_id": info.device_id, "place_name": info.place_name,
             "mac": info.mac, "power": info.power, "hatch_number": info.hatch_number, "type": info.type,
             "status": info.status, "place_id": info.place_id,
             "discounts_id": info.discounts_id,
             "discounts_name": DISCOUNTS_TYPES.get(int(info.discounts_id), "无此优惠"),
             })

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@machine_route.route("add_machine", methods=["POST"])
def run_add_machine():
    """

    :return:
    """
    json_data = request.get_json()
    machine_no = json_data["machine_no"]
    address = json_data.get("address", None)
    device_id = json_data.get("device_id", None)
    qrcode_no = json_data.get("qrcode_no", None)
    mac = json_data.get("mac", None)
    power = json_data.get("power", None)
    hatch_number = json_data.get("hatch_number", None)
    place_id = json_data.get("place_id", None)
    type = json_data.get("type", 1)
    discounts_id = json_data.get("type", 0)

    machine_model = Machine()
    machine_model.machine_no = machine_no
    machine_model.device_id = device_id
    machine_model.qrcode_no = qrcode_no
    machine_model.mac = mac
    machine_model.power = power
    machine_model.place_id = place_id
    machine_model.address = address
    machine_model.mch_platform = 1
    machine_model.hatch_number = hatch_number
    machine_model.type = type
    machine_model.discounts_id = discounts_id
    db.session.add(machine_model)

    admin_machine = AdminMachine()
    admin_machine.user_id = g.user.id
    admin_machine.user_no = g.user.user_no
    admin_machine.machine_no = machine_model.machine_no
    db.session.add(admin_machine)

    db.session.commit()
    return BaseResponse()


@machine_route.route("edit_machine", methods=["POST"])
def run_edit_machine():
    """

    :return:
    """
    json_data = request.get_json()
    machine_no = json_data["machine_no"]
    address = json_data.get("address", None)
    device_id = json_data.get("device_id", None)
    qrcode_no = json_data.get("qrcode_no", None)
    mac = json_data.get("mac", None)
    power = json_data.get("power", None)
    hatch_number = json_data.get("hatch_number", None)
    place_id = json_data.get("place_id", None)
    type = json_data.get("type", None)
    status = json_data.get("status", None)
    discounts_id = json_data.get("discounts_id", None)

    machine_model = Machine.query.filter_by(machine_no=machine_no).first()
    if not machine_model:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    if device_id:
        machine_model.device_id = device_id
    if qrcode_no:
        machine_model.qrcode_no = qrcode_no
    if mac:        machine_model.mac = mac
    if power:
        machine_model.power = power
    if place_id:
        machine_model.place_id = place_id
    if address:
        machine_model.address = address
    if hatch_number:
        machine_model.hatch_number = hatch_number
    if type:
        machine_model.type = type
    if status:
        machine_model.status = status
    if discounts_id:
        machine_model.discounts_id = discounts_id
    db.session.add(machine_model)

    db.session.commit()
    return BaseResponse()


@machine_route.route("machine_detail", methods=["POST"])
def get_machine_detail():
    """

    :return:
    """
    json_data = request.get_json()
    machine_no = json_data["machine_no"]

    admin = g.user
    select_sql = """select machine.id, machine.machine_no, machine.device_id, machine.qrcode_no,machine.status,
                            machine.mac, machine.power, machine.hatch_number, machine.type,machine.place_id, 
                            place.place_name, machine.discounts_id
            """
    from_sql = """ from machine  left join place on machine.place_id = place.id
                            where machine.machine_no in ( select machine_no from admin_machine where  
                            admin_machine.user_id = {user_id} and admin_machine.status = 1)  
                             """.format(user_id=admin.id)

    where_sql = " and machine.machine_no = {}".format(machine_no)

    result = db.session.execute(select_sql + from_sql + where_sql).fetchall()
    if not result or len(result) != 1:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    info = result[0]
    return BaseResponse(data={"machine_no": info.machine_no, "device_id": info.device_id, "place_name": info.place_name,
                              "mac": info.mac, "power": info.power, "hatch_number": info.hatch_number,
                              "type": info.type, "status": info.status, "place_id": info.place_id,
                              "discounts_id": info.discounts_id,
                              "discounts_name": DISCOUNTS_TYPES.get(int(info.discounts_id), "无此优惠"),

                              })


@machine_route.route("distribute_machine", methods=["POST"])
def run_distribute_machine():
    """

    :return:
    """
    json_data = request.get_json()
    machine_nos = json_data["machine_nos"]
    user_id = json_data["user_id"]

    user = AdminAccount.query.filter_by(id=user_id, parent_id=g.user.id, status=1).first()
    if not user:
        return jsonify(ACCOUNT_NOT_EXISTS_ERROR)

    admin_machines = AdminMachine.query.filter_by(user_id=g.user.id, status=1).all()
    if not admin_machines:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    admin_machine_nos = [x.machine_no for x in admin_machines]

    right_machine_nos = list(set(machine_nos).intersection(set(admin_machine_nos)))
    if not right_machine_nos:
        return jsonify(MACHINE_NOT_EXIST_ERROR)
    insert_sql = " insert into admin_machine (user_id, user_no, machine_no) values "
    for i in right_machine_nos:
        insert_sql += "('{}','{}','{}'),".format(user.id, user.user_no, i)
    insert_sql = insert_sql[:-1]
    insert_sql += "  ON DUPLICATE KEY UPDATE status = 1"
    print(insert_sql)
    db.session.execute(insert_sql)
    db.session.commit()
    return BaseResponse(data={"add_machine_nos": right_machine_nos})
