#!usr/bin/env python
# -*- coding:utf-8 _*-

import json
import logging
import re
import time

from flask import Blueprint, request, jsonify, g
from models.base_model import db
from utils.my_response import BaseResponse
from models.models import Machine, Hatch
from utils.error_code import MACHINE_NOT_EXIST_ERROR
logger = logging.getLogger(__name__)
# 创建蓝图
machine_query_route = Blueprint('machine', __name__)
# 模糊查询到机器信息
@machine_query_route.route("query_machine",methods=["post"])
def query_machine():
    json_date = request.get_json()
    number = json_date["number"]
    page = json_date["page"]
    page_size = json_date["page_size"]
    pass
# 修改机器信息
@machine_query_route.route("query_edit",methods=["post"])
def query_edit():
    json_date = request.get_json()
    machine_no = json_date["machine_no"]
    address = json_date["address"]
    short_address = json_date["short_address"]
    status = json_date["status"]
    machine_not = Machine.query.filter_by(machine_no=machine_no).first()
    if not machine_not:
        return MACHINE_NOT_EXIST_ERROR
    machine_result = Machine.query.filter_by(machine_no=machine_no).update(
        {"address": address, "short_address": short_address, "status": status}
    )
    db.session.commit()
    return BaseResponse()
# 显出机柜数量
@machine_query_route.route("hatch_query",methods=["post"])
def hatch_query():
    json_date = request.get_json()
    machine_no = json_date["machine_no"]
    machine_not = Machine.query.filter_by(machine_no=machine_no).first()
    if not machine_not:
        return MACHINE_NOT_EXIST_ERROR
    machine_result = Hatch.query.filter_by(machine_no=machine_no).all()
    result_date = []
    hatch_having = []
    for res in machine_result:
        date={
            "hatch_no": res.hatch_no,
            "status": res.status
        }
        hatch_having.append(date)
    result_date.append({"power": machine_not.power})
    result_date.append(hatch_having)
    return BaseResponse(data=result_date)
# 查询信息
@machine_query_route.route("query", methods=["post"])
def query():
    json_date = request.get_json()
    page = json_date["page"]
    page_size = json_date["page_size"]
    # 判断有没有machine_no
    if "number" in json_date:
        get_number =str(json_date["number"])
    else:
        get_number =""

    machine_not = Machine.query.filter(Machine.machine_no.like("%" + get_number + "%")).first()
    if not machine_not:  # 没有
        add_not = Machine.query.filter(Machine.address.like("%"+get_number+"%")).first()  # 判断有没有add
        if not add_not:  # 没有返回空
            return BaseResponse(data=[])
        else:  # 有返回add信息
            add_result = Machine.query.filter(Machine.address.like("%"+get_number+"%")).offset((page-1)*page_size).limit(
                page_size
            ).all()
            result_date = []
            for add in add_result:
                date = {
                    "machine_no": add.machine_no,
                    "address": add.address,
                    "short_address": add.short_address,
                    "hatch_number": add.hatch_number,
                    "status": add.status
                }
                result_date.append(date)
            return BaseResponse(data=result_date, page=page, page_size=page_size)
    else:
            machine_result = Machine.query.filter(Machine.machine_no.like("%"+get_number+"%")).offset((page-1)*page_size).\
                limit(page_size).all()
            result_date = []
            for machine in machine_result:
                date = {
                    "machine_no": machine.machine_no,
                    "address": machine.address,
                    "short_address": machine.short_address,
                    "hatch_number": machine.hatch_number,
                    "status": machine.status
                }
                result_date.append(date)
            return BaseResponse(data=result_date, page=page, page_size=page_size)
