#!usr/bin/env python
# -*- coding:utf-8 _*-
import json
import logging
import re
import time
from config.wechat_config import platform_appid_config_list, pay_config_list, NFC_PAY_CALLBCK_URL
from flask import Blueprint, request, jsonify, g
from models.base_model import db
from utils.my_response import BaseResponse
from utils.error_code import NO_RENT_RECORD
from models.models import Rent
from service.rent_service import RentService
from service.wechat_service import WeChatPayService

logger = logging.getLogger(__name__)

rent_query_route = Blueprint('rent', __name__) # 创建蓝图
# 查询订单
@rent_query_route.route("part",methods=["post"])
def rent_query():
    json_date = request.get_json()
    if "number" in json_date:
        get_number = str(json_date["number"])
    else:
        get_number = ""

    # 订单状态
    is_pay = json_date["is_pay"]
    if "add_time" in json_date:
        add_time = json_date["add_time"]
        pay_time = json_date["pay_time"]
    else:
        add_time = ""
        pay_time = ""
    page = json_date["page"]
    page_size = json_date["page_size"]
    if is_pay == 1 or is_pay == 0:  # 完成或未完成订单
            if add_time == "" or pay_time == "":    # 没有时间筛选
                query1 = "SELECT * from rent where concat(rent.machine_no,rent.user_id,rent.rent_no) like '{}' and is_pay={} limit {},{}".format(
                    "%" + get_number + "%", is_pay, (page - 1) * page_size, page * page_size
                )
            else:   # 开始进行模糊查询以及时间筛选
                query1 = "SELECT * from rent where concat(rent.machine_no,rent.user_id,rent.rent_no) like '{}' and  add_time > '{}' AND pay_time < '{}' and is_pay={} limit {},{}".format(
                    "%"+get_number+"%", add_time, pay_time, is_pay, (page-1)*page_size, page*page_size
                )
            machine_result = db.session.execute(query1).fetchall()
    else:   # 已支付或没有支付
            if add_time == "" or pay_time == "":    # 没有时间筛选
                query1 = "SELECT * from rent where concat(rent.machine_no,rent.user_id,rent.rent_no) like '{}'  limit {},{}".format(
                    "%" + get_number + "%", (page - 1) * page_size, page * page_size
                )
            else:   # 开始进行模糊查询以及时间筛选
                query1 = "SELECT * from rent where concat(rent.machine_no,rent.user_id,rent.rent_no) like '{}' and  add_time > '{}' AND pay_time < '{}' limit {},{}".format(
                    "%" + get_number + "%", add_time, pay_time,(page-1)*page_size, page*page_size
                )
            machine_result = db.session.execute(query1).fetchall()
    result_date = []
    # 将数据遍历和筛选
    for i in machine_result:
        date = {
                "rent_no ": i.rent_no,
                "machine_no": i.machine_no,
                "user_id": i.user_id,
                "place_id": i.place_id,
                "agent_total": i.agent_total,
                "is_pay": i.is_pay,
                "add_time": i.add_time.strftime("%Y-%m-%d %H:%M:%S"),
                "pay_time": i.pay_time.strftime("%Y-%m-%d %H:%M:%S")
        }
        result_date.append(date)
    return BaseResponse(data=result_date, page=page, page_size=page_size)
# 点击详情按钮，显示订单信息
@rent_query_route.route("datails",methods=["post"])
def details():
    # 根据订单号来获取信息
    json_date = request.get_json()
    rent_no = json_date["rent_no"]
    rent_not = Rent.query.filter_by(rent_no=rent_no).first()
    if not rent_not:
        return BaseResponse(data=[])
    rent_result = Rent.query.filter_by(rent_no=rent_no).all()
    result_date = []
    for result in rent_result:
        data = {
            "rent_no": result.rent_no,
            "machine_no": result.machine_no,
            "user_id": result.user_id,
            "place_id": result.place_id,
            "back_money": result.back_money,
            "is_pay": result.is_pay,
            "rent_type": result.rent_type,
            "add_time": result.add_time,
            "pay_time": result.pay_time,
            "over_time": result.over_time
        }
        result_date.append(data)
    return BaseResponse(data=result_date)
# 进行订单修改并进行退款
@rent_query_route.route("edit_s",methods=["post"])
def edit_s():
    json_date = request.get_json()
    rent_no = json_date["rent_no"]
    is_pay = json_date["is_pay"]
    rent = Rent.query.filter_by(rent_no=rent_no, is_pay=1)
    if not rent:
        return NO_RENT_RECORD
    # 退款操作
    data = {
        "out_refund_no": RentService.create_refund_no(),
        "out_trade_no": rent.rent_no,
        "total_fee": rent.pay_money,
        "refund_fee": rent.pay_money
    }
    result = WeChatPayService(app_id=platform_appid_config_list[g.user.platform],
                              config_name=pay_config_list[rent.mch_platform]).do_refund(data)

    if result:
        rent_refund = Rent()
        rent_refund.refund_no = data["out_refund_no"]
        rent_refund.rent_no = rent_no
        rent_refund.fee = data["refund_fee"]

        rent.status = 3
        db.session.add(rent_refund)
        db.session.commit()

        return BaseResponse()
