#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/12
@file: place_portal.py
@function:
@modify:
"""
import datetime
import logging

from flask import Blueprint, g, request, jsonify
from sqlalchemy.exc import SQLAlchemyError

from config.wechat_config import platform_appid_config_list, pay_config_list
from models.base_model import db
from models.models import Rent, RentDetail, WxUser, Machine, RentRefund, DrawRecord
from service.rent_service import RentService
from service.wechat_service import WeChatPayService
from utils.error_code import OPERATE_LEVEL_ERROR, ACTION_CODE_ERROR, REFUND_NOT_PRODUCTION_INFO, Param_Invalid_Error, \
    REFUND_MONEY_IS_ZERO, REFUND_MONEY_ERROR
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

rent_route = Blueprint('rent', __name__)


@rent_route.route("rent_list", methods=["POST"])
def run_rent_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    keyword = json_data.get("keyword", None)
    start_date = json_data.get("startDate", None)
    end_date = json_data.get("endDate", None)
    business_id = json_data.get("business_id", None)
    is_pay = json_data.get("is_pay", None)

    if g.user.level not in (1, 2, 4, 5):
        return jsonify(OPERATE_LEVEL_ERROR)
    select_sql = """
                    SELECT  rent.rent_no, rent.machine_no, rent.user_id,rent.place_id,rent.is_pay,
                        rent_detail.hatch_no, rent_detail.production_id,rent_detail.production_name,
                         rent_detail.status,rent_detail.brand_name, 
                        rent_detail.production_type_name,rent_detail.total,rent_detail.rent_count,
                        rent_detail.refund_total,rent_detail.refund_count, wx_user.phone,place.place_name,
                        rent_detail.id as rent_detail_id, rent.business_id, rent.created_at,rent.pay_time
                    """
    count_sql = " select count(rent.id) as total_count "

    from_sql = """
                    FROM
                        rent
                            LEFT JOIN
                        rent_detail ON rent.rent_no = rent_detail.rent_no
                            LEFT JOIN
                        place ON rent.place_id = place.id
                            LEFT JOIN
                        wx_user ON rent.user_id = wx_user.id
                    """

    where_sql = " WHERE 0=0 "
    if keyword is not None:
        where_sql += """
                        and CONCAT(rent.rent_no,
                                    wx_user.phone) LIKE '%{keyword}%'
                    """.format(keyword=keyword)

    if start_date is not None:
        where_sql += " and rent.created_at > '{}'".format(start_date)
    if end_date is not None:
        where_sql += " and rent.created_at <= '{}'".format(end_date)

    if is_pay is not None:
        where_sql += " and rent.is_pay = '{}'".format(is_pay)

    if business_id is not None:
        where_sql += " and rent.business_id = '{}'".format(business_id)

    if g.user.level != 1:
        where_sql += """ and rent.business_id in ( 
                                    select business_id from admin_business where user_id = '{}' and status = 1)
                     """.format(g.user.id)

    order_sql = " ORDER BY rent.created_at DESC, rent_detail.created_at desc"
    limit_sql = " LIMIT {offset} , {page_size}".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    if result:
        for info in result:
            tmp = {
                "rent_no": info.rent_no, "machine_no": info.machine_no, "user_id": info.user_id,
                "phone": info.phone, "rent_detail_id": info.rent_detail_id, "place_name": info.place_name,
                "place_id": info.place_id, "is_pay": info.is_pay, "total": info.total, "rent_count": info.rent_count,
                "refund_total": info.refund_total, "refund_count": info.refund_count, "business_id": info.business_id,
                "production_name": info.production_name, "production_id": info.production_id,
                "status": info.status, "create_time": info.created_at.strftime("%Y-%m-%d %H:%M:%S"),
                "pay_time": info.pay_time.strftime("%Y-%m-%d %H:%M:%S"),
            }
            return_data.append(tmp)

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@rent_route.route("rent_detail", methods=["POST"])
def get_rent_detail():
    """

    :return:
    """
    json_data = request.get_json()
    rent_no = json_data.get("rent_no", None)
    rent_detail_id = json_data.get("rent_detail_id", None)
    if g.user.level not in (1, 2, 4, 5):
        return jsonify(OPERATE_LEVEL_ERROR)

    select_sql = """
                        SELECT rent.id, rent.rent_no, rent.machine_no, rent.user_id,rent.place_id,rent.is_pay,
                            rent_detail.hatch_no, rent_detail.production_name,rent_detail.title, rent_detail.brand_id,
                            rent_detail.production_type_id, rent_detail.price,rent_detail.original_price,
                            rent_detail.weight, rent_detail.weight_unit, rent_detail.expiration_date, 
                            rent_detail.expiration_date_unit, rent_detail.is_expiration_date,rent_detail.business_id,
                            rent_detail.weight_error, rent_detail.img, rent_detail.tags, rent_detail.content,
                            rent_detail.summary, rent_detail.status,rent_detail.brand_name, 
                            rent_detail.production_type_name,rent_detail.total,rent_detail.rent_count,
                            rent_detail.refund_total,rent_detail.refund_count, wx_user.phone,place.place_name,
                            rent_detail.production_id,rent.business_id, rent.created_at,rent.pay_time,
                            rent_detail.id as rent_detail_id
                        """
    from_sql = """
                        FROM
                            rent
                                LEFT JOIN
                            rent_detail ON rent.rent_no = rent_detail.rent_no
                                LEFT JOIN
                            place ON rent.place_id = place.id
                                LEFT JOIN
                            wx_user ON rent.user_id = wx_user.id
                        """

    where_sql = " where rent.rent_no = '{}'".format(rent_no)
    if rent_detail_id is not None:
        where_sql += " and rent_detail.id = '{}'".format(rent_detail_id)
    if g.user.level != 1:
        where_sql += """ and rent.business_id in ( 
                                    select business_id from admin_business where user_id = '{}' and status = 1)
                     """.format(g.user.id)

    result = db.session.execute(select_sql + from_sql + where_sql).fetchone()

    if result:

        return_data = {
            "rent_detail_id": result.rent_detail_id, "rent_no": result.rent_no, "machine_no": result.machine_no,
            "user_id": result.user_id,
            "phone": result.phone, "place_name": result.place_name,
            "place_id": result.id, "is_pay": result.is_pay, "total": result.total, "rent_count": result.rent_count,
            "refund_total": result.refund_total, "refund_count": result.refund_count, "business_id": result.business_id,
            "production_name": result.production_name, "production_id": result.production_id,
            "title": result.title, "brand_id": result.brand_id, "brand_name": result.brand_name,
            "production_type_id": result.production_type_id, "production_type_name": result.production_type_name,
            "price": result.price, "original_price": result.original_price, "weight": result.weight,
            "weight_unit": result.weight_unit,
            "expiration_date": result.expiration_date, "expiration_date_unit": result.expiration_date_unit,
            "is_expiration_date": result.is_expiration_date,
            "weight_error": result.weight_error,
            "img": result.img, "tags": result.tags, "content": result.content,
            "summary": result.summary, "status": result.status,
            "create_time": result.created_at.strftime("%Y-%m-%d %H:%M:%S"),
            "pay_time": result.pay_time.strftime("%Y-%m-%d %H:%M:%S"),
        }
        return BaseResponse({"data": return_data})

    else:
        return BaseResponse()


@rent_route.route('/rent_money_refund', methods=['GET', 'POST'])
def rent_money_refund_new():
    if g.user.level not in (1, 2, 4, 5):
        return jsonify(OPERATE_LEVEL_ERROR)

    json_data = request.get_json()
    action_pwd = json_data['action_pwd'] if 'action_pwd' in json_data else ''
    rent_no = json_data['rent_no']
    rent_detail_id = json_data['rent_detail_id']
    if action_pwd != "xxzn666":
        return BaseResponse(**ACTION_CODE_ERROR)

    cause = json_data['cause']
    comment = json_data['comment'] if 'comment' in json_data else ''

    rent_info = db.session.query(RentDetail, Rent, WxUser, Machine
                                 ).join(Rent,
                                        Rent.rent_no == RentDetail.rent_no
                                        ).join(WxUser, WxUser.id == Rent.user_id
                                               ).filter(RentDetail.id == rent_detail_id,
                                                        Rent.rent_no == rent_no).first()

    if not rent_info:
        return jsonify(REFUND_NOT_PRODUCTION_INFO)
    rent = rent_info.Rent
    rent_detail = rent_info.RentDetail
    wx_user = rent_info.WxUser

    refund_count = int(json_data["refund_count"])
    refund_money = refund_count * rent_detail.price

    if refund_money <= 0:
        return jsonify(REFUND_MONEY_IS_ZERO)
    if refund_money > rent_detail.total:  # 不能超出金额退款
        return jsonify(REFUND_MONEY_ERROR)
    new_total = rent_detail.total - refund_money

    # 重新计算订单对应所有讲解器总收入，退款金额
    rent_total = 0
    rent_details = RentDetail.query.filter_by(rent_no=rent.rent_no).all()
    for tmp in rent_details:
        if tmp.id == rent_detail.id:
            rent_total += new_total
        else:
            rent_total += tmp.total

    # 退款操作
    data = {
        "out_refund_no": RentService.create_refund_no(),
        "out_trade_no": rent_info.Rent.rent_no,
        "total_fee": rent.total,
        "refund_fee": refund_money
    }
    result = WeChatPayService(app_id=platform_appid_config_list[wx_user.platform],
                              config_name=pay_config_list[rent.mch_platform]).do_refund(data)
    if result:
        try:
            rent_refund = RentRefund()
            rent_refund.user_id = g.user.id
            rent_refund.refund_no = data["out_refund_no"]
            rent_refund.rent_no = rent.rent_no
            rent_refund.rent_detail_id = rent_detail.id
            rent_refund.total = refund_money
            rent_refund.comment = comment
            rent_refund.cause = cause

            rent.real_total = rent_total
            rent.back_money += refund_money

            rent_detail.total = new_total
            rent_detail.refund_count += refund_count
            rent_detail.refund_total += refund_money

            db.session.add(rent_refund)
            db.session.add(rent)
            db.session.add(rent_detail)
            db.session.commit()
        except SQLAlchemyError as e:
            db.session.rollback()
            raise e
        return BaseResponse()
    else:
        return BaseResponse(error_code=-1, error_message='refund failed')


@rent_route.route("month_bill", methods=["POST"])
def run_month_bill():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    start_date = json_data.get("startDate", None)
    end_date = json_data.get("endDate", None)
    business_id = json_data.get("business_id", None)
    is_pay = json_data.get("is_pay", None)

    select_sql = """
                    select sum(rent.real_total) as total, rent.business_id,DATE_FORMAT(rent.created_at,"%Y-%m") as rent_month,
                    admin_business.rate as rate, business.business_name as business_name
                    """
    count_sql = " select count(1) as total_count  from ("

    from_sql = """
                    FROM
                        rent
                    left join admin_business on admin_business.business_id = rent.business_id
                    left join business on business.id = rent.business_id  
                    """

    where_sql = " WHERE 0=0 "

    if start_date is not None:
        where_sql += " and rent.created_at > '{}'".format(start_date)
    if end_date is not None:
        where_sql += " and rent.created_at <= '{}'".format(end_date)

    if is_pay is not None:
        where_sql += " and rent.is_pay = '{}'".format(is_pay)

    if business_id is not None:
        where_sql += " and rent.business_id = '{}'".format(business_id)

    where_sql += """ and  admin_business.user_id = '{}' and  admin_business.status = 1  and admin_business.rate > 0
                 """.format(g.user.id)
    group_sql = " group by MONTH(rent.created_at), rent.business_id "
    order_sql = " ORDER BY rent.created_at DESC, rent.created_at desc"
    limit_sql = " LIMIT {offset} , {page_size}".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + select_sql + from_sql + where_sql + group_sql + ") as ttb").fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + group_sql + order_sql + limit_sql).fetchall()

    return_data = []
    if result:
        for info in result:
            tmp = {
                "total": info.total, "business_id": info.business_id, "rent_month": info.rent_month,
                "rate": info.rate, "business_name": info.business_name
            }
            return_data.append(tmp)

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@rent_route.route("apply_draw", methods=["POST"])
def run_apply_draw():
    """

    :return:
    """
    json_data = request.get_json()
    draw_data = json_data["draw_data"]

    for data in draw_data:
        business_id = int(data["business_id"])
        month = datetime.datetime.strptime(data["month"], "%Y-%M")
        select_sql = """
                        select sum(rent.real_total) as total, rent.business_id,
                        DATE_FORMAT(rent.created_at,"%Y-%m") as rent_month,
                        admin_business.rate as rate, business.business_name as business_name
                        """

        from_sql = """
                        FROM
                            rent
                        left join admin_business on admin_business.business_id = rent.business_id
                        left join business on business.id = rent.business_id  
                        """

        where_sql = """ WHERE rent.business_id = '{}' and DATE_FORMAT(rent.created_at,"%Y-%m") = '{}' """.format(
            business_id, data["month"])

        where_sql += """ and  admin_business.user_id = '{}' and  admin_business.status = 1  and admin_business.rate > 0
                     """.format(g.user.id)

        result = db.session.execute(select_sql + from_sql + where_sql).fetchone()
        if result:
            tmp = DrawRecord.query.filter_by(user_id=g.user.id, business_id=result["business_id"],
                                             draw_month=result["rent_month"]).first()
            if tmp:
                continue
            model = DrawRecord()
            model.user_id = g.user.id
            model.user_no = g.user.user_no
            model.business_id = result["business_id"]
            model.draw_month = result["rent_month"]
            model.total = result["total"]
            model.real_total = result["total"] * result["rate"] / 100
            model.rate = result["rate"]
            model.status = 0
            model.draw_no = RentService.create_order_no(prefix="DR")
            db.session.add(model)
            db.session.commit()

    return BaseResponse()


@rent_route.route("draw_list", methods=["POST"])
def run_draw_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    start_date = json_data.get("startDate", None)
    end_date = json_data.get("endDate", None)
    business_id = json_data.get("business_id", None)
    status = json_data.get("status", None)

    if g.user.level not in (1, 2, 4, 5):
        return jsonify(OPERATE_LEVEL_ERROR)
    select_sql = """
                    select draw_record.draw_no,
                    draw_record.business_id,
                    draw_record.draw_month,
                    draw_record.total,
                    draw_record.real_total,
                    draw_record.rate,
                    draw_record.status,
                    draw_record.draw_time,
                    draw_record.created_at,
                    draw_record.updated_at,
                    business.business_name
                    """
    count_sql = " select count(draw_record.id) as total_count "

    from_sql = """
                    FROM
                        draw_record
                            LEFT JOIN
                        business ON draw_record.business_id = business.id
                    """

    where_sql = " WHERE draw_record.status <> '-1' "

    if start_date is not None:
        where_sql += " and draw_record.draw_month > '{}'".format(start_date)
    if end_date is not None:
        where_sql += " and draw_record.draw_month <= '{}'".format(end_date)

    if status is not None:
        where_sql += " and draw_record.status = '{}'".format(status)

    if business_id is not None:
        where_sql += " and draw_record.business_id = '{}'".format(business_id)

    if g.user.level != 1:
        where_sql += """ and draw_record.business_id in ( 
                                    select business_id from admin_business where user_id = '{}' and status = 1)
                     """.format(g.user.id)

    order_sql = " ORDER BY draw_record.created_at DESC, draw_record.status asc"
    limit_sql = " LIMIT {offset} , {page_size}".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    if result:
        for info in result:
            """
            draw_record.draw_no,
                    draw_record.business_id,
                    draw_record.draw_month,
                    draw_record.total,
                    draw_record.real_total,
                    draw_record.rate,
                    draw_record.status,
                    business.business_name
            """
            tmp = {
                "business_id": info.business_id, "draw_month": info.draw_month, "total": info.total,
                "real_total": info.real_total, "rate": info.rate, "status": info.status,
                "business_name": info.business_name,
                "create_time": info.created_at.strftime("%Y-%m-%d %H:%M:%S"),
                "draw_time": info.draw_time.strftime("%Y-%m-%d %H:%M:%S") if info.draw_time else "",
            }
            return_data.append(tmp)

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})
