#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/12
@file: place_portal.py
@function:
@modify:
"""
import datetime
import logging

from flask import Blueprint, g, request, jsonify

from models.base_model import db
from models.models import AdminPlace, Place, TallymanMachine, Machine, TallymanAccount
from service.admin_service import AdminService
from utils.error_code import NO_PLACE_ERROR, TALLYMAN_ACCOUNT_NOT_EXIST, TALLYMAN_ACCOUNT_EXIST, OPERATE_LEVEL_ERROR, \
    ACCOUNT_NOT_EXISTS_ERROR
from utils.my_response import BaseResponse
from utils.mytools import json2obj

logger = logging.getLogger(__name__)

tallyman_route = Blueprint('tallyman', __name__)


@tallyman_route.route('/tallyman_list', methods=["POST"])
def get_account_list():
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    keyword = json_data.get("keyword", None)

    return_data = AdminService.get_tallyman_account_list(keyword=keyword, page=page, page_size=page_size)

    return BaseResponse(return_data)


@tallyman_route.route('/edit_tallyman_account', methods=['GET', 'POST'])
def run_tallyman_edit_account():
    admin = g.user
    if g.user.level not in (1, 2, 4, 5):
        return jsonify(OPERATE_LEVEL_ERROR)
    json_data = request.get_json()
    old_phone = json_data['old_phone']
    new_phone = json_data.get('new_phone', None)
    user_name = json_data.get('user_name', None)
    password = json_data.get('password', None)
    business_id = json_data.get('business_id', None)
    status = json_data.get('status', None)

    tallyman_info = TallymanAccount.query.filter_by(phone=old_phone).first()
    if not tallyman_info:
        return jsonify(TALLYMAN_ACCOUNT_NOT_EXIST)

    if new_phone:
        tallyman_info.phone = new_phone

    if user_name:
        tallyman_info.user_name = user_name

    if password:
        tallyman_info.password = password

    if status:
        tallyman_info.status = status

    if business_id:
        tallyman_info.business_id = business_id

    db.session.add(tallyman_info)
    db.session.commit()

    return BaseResponse()


@tallyman_route.route('/add_tallyman_account', methods=['GET', 'POST'])
def run_add_tallyman_account():
    admin = g.user
    if g.user.level not in (1, 2, 4, 5):
        return jsonify(OPERATE_LEVEL_ERROR)
    json_data = request.get_json()
    user_name = json_data['user_name'] if 'user_name' in json_data else 'SSW'
    phone = json_data['phone'] if 'phone' in json_data else None
    level = int(json_data['level']) if 'level' in json_data else 2
    password = json_data['password'] if 'password' in json_data else None
    comment = json_data['comment'] if 'comment' in json_data else ''
    business_id = json_data["business_id"]

    tallyman = TallymanAccount.query.filter_by(phone=phone).first()
    if tallyman:
        if tallyman.status != -1:
            return jsonify(TALLYMAN_ACCOUNT_EXIST)
    else:
        tallyman = TallymanAccount()

    tallyman.user_no = "todo"
    tallyman.user_name = user_name
    tallyman.phone = phone
    tallyman.level = level
    tallyman.business_id = business_id
    tallyman.status = 1
    tallyman.comment = comment
    tallyman.created_at = datetime.datetime.now()
    tallyman.updated_at = datetime.datetime.now()
    if password:
        tallyman.password = password
    db.session.add(tallyman)
    db.session.commit()
    tallyman.user_no = "XXTM" + str(tallyman.id).zfill(6)
    db.session.add(tallyman)
    db.session.commit()
    return BaseResponse()


@tallyman_route.route('/delete_tallyman_account', methods=['GET', 'POST'])
def run_delete_tallyman_account():
    json_data = request.get_json()
    if g.user.level not in (1, 2, 4, 5):
        return jsonify(OPERATE_LEVEL_ERROR)
    phone = json_data['phone']

    tallyman = TallymanAccount.query.filter_by(phone=phone).first()
    if not tallyman:
        return BaseResponse()
    tallyman.status = -1
    db.session.add(tallyman)

    tallyman_machine_info = TallymanMachine.query.filter_by(user_id=tallyman.id).all()
    for info in tallyman_machine_info:
        info.status = -1
        db.session.add(info)

    db.session.commit()

    return BaseResponse()


@tallyman_route.route('/tallyman_account_detail', methods=["POST"])
def get_tallyman_account_detail():
    json_data = request.get_json()
    if g.user.level not in (1, 2, 4, 5):
        return jsonify(OPERATE_LEVEL_ERROR)
    phone = json_data["phone"]
    if phone == g.user.phone:
        admin_info = g.user
    else:
        result = AdminService.get_tallyman_account_list(phone=phone)
        if result["total_count"] != 1:
            return BaseResponse(ACCOUNT_NOT_EXISTS_ERROR)
        admin_info = json2obj(result["list"][0])

    user_info = {
        "id": admin_info.id,
        "user_no": admin_info.user_no,
        "user_name": admin_info.user_name,
        "phone": admin_info.phone,
        "level": admin_info.level,
        "business_id": admin_info.business_id,
        "business_name": admin_info.business_name,
        "status": admin_info.status,
        "comment": admin_info.comment
    }

    return BaseResponse(data=user_info)
