# coding: utf-8
from sqlalchemy import Column, DateTime, Index, String, TIMESTAMP, Text, text
from sqlalchemy.dialects.mysql import INTEGER, TEXT, TINYINT, VARCHAR
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()
metadata = Base.metadata


class AdminAccount(Base):
    __tablename__ = 'admin_account'

    id = Column(INTEGER(10), primary_key=True, unique=True)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False, unique=True)
    user_name = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False)
    phone = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, unique=True)
    level = Column(TINYINT(2), nullable=False, comment="'1': '超级管理员','2': '管理员','3': '业务员','4': '商户管理员','5': '商户管理员','6': '财务','7': '运维管理员','8': '补货员','9': '客服',")
    parent_id = Column(INTEGER(10), nullable=False, comment='上级ID')
    draw = Column(TINYINT(1), nullable=False, server_default=text("'0'"), comment='提现权限0不可以1可以')
    rate = Column(INTEGER(10), nullable=False, comment='分成比例')
    status = Column(INTEGER(1), nullable=False, comment='1:正常 2：删除')
    _password_hash_ = Column(String(255, 'utf8mb4_unicode_ci'))
    comment = Column(String(255, 'utf8mb4_unicode_ci'))
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class AdminBrand(Base):
    __tablename__ = 'admin_brand'

    id = Column(INTEGER(11), primary_key=True)
    user_id = Column(INTEGER(11), nullable=False)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    brand_id = Column(INTEGER(11), nullable=False)
    status = Column(INTEGER(1), nullable=False, server_default=text("'1'"), comment='1:正常 2：删除')
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class AdminBusines(Base):
    __tablename__ = 'admin_business'
    __table_args__ = (
        Index('unique4admin_business_user_business', 'user_id', 'business_id', unique=True),
    )

    id = Column(INTEGER(11), primary_key=True)
    user_id = Column(INTEGER(11), nullable=False)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    business_id = Column(INTEGER(11), nullable=False)
    status = Column(INTEGER(1), nullable=False, server_default=text("'1'"), comment='1:正常 -1：删除')
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class AdminLoginRecord(Base):
    __tablename__ = 'admin_login_record'

    id = Column(INTEGER(10), primary_key=True)
    phone = Column(VARCHAR(40), nullable=False)
    platform = Column(TINYINT(4), nullable=False, server_default=text("'1'"), comment='平台 1PC平台')
    ip = Column(VARCHAR(40), nullable=False)
    last_login = Column(DateTime, nullable=False)
    login_type = Column(INTEGER(1), nullable=False, comment='1:验证码登录 2：token 3:发送验证码  4:密码')
    created_at = Column(DateTime, nullable=False)
    updated_at = Column(DateTime, nullable=False)


class AdminMachine(Base):
    __tablename__ = 'admin_machine'
    __table_args__ = (
        Index('unique4admin_machine_user_id_machine_no', 'user_id', 'machine_no', unique=True),
    )

    id = Column(INTEGER(11), primary_key=True)
    user_id = Column(INTEGER(11), nullable=False)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    machine_no = Column(String(40, 'utf8mb4_unicode_ci'), nullable=False)
    status = Column(INTEGER(1), nullable=False, server_default=text("'1'"), comment='1:正常 -1：删除')
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class AdminPlace(Base):
    __tablename__ = 'admin_place'

    id = Column(INTEGER(11), primary_key=True)
    user_id = Column(INTEGER(11), nullable=False)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    place_id = Column(INTEGER(11), nullable=False)
    status = Column(INTEGER(1), nullable=False, server_default=text("'1'"), comment='1:正常 2：删除')
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class AdminProduction(Base):
    __tablename__ = 'admin_production'

    id = Column(INTEGER(11), primary_key=True)
    user_id = Column(INTEGER(11), nullable=False)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    production_id = Column(INTEGER(11), nullable=False)
    status = Column(INTEGER(1), nullable=False, server_default=text("'1'"), comment='1:正常 2：删除')
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class AdminProductionType(Base):
    __tablename__ = 'admin_production_type'

    id = Column(INTEGER(11), primary_key=True)
    user_id = Column(INTEGER(11), nullable=False)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    production_type_id = Column(INTEGER(11), nullable=False)
    status = Column(INTEGER(1), nullable=False, server_default=text("'1'"), comment='1:正常 2：删除')
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class Brand(Base):
    __tablename__ = 'brand'

    id = Column(INTEGER(10), primary_key=True)
    brand_name = Column(VARCHAR(191), nullable=False, index=True, comment='品牌名')
    img = Column(VARCHAR(191), nullable=False, comment='logo')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))
    status = Column(TINYINT(1), nullable=False, server_default=text("'1'"), comment='状态: 1正常-1删除')


class Busines(Base):
    __tablename__ = 'business'

    id = Column(INTEGER(10), primary_key=True)
    business_name = Column(VARCHAR(191), nullable=False, comment='品牌名')
    status = Column(TINYINT(1), nullable=False, server_default=text("'1'"), comment='状态: 1正常-1删除')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class Hatch(Base):
    __tablename__ = 'hatch'
    __table_args__ = (
        Index('hatch_machine_UNIQUE', 'machine_no', 'hatch_no', unique=True),
    )

    id = Column(INTEGER(10), primary_key=True, unique=True)
    machine_no = Column(String(20, 'utf8mb4_unicode_ci'), nullable=False, comment='机柜id')
    hatch_no = Column(TINYINT(3), nullable=False, comment='机柜仓口号')
    production_id = Column(INTEGER(10), nullable=False, comment='商品id')
    production_name = Column(String(100, 'utf8mb4_unicode_ci'), nullable=False, comment='商品名称')
    title = Column(String(200, 'utf8mb4_unicode_ci'), nullable=False, comment='商品标题')
    left_count = Column(TINYINT(3), nullable=False, server_default=text("'1'"), comment='剩余数量')
    total_count = Column(TINYINT(3), nullable=False, server_default=text("'1'"), comment='总数量')
    brand_id = Column(INTEGER(10), nullable=False, comment='品牌ID')
    brand_name = Column(String(100, 'utf8mb4_unicode_ci'), nullable=False, comment='商品名称')
    production_type_id = Column(INTEGER(10), nullable=False, comment='分类ID')
    production_type_name = Column(String(200, 'utf8mb4_unicode_ci'), nullable=False, comment='商品标题')
    price = Column(INTEGER(10), nullable=False, comment='价格')
    original_price = Column(INTEGER(10), nullable=False, comment='商品原价')
    weight = Column(INTEGER(10), server_default=text("'0'"), comment='重量')
    weight_unit = Column(String(10, 'utf8mb4_unicode_ci'), server_default=text("'g'"), comment='重量单位')
    weight_error = Column(INTEGER(10), server_default=text("'0'"), comment='重量误差')
    expiration_date = Column(INTEGER(10), server_default=text("'0'"), comment='保质期')
    expiration_date_unit = Column(String(10, 'utf8mb4_unicode_ci'), server_default=text("'月'"), comment='保质期单位')
    is_expiration_date = Column(TINYINT(1), server_default=text("'0'"), comment='是否有保质期')
    img = Column(String(200, 'utf8mb4_unicode_ci'))
    tags = Column(String(255, 'utf8mb4_unicode_ci'), comment='商品标签')
    content = Column(Text(collation='utf8mb4_unicode_ci'), comment='商品内容')
    summary = Column(Text(collation='utf8mb4_unicode_ci'), comment='商品描述')
    status = Column(TINYINT(3), nullable=False, server_default=text("'1'"), comment='1可售2售空')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class Machine(Base):
    __tablename__ = 'machine'

    id = Column(INTEGER(10), primary_key=True)
    machine_no = Column(String(20, 'utf8mb4_unicode_ci'), nullable=False, unique=True, comment='机柜编号')
    device_id = Column(String(45, 'utf8mb4_unicode_ci'), unique=True, comment='蓝牙设备号')
    qrcode_no = Column(String(20, 'utf8mb4_unicode_ci'), unique=True, comment='机柜编号')
    mac = Column(String(30, 'utf8mb4_unicode_ci'), unique=True)
    power = Column(TINYINT(3), nullable=False, server_default=text("'0'"), comment='电量')
    short_address = Column(VARCHAR(45))
    address = Column(String(191, 'utf8mb4_unicode_ci'), comment='机柜位置')
    place_id = Column(INTEGER(10))
    mch_platform = Column(INTEGER(11), nullable=False, server_default=text("'1'"), comment='1随身玩   2晓见文旅')
    position = Column(String(20, 'utf8mb4_unicode_ci'), comment='机柜位置坐标')
    hatch_number = Column(TINYINT(3), nullable=False, server_default=text("'0'"), comment='机柜的仓口数量')
    type = Column(TINYINT(3), nullable=False, server_default=text("'1'"), comment='机柜类型1 单库存  2多库存')
    status = Column(TINYINT(1), server_default=text("'0'"), comment='状态: 0未激活 1正常-1删除')
    created_at = Column(TIMESTAMP, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))
    command_time = Column(INTEGER(4), nullable=False, server_default=text("'1'"))
    discounts_id = Column(INTEGER(10), server_default=text("'0'"), comment='折扣活动')
    business_id = Column(INTEGER(10), nullable=False, server_default=text("'0'"))


class MachineProduction(Base):
    __tablename__ = 'machine_production'

    id = Column(INTEGER(10), primary_key=True)
    machine_id = Column(INTEGER(10), nullable=False)
    production_id = Column(INTEGER(10), nullable=False)
    hatch_no = Column(INTEGER(10), nullable=False)
    status = Column(TINYINT(1), nullable=False, comment='状态: 1整除-1删除')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class ManagementLogin(Base):
    __tablename__ = 'management_login'

    id = Column(INTEGER(10), primary_key=True)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    user_name = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    phone = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False)
    level = Column(INTEGER(1), nullable=False)
    status = Column(INTEGER(1), nullable=False)
    _password_hash_ = Column(String(255, 'utf8mb4_unicode_ci'))
    last_login = Column(DateTime)
    expire_time = Column(DateTime)
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))


class ManagementMachine(Base):
    __tablename__ = 'management_machine'

    id = Column(INTEGER(11), primary_key=True)
    management_id = Column(INTEGER(255), nullable=False)
    machine_no = Column(INTEGER(255), nullable=False)
    level = Column(INTEGER(255), nullable=False)
    status = Column(INTEGER(1), nullable=False)
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))


class ManagementTallyman(Base):
    __tablename__ = 'management_tallyman'

    id = Column(INTEGER(11), primary_key=True)
    management_id = Column(INTEGER(255), nullable=False)
    tallyman_id = Column(INTEGER(255), nullable=False)
    status = Column(INTEGER(1), nullable=False)
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))


class NfcCard(Base):
    __tablename__ = 'nfc_card'
    __table_args__ = {'comment': 'nfc卡片表'}

    id = Column(INTEGER(10), primary_key=True)
    card_no = Column(String(40, 'utf8mb4_unicode_ci'), comment='卡片编号')
    user_id = Column(INTEGER(10))
    nick_name = Column(String(40, 'utf8mb4_unicode_ci'), comment='学生名称')
    phone = Column(String(40, 'utf8mb4_unicode_ci'), index=True, comment='手机号')
    money = Column(INTEGER(10), nullable=False)
    mch_platform = Column(INTEGER(11), nullable=False, server_default=text("'1'"), comment='1咻咻')
    limit_count = Column(TINYINT(1), nullable=False, server_default=text("'-1'"))
    status = Column(TINYINT(4), nullable=False, comment='状态0停用1正常')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class NfcCardPayRecord(Base):
    __tablename__ = 'nfc_card_pay_record'
    __table_args__ = {'comment': 'nfc卡片充值表'}

    id = Column(INTEGER(10), primary_key=True)
    card_no = Column(String(40, 'utf8mb4_unicode_ci'), index=True, comment='卡片编号')
    rent_no = Column(VARCHAR(40), nullable=False, comment='租借单号')
    user_id = Column(INTEGER(10), nullable=False, comment='用户id')
    is_pay = Column(TINYINT(3), nullable=False, server_default=text("'0'"), comment='是否支付')
    pay_money = Column(INTEGER(10), nullable=False, comment='充值金额')
    mch_platform = Column(INTEGER(11), nullable=False, server_default=text("'1'"), comment='1随身玩   2晓见文旅')
    prepay_id = Column(VARCHAR(191), comment='微信支付prepay_id')
    refund_no = Column(VARCHAR(191), comment='退款单号')
    status = Column(TINYINT(4), nullable=False, comment='1已充值  2已圈存到账  3已退款 -1已删除')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class NfcCardPayRefund(Base):
    __tablename__ = 'nfc_card_pay_refund'

    id = Column(INTEGER(11), primary_key=True)
    refund_no = Column(VARCHAR(191), nullable=False)
    rent_no = Column(VARCHAR(191), nullable=False)
    fee = Column(INTEGER(11), nullable=False)
    cause = Column(VARCHAR(191))
    comment = Column(TEXT)
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class Place(Base):
    __tablename__ = 'place'

    id = Column(INTEGER(10), primary_key=True)
    parent_id = Column(INTEGER(10), comment='上级ID')
    place_name = Column(VARCHAR(191), nullable=False, index=True, comment='场所名')
    img = Column(VARCHAR(191), comment='展示界面的图片')
    logo = Column(VARCHAR(191), comment='微型头像')
    address = Column(VARCHAR(255), server_default=text("''"))
    position = Column(String(20, 'utf8mb4_unicode_ci'))
    open_time = Column(VARCHAR(191), comment='开始时间')
    close_time = Column(VARCHAR(191), comment='结束时间')
    open_week = Column(VARCHAR(255), server_default=text("''"))
    status = Column(INTEGER(1), nullable=False, server_default=text("'1'"), comment='1:正常 2：删除')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class PlaceMachine(Base):
    __tablename__ = 'place_machine'

    id = Column(INTEGER(11), primary_key=True)
    machine_id = Column(INTEGER(25))
    place_id = Column(INTEGER(25))
    status = Column(INTEGER(1))
    created_at = Column(DateTime, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, server_default=text("CURRENT_TIMESTAMP"))


class Production(Base):
    __tablename__ = 'production'

    id = Column(INTEGER(10), primary_key=True)
    production_no = Column(String(45, 'utf8mb4_unicode_ci'), nullable=False)
    production_name = Column(String(100, 'utf8mb4_unicode_ci'), nullable=False, index=True, comment='商品名称')
    title = Column(String(200, 'utf8mb4_unicode_ci'), nullable=False, comment='商品标题')
    brand_id = Column(INTEGER(10), nullable=False, comment='品牌ID')
    production_type_id = Column(INTEGER(10), nullable=False, comment='分类ID')
    price = Column(INTEGER(10), nullable=False, comment='价格')
    original_price = Column(INTEGER(10), nullable=False, comment='商品原价')
    weight = Column(INTEGER(10), server_default=text("'0'"), comment='重量')
    weight_unit = Column(String(10, 'utf8mb4_unicode_ci'), server_default=text("'g'"), comment='重量单位')
    expiration_date = Column(INTEGER(10), server_default=text("'0'"), comment='保质期')
    expiration_date_unit = Column(String(10, 'utf8mb4_unicode_ci'), server_default=text("'月'"), comment='保质期单位')
    is_expiration_date = Column(TINYINT(1), server_default=text("'0'"), comment='是否有保质期')
    weight_error = Column(INTEGER(10), server_default=text("'0'"), comment='重量误差')
    img = Column(String(200, 'utf8mb4_unicode_ci'))
    tags = Column(String(255, 'utf8mb4_unicode_ci'), comment='商品标签')
    content = Column(Text(collation='utf8mb4_unicode_ci'), comment='商品内容')
    summary = Column(Text(collation='utf8mb4_unicode_ci'), comment='商品描述')
    status = Column(TINYINT(1), nullable=False, server_default=text("'1'"), comment='状态: 1正常-1删除')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class ProductionType(Base):
    __tablename__ = 'production_type'

    id = Column(INTEGER(10), primary_key=True)
    production_type_name = Column(VARCHAR(191), nullable=False, index=True, comment='分类名')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))
    status = Column(TINYINT(1), nullable=False, server_default=text("'1'"), comment='状态: 1正常-1删除')


class Rent(Base):
    __tablename__ = 'rent'

    id = Column(INTEGER(10), primary_key=True)
    rent_no = Column(VARCHAR(40), nullable=False, index=True, comment='租借单号')
    machine_no = Column(String(40, 'utf8mb4_unicode_ci'), nullable=False, index=True, comment='机柜id')
    user_id = Column(INTEGER(10), nullable=False, index=True, comment='用户id')
    card_no = Column(String(40, 'utf8mb4_unicode_ci'), index=True)
    place_id = Column(INTEGER(10), nullable=False, index=True, comment='场所id')
    total = Column(INTEGER(10), server_default=text("'0'"), comment='应收金额')
    real_total = Column(INTEGER(10), server_default=text("'0'"), comment='实收金额')
    agent_total = Column(INTEGER(10), server_default=text("'0'"), comment='给代理商看的收入')
    back_money = Column(INTEGER(10), nullable=False, server_default=text("'0'"), comment='退款金额')
    is_pay = Column(TINYINT(3), nullable=False, server_default=text("'0'"), comment='是否支付')
    rent_type = Column(TINYINT(3), nullable=False, server_default=text("'1'"), comment='租借类型1现场租借2预约3nfc租借')
    mch_platform = Column(INTEGER(1), nullable=False, server_default=text("'1'"), comment='1待定')
    add_time = Column(TIMESTAMP, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"), comment='下单时间')
    pay_time = Column(TIMESTAMP, comment='支付时间')
    is_over = Column(TINYINT(3), nullable=False, server_default=text("'0'"), comment='是否完结')
    is_cancel = Column(TINYINT(3), nullable=False, server_default=text("'0'"), comment='是否取消交易')
    refund_no = Column(VARCHAR(191), comment='退款单号')
    expire_handle = Column(TINYINT(3), nullable=False, server_default=text("'0'"), comment='是否做过期处理')
    prepay_id = Column(VARCHAR(191), comment='微信支付prepay_id')
    over_time = Column(TIMESTAMP, comment='订单完结时间')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))
    business_id = Column(INTEGER(11), nullable=False, server_default=text("'0'"))


class RentDetail(Base):
    __tablename__ = 'rent_detail'

    id = Column(INTEGER(10), primary_key=True, unique=True)
    rent_no = Column(String(40, 'utf8mb4_unicode_ci'), nullable=False, comment='订单编号')
    user_id = Column(INTEGER(10), nullable=False, comment='用户id')
    machine_no = Column(String(20, 'utf8mb4_unicode_ci'), nullable=False, comment='机柜id')
    hatch_no = Column(TINYINT(3), nullable=False, comment='机柜仓口号')
    total = Column(INTEGER(10), server_default=text("'0'"), comment='实收金额')
    rent_count = Column(TINYINT(3), nullable=False, server_default=text("'0'"))
    refund_total = Column(INTEGER(10), server_default=text("'0'"))
    refund_count = Column(INTEGER(10), server_default=text("'0'"))
    is_take = Column(TINYINT(3), nullable=False, server_default=text("'0'"), comment='是否取货')
    business_id = Column(INTEGER(11), nullable=False, server_default=text("'0'"))
    status = Column(TINYINT(3), nullable=False, server_default=text("'1'"), comment='1正常  2删除')
    production_id = Column(INTEGER(10), nullable=False, comment='商品id')
    production_name = Column(String(100, 'utf8mb4_unicode_ci'), nullable=False, comment='商品名称')
    title = Column(String(200, 'utf8mb4_unicode_ci'), nullable=False, comment='商品标题')
    brand_id = Column(INTEGER(10), nullable=False, comment='品牌ID')
    brand_name = Column(String(100, 'utf8mb4_unicode_ci'), nullable=False, comment='商品名称')
    production_type_id = Column(INTEGER(10), nullable=False, comment='分类ID')
    production_type_name = Column(String(200, 'utf8mb4_unicode_ci'), nullable=False, comment='商品标题')
    price = Column(INTEGER(10), nullable=False, comment='价格')
    original_price = Column(INTEGER(10), nullable=False, comment='商品原价')
    img = Column(String(200, 'utf8mb4_unicode_ci'))
    tags = Column(String(255, 'utf8mb4_unicode_ci'), comment='商品标签')
    content = Column(Text(collation='utf8mb4_unicode_ci'), comment='商品内容')
    summary = Column(Text(collation='utf8mb4_unicode_ci'), comment='商品描述')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))
    weight = Column(INTEGER(10), server_default=text("'0'"), comment='重量')
    weight_unit = Column(String(10, 'utf8mb4_unicode_ci'), server_default=text("'g'"), comment='重量单位')
    expiration_date = Column(INTEGER(10), server_default=text("'0'"), comment='保质期')
    expiration_date_unit = Column(String(10, 'utf8mb4_unicode_ci'), server_default=text("'月'"), comment='保质期单位')
    is_expiration_date = Column(TINYINT(1), server_default=text("'0'"), comment='是否有保质期')
    weight_error = Column(INTEGER(10), server_default=text("'0'"), comment='重量误差')


class RentRefund(Base):
    __tablename__ = 'rent_refund'

    id = Column(INTEGER(11), primary_key=True)
    user_id = Column(INTEGER(10), nullable=False)
    refund_no = Column(VARCHAR(20), nullable=False)
    rent_no = Column(String(20, 'utf8mb4_unicode_ci'), nullable=False)
    rent_detail_id = Column(INTEGER(11), nullable=False)
    total = Column(INTEGER(11), nullable=False)
    cause = Column(VARCHAR(191))
    comment = Column(TEXT)
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class SalePlan(Base):
    __tablename__ = 'sale_plan'

    id = Column(INTEGER(10), primary_key=True)
    name = Column(String(100, 'utf8mb4_unicode_ci'), nullable=False, comment='方案名称')
    title = Column(String(200, 'utf8mb4_unicode_ci'), nullable=False, comment='方案标题')
    status = Column(TINYINT(1), nullable=False, comment='状态: 1整除-1删除')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class SalePlanMachine(Base):
    __tablename__ = 'sale_plan_machine'

    id = Column(INTEGER(10), primary_key=True)
    plan_id = Column(INTEGER(10), nullable=False)
    machine_id = Column(INTEGER(10), nullable=False)
    status = Column(TINYINT(1), nullable=False, comment='状态: 1正常 -1删除')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class SalePlanProduction(Base):
    __tablename__ = 'sale_plan_production'

    id = Column(INTEGER(10), primary_key=True)
    plan_id = Column(INTEGER(10), nullable=False)
    production_id = Column(INTEGER(10), nullable=False)
    index = Column(INTEGER(10), nullable=False)
    status = Column(TINYINT(1), nullable=False, comment='状态: 1整除-1删除')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class TallyRecord(Base):
    __tablename__ = 'tally_record'

    id = Column(INTEGER(10), primary_key=True)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False, comment='补货员')
    user_name = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False, comment='补货员')
    machine_no = Column(String(20, 'utf8mb4_unicode_ci'), nullable=False, comment='机柜id')
    hatch_no = Column(TINYINT(3), nullable=False, comment='机柜仓口号')
    production_id = Column(INTEGER(10), nullable=False, comment='商品id')
    production_name = Column(String(100, 'utf8mb4_unicode_ci'), nullable=False, comment='商品名称')
    tally_count = Column(TINYINT(3), nullable=False, server_default=text("'1'"))
    status = Column(TINYINT(3), nullable=False, server_default=text("'1'"), comment='1指令已下发(等待开仓) 2指令上报(补货完成)')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class TallymanAccount(Base):
    __tablename__ = 'tallyman_account'

    id = Column(INTEGER(10), primary_key=True, unique=True)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False, unique=True)
    user_name = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False)
    phone = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, unique=True)
    level = Column(INTEGER(1), nullable=False, comment='1:补货员')
    business_id = Column(INTEGER(11), server_default=text("'0'"))
    status = Column(INTEGER(1), nullable=False, comment='1:正常 2：删除')
    _password_hash_ = Column(String(255, 'utf8mb4_unicode_ci'))
    comment = Column(String(255, 'utf8mb4_unicode_ci'))
    last_login = Column(DateTime)
    expire_time = Column(DateTime)
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class TallymanLoginRecord(Base):
    __tablename__ = 'tallyman_login_record'

    id = Column(INTEGER(10), primary_key=True)
    phone = Column(VARCHAR(255), nullable=False)
    platform = Column(TINYINT(4), nullable=False, server_default=text("'2'"), comment='平台 2小导游 8商户PC')
    ip = Column(VARCHAR(255), nullable=False)
    last_login = Column(DateTime, nullable=False)
    login_type = Column(INTEGER(1), nullable=False, comment='1:验证码登录 2：token 3:发送验证码  4:密码')
    created_at = Column(DateTime, nullable=False)
    updated_at = Column(DateTime, nullable=False)


class TallymanMachine(Base):
    __tablename__ = 'tallyman_machine'

    id = Column(INTEGER(11), primary_key=True)
    user_id = Column(INTEGER(255), nullable=False)
    machine_no = Column(INTEGER(255), nullable=False)
    status = Column(INTEGER(1), nullable=False)
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))


class TallymanPlace(Base):
    __tablename__ = 'tallyman_place'

    id = Column(INTEGER(11), primary_key=True)
    user_id = Column(INTEGER(255), nullable=False)
    place_id = Column(INTEGER(255), nullable=False)
    status = Column(INTEGER(1), nullable=False)
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))


class WxUser(Base):
    __tablename__ = 'wx_user'
    __table_args__ = {'comment': '微信用户表'}

    id = Column(INTEGER(10), primary_key=True)
    openid = Column(String(40, 'utf8mb4_unicode_ci'), index=True, comment='微信支付宝公众平台openID')
    unionid = Column(String(40, 'utf8mb4_unicode_ci'), comment='微信支付宝unionid')
    platform = Column(TINYINT(4), nullable=False, server_default=text("'0'"), comment='平台')
    phone = Column(String(40, 'utf8mb4_unicode_ci'), index=True, comment='手机号')
    language = Column(String(40, 'utf8mb4_unicode_ci'), comment='语种')
    nick_name = Column(String(40, 'utf8mb4_unicode_ci'), comment='昵称')
    gender = Column(TINYINT(4), nullable=False, server_default=text("'0'"), comment='性别 0：未知、1：男、2：女')
    avatar_url = Column(String(191, 'utf8mb4_unicode_ci'), comment='头像')
    city = Column(String(45, 'utf8mb4_unicode_ci'))
    province = Column(String(45, 'utf8mb4_unicode_ci'))
    country = Column(String(45, 'utf8mb4_unicode_ci'))
    status = Column(TINYINT(4), nullable=False, comment='状态0停用1正常')
    last_login_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"), comment='上次登录时间')
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))
