#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2021/08/05
@file: index_portal.py
@function:
@modify:
"""
import datetime

from flask import Blueprint, g
import logging

from sqlalchemy import func

from models.agent_model import AgentSpot
from models.base_model import db
from models.rent_models import Production
from models.spot_models import Spot
from service.index_service import IndexService
from utils.Helper import Helper
from utils.error_code.account_error import ACCOUNT_AGENT_SPOT_NOT_EXIST
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

route_index = Blueprint('index', __name__)


@route_index.route("/day_income", methods=["GET"])
def get_today_income_data():
    agent = g.user

    return_data = {"today_income": None, "today_count": None, 'yesterday_income': None, 'yesterday_count': None}

    agent_spot_list = AgentSpot.query.filter_by(agent_no=agent.id, status=1).all()
    if agent_spot_list:
        spot_no_list = [i.spot_no for i in agent_spot_list]
    else:
        return BaseResponse(data=return_data)

    today, tomorrow = Helper.get_today_date()
    today_income, today_count = IndexService.get_total_production(spot_no_list, today, tomorrow)
    return_data["today_income"] = today_income
    return_data["today_count"] = today_count

    today, yesterday = Helper.get_yesterday_date()
    yesterday_income, yesterday_count = IndexService.get_total_production(spot_no_list, today, yesterday)
    return_data["yesterday_income"] = yesterday_income
    return_data["yesterday_count"] = yesterday_count

    return BaseResponse(data=return_data)


@route_index.route("/week_income", methods=["GET"])
def get_week_income_data():
    agent = g.user

    return_data = {"week_income": None, "week_count": None, 'last_week_income': None, 'last_week_count': None}

    agent_spot_list = AgentSpot.query.filter_by(agent_no=agent.id, status=1).all()
    if agent_spot_list:
        spot_no_list = [i.spot_no for i in agent_spot_list]
    else:
        return BaseResponse(data=return_data)

    monday, next_monday = Helper.get_week_date()
    today_income, today_count = IndexService.get_total_production(spot_no_list, monday, next_monday)
    return_data["week_income"] = today_income
    return_data["week_count"] = today_count

    last_monday, monday = Helper.get_last_week_date()
    yesterday_income, yesterday_count = IndexService.get_total_production(spot_no_list, last_monday, monday)
    return_data["last_week_income"] = yesterday_income
    return_data["last_week_count"] = yesterday_count

    return BaseResponse(data=return_data)


@route_index.route("/month_income", methods=["GET"])
def get_month_income_data():
    agent = g.user

    return_data = {"month_income": None, "month_count": None, 'last_month_income': None, 'last_month_count': None}

    agent_spot_list = AgentSpot.query.filter_by(agent_no=agent.id, status=1).all()
    if agent_spot_list:
        spot_no_list = [i.spot_no for i in agent_spot_list]
    else:
        return BaseResponse(data=return_data)

    month, next_month = Helper.get_month_date()

    today_income, today_count = IndexService.get_total_production(spot_no_list, month, next_month)
    return_data["month_income"] = today_income
    return_data["month_count"] = today_count

    last_month, month = Helper.get_last_month_date()

    yesterday_income, yesterday_count = IndexService.get_total_production(spot_no_list, last_month, month)
    return_data["last_month_income"] = yesterday_income
    return_data["last_month_count"] = yesterday_count

    return BaseResponse(data=return_data)


@route_index.route("/history_income", methods=["GET"])
def get_history_income_data():
    agent = g.user

    return_data = {"history_income": None, "history_count": None}

    agent_spot_list = AgentSpot.query.filter_by(agent_no=agent.id, status=1).all()
    if agent_spot_list:
        spot_no_list = [i.spot_no for i in agent_spot_list]
    else:
        return BaseResponse(data=return_data)

    today_income, today_count = IndexService.get_total_production(spot_no_list, start_time=None, end_time=None)
    return_data["history_income"] = float(today_income)
    return_data["history_count"] = today_count

    return BaseResponse(data=return_data)


@route_index.route("/seven_day_count", methods=["GET"])
def get_seven_day_count_data():
    agent = g.user
    agent_spot_list = AgentSpot.query.filter_by(agent_no=agent.id, status=1).all()
    if agent_spot_list:
        spot_no_list = [i.spot_no for i in agent_spot_list]
    else:
        return BaseResponse(data=[])

    spot_list = db.session.query(Spot).filter(Spot.id.in_(spot_no_list)).all()
    if spot_list:
        spot_data = {}
        for i in spot_list:
            spot_data[i.id] = i.spotname
    else:
        return BaseResponse(**ACCOUNT_AGENT_SPOT_NOT_EXIST)
    return_data = []

    seven_day, today = Helper.get_seven_date()
    filter_list = [
        Production.agent_total > 0,
        Production.created_at >= seven_day,
        Production.created_at < today,

    ]
    result = db.session.query(func.count(Production.id), Production.spot_id,
                              func.date_format(Production.created_at, "%Y-%m-%d")).filter(*filter_list).group_by(
        Production.spot_id, func.day(Production.created_at)).order_by(Production.created_at.asc()).all()
    tmp_data = {}
    for i in result:
        count = i[0]
        spot_id = i[1]
        created_at = i[2]
        if tmp_data.get(spot_id, None):
            tmp_data[spot_id].append({"date": created_at, "count": count, "spot_id": spot_id})
        else:
            tmp_data[spot_id] = [{"date": created_at, "count": count, }]
    for k, v in tmp_data.items():
        return_data.append({"spot_id": k, "spot_name": spot_data.get(k, spot_id), "count_data": v})
    return BaseResponse(data=return_data)


@route_index.route("/last_seven_day_count", methods=["GET"])
def get_last_seven_day_count_data():
    agent = g.user
    agent_spot_list = AgentSpot.query.filter_by(agent_no=agent.id, status=1).all()
    if agent_spot_list:
        spot_no_list = [i.spot_no for i in agent_spot_list]
    else:
        return BaseResponse(data=[])

    spot_list = db.session.query(Spot).filter(Spot.id.in_(spot_no_list)).all()
    if spot_list:
        spot_data = {}
        for i in spot_list:
            spot_data[i.id] = i.spotname
    else:
        return BaseResponse(**ACCOUNT_AGENT_SPOT_NOT_EXIST)
    return_data = []

    today = datetime.datetime.now().replace(hour=0, minute=0, second=0, microsecond=0)
    seven_day = today + datetime.timedelta(days=-7)
    last_seven_day = seven_day + datetime.timedelta(days=-7)

    filter_list = [
        Production.agent_total > 0,
        Production.created_at >= last_seven_day.strftime("%Y-%m-%d %H:%M:%S"),
        Production.created_at < seven_day.strftime("%Y-%m-%d %H:%M:%S"),

    ]
    result = db.session.query(func.count(Production.id), Production.spot_id,
                              func.date_format(Production.created_at, "%Y-%m-%d")).filter(*filter_list).group_by(
        Production.spot_id, func.day(Production.created_at)).order_by(Production.created_at.asc()).all()
    tmp_data = {}
    for i in result:
        count = i[0]
        spot_id = i[1]
        created_at = i[2]
        if tmp_data.get(spot_id, None):
            tmp_data[spot_id].append({"date": created_at, "count": count, "spot_id": spot_id})
        else:
            tmp_data[spot_id] = [{"date": created_at, "count": count, }]
    for k, v in tmp_data.items():
        return_data.append({"spot_id": k, "spot_name": spot_data.get(k, spot_id), "count_data": v})
    return BaseResponse(data=return_data)
