#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/10
@file: __init__.py.py
@function:
@modify:
"""

from flask import Flask

from myapps.pc_management.api.admin_portal import admin_route
from myapps.pc_management.api.place_portal import place_route
from myapps.pc_management.api.machine_portal import machine_route
from myapps.pc_management.api.file_protal import file_route
from myapps.pc_management.api.production_portal import production_route
from myapps.pc_management.api.hatch_portal import hatch_route
from myapps.pc_management.api.business_portal import business_route
from myapps.pc_management.api.rent_portal import rent_route
from myapps.pc_management.api.tallyman_portal import tallyman_route


def register_sukang_blueprint(app: Flask):
    prefix = "/pc_management"
    app.register_blueprint(admin_route, url_prefix=prefix + "/admin")
    app.register_blueprint(place_route, url_prefix=prefix + "/place")
    app.register_blueprint(machine_route, url_prefix=prefix + "/machine")
    app.register_blueprint(file_route, url_prefix=prefix + "/file")
    app.register_blueprint(production_route, url_prefix=prefix + "/production")
    app.register_blueprint(hatch_route, url_prefix=prefix + "/hatch")
    app.register_blueprint(business_route, url_prefix=prefix + "/business")
    app.register_blueprint(rent_route, url_prefix=prefix + "/rent")
    app.register_blueprint(tallyman_route, url_prefix=prefix + "/tallyman")
