# -*- coding: utf-8 -*-
import datetime
import logging
import time

from flask import Blueprint, jsonify, request, g
from config.base_config import MONGO_DATABASE_URI
from config.commen_config import LOGIN_TYPE

from models.base_model import db
from models.models import TallymanAccount, TallymanMachine, TallymanLoginRecord
from service.tallyman_service import TallymanService
from utils.error_code import TALLYMAN_ACCOUNT_EXIST, PHONE_NOT_VALID_ERROR, TOKEN_NOT_VALID_ERROR, PASSWORD_ERROR
from utils.jwt_util import verify_jwt, generate_jwt
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

tallyman_route = Blueprint('tallyman', __name__)


@tallyman_route.route('/test')
def test():
    ip = request.remote_addr
    return BaseResponse(**{'code': 200, 'msg': 'success!', 'data': ip})


@tallyman_route.route('/edit_password', methods=['GET', 'POST'])
def run_tallyman_edit_password():
    json_data = request.get_json()
    user_name = json_data.get('name', None)
    password = json_data.get('password', None)

    tallyman_info = g.user
    if not tallyman_info:
        return BaseResponse(**ACCOUNT_NOT_EXISTS_ERROR)

    if user_name:
        tallyman_info.user_name = user_name

    if password:
        tallyman_info.password = password
    db.session.add(tallyman_info)
    db.session.commit()
    return BaseResponse()


@tallyman_route.route('/add_account', methods=['GET', 'POST'])
def add_user():
    json_data = request.get_json()
    user_name = json_data['name'] if 'name' in json_data else 'SSW'
    phone = json_data['phone'] if 'phone' in json_data else None
    level = int(json_data['level']) if 'level' in json_data else 2
    password = json_data['password'] if 'password' in json_data else None
    comment = json_data['comment'] if 'comment' in json_data else ''

    tallyman = TallymanAccount.query.filter_by(phone=phone).first()
    if tallyman:
        if tallyman.status != -1:
            return jsonify(TALLYMAN_ACCOUNT_EXIST)

    else:
        tallyman = TallymanAccount()

    tallyman.user_no = "todo"
    tallyman.user_name = user_name
    tallyman.phone = phone
    tallyman.level = level
    tallyman.status = 1
    tallyman.comment = comment
    tallyman.created_at = datetime.datetime.now()
    tallyman.updated_at = datetime.datetime.now()
    if password:
        tallyman.password = password
    db.session.add(tallyman)
    db.session.commit()
    tallyman.user_no = "SK" + str(tallyman.id).zfill(6)
    db.session.add(tallyman)
    db.session.commit()

    machine_list = json_data.get("machine_list", [])
    if not machine_list:
        return BaseResponse()

    for i in machine_list:
        model = TallymanMachine()
        model.user_id = tallyman.id
        model.machine_no = i
        model.status = 1
        db.session.add(model)

    db.session.commit()
    return BaseResponse()


@tallyman_route.route('/delete_account', methods=['GET', 'POST'])
def delete_user():
    json_data = request.get_json()
    phone = json_data['phone']

    tallyman = TallymanAccount.query.filter_by(phone=phone).first()
    if not tallyman:
        return BaseResponse()

    agent_spot_info = TallymanMachine.query.filter_by(user_id=tallyman.id).all()
    for info in agent_spot_info:
        info.status = -1
        db.session.add(info)

        tallyman.status = -1
    db.session.add(tallyman)
    db.session.commit()

    return BaseResponse()


@tallyman_route.route('/login', methods=['GET', 'POST'])
def run_tallyman_login():
    cur_ip = request.remote_addr
    json_data = request.get_json()

    data = {}
    phone = json_data['phone']
    password = json_data['password']

    # 密码登录
    # 判断密码是否正确
    tallyman = TallymanAccount.query.filter_by(phone=phone, status=1).first()
    if not tallyman:
        return BaseResponse(**PHONE_NOT_VALID_ERROR)

    if tallyman.check_password(password) != True:
        return BaseResponse(**PASSWORD_ERROR)

    tallyman.last_login = datetime.datetime.now()
    db.session.add(tallyman)

    login_log = TallymanLoginRecord()
    login_log.phone = tallyman.phone
    login_log.ip = cur_ip
    login_log.last_login = tallyman.last_login
    login_log.login_type = LOGIN_TYPE['password']
    login_log.created_at = datetime.datetime.now()
    login_log.updated_at = datetime.datetime.now()
    db.session.add(login_log)
    db.session.commit()

    new_token = generate_jwt(payload={"user_no": tallyman.user_no}, expiry=time.time() + 24 * 60 * 60)
    data['token'] = new_token
    data['user_name'] = tallyman.user_name
    data['phone'] = tallyman.phone
    data['level'] = tallyman.level

    return BaseResponse(error_code=200, data=data)


@tallyman_route.route('/machine_list', methods=['GET', 'POST'])
def get_agent_module_list():
    machine_info = TallymanService.get_machine_info(g.user)

    return BaseResponse(data=machine_info)
