#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/12
@file: production_portal.py
@function:
@modify:
"""
import logging

from flask import Blueprint, g, request, jsonify

from models.base_model import db
from models.models import AdminPlace, Place, Production, Brand, AdminBrand, ProductionType, AdminProductionType, \
    AdminProduction
from utils.error_code import NO_PLACE_ERROR, NO_PRODUCTION_ERROR
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

production_route = Blueprint('production', __name__)


@production_route.route("production_list", methods=["POST"])
def run_production_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    keyword = json_data.get("keyword", None)

    admin = g.user
    select_sql = """select p.id, p.production_no, p.production_name, p.title, p.brand_id,p.production_type_id, p.price,p.original_price,
                    p.weight, p.weight_unit, p.expiration_date, p.expiration_date_unit, p.is_expiration_date,
                    p.weight_error, p.img, p.tags, p.content,p.summary, p.status,
                    brand.brand_name as brand_name, production_type.production_type_name as production_type_name
                    """
    count_sql = "select count(p.id) as total_count"
    from_sql = """  from production p 
                    left join brand on p.brand_id = brand.id
                    left join production_type on p.production_type_id = production_type.id
                    where p.id in ( select production_id from admin_production where 
                                                                    admin_production.user_id = {} and admin_production.status = 1
                                                                    )
                    
                         """.format(admin.id)

    where_sql = " "
    if keyword:
        where_sql += """
                    and CONCAT(p.production_name, brand_name,production_type_name, p.production_no) LIKE '%{keyword}%'

                        """.format(keyword=keyword)
    order_sql = "  ORDER BY p.id ASC, p.status ASC"
    limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    """
    select p.id, p.production_no, p.name, p.title, p.brand_id,p.production_type_id, p.price,p.original_price,
                    p.weight, p.weight_unit, p.expiration_date, p.expiration_date_unit, p.is_expiration_date,
                    p.weight_error, p.img, p.tags, p.content,p.summary, p.status,
                    brand.name as brand_name, production_type.name as production_type_name
    """
    return_data = []
    for info in result:
        return_data.append(
            {"production_name": info.production_name, "prodcution_id": info.id, "production_no": info.production_no,
             "title": info.title, "brand_id": info.brand_id, "brand_name": info.brand_name,
             "production_type_id": info.production_type_id, "production_type_name": info.production_type_name,
             "price": info.price, "original_price": info.original_price, "weight": info.weight,
             "weight_unit": info.weight_unit,
             "expiration_date": info.expiration_date, "expiration_date_unit": info.expiration_date_unit,
             "is_expiration_date": info.is_expiration_date,
             "weight_error": info.weight_error,
             "img": info.img, "tags": info.tags, "content": info.content,
             "summary": info.summary, "status": info.status,
             })

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@production_route.route("add_production", methods=["POST"])
def run_add_production():
    """

    :return:
    """
    json_data = request.get_json()
    production_name = json_data["production_name"]
    title = json_data.get("title", "")
    brand_id = json_data.get("brand_id", 0)
    production_type_id = json_data.get("production_type_id", 0)
    price = json_data.get("price", 0)
    original_price = json_data.get("original_price", 0)
    weight = json_data.get("weight", 0)
    weight_unit = json_data.get("weight_unit", "g")
    weight_error = json_data.get("weight_error", 0)
    expiration_date = json_data.get("expiration_date", 0)
    expiration_date_unit = json_data.get("expiration_date_unit", "月")
    is_expiration_date = json_data.get("is_expiration_date", 0)
    img = json_data.get("img", None)
    tags = json_data.get("tags", None)
    content = json_data.get("content", None)
    summary = json_data.get("summary", None)

    production_model = Production()
    production_model.production_no = "todo"
    production_model.production_name = production_name
    production_model.title = title
    production_model.brand_id = brand_id
    production_model.production_type_id = production_type_id
    production_model.price = price
    production_model.original_price = original_price
    production_model.weight = weight
    production_model.weight_unit = weight_unit
    production_model.weight_error = weight_error
    production_model.expiration_date = expiration_date
    production_model.expiration_date_unit = expiration_date_unit
    production_model.is_expiration_date = is_expiration_date
    production_model.img = img
    production_model.tags = tags
    production_model.content = content
    production_model.summary = summary
    db.session.add(production_model)
    db.session.commit()

    admin_production = AdminProduction()
    admin_production.user_id = g.user.id
    admin_production.user_no = g.user.user_no
    admin_production.production_id = production_model.id
    db.session.add(admin_production)

    production_model.production_no = "PD" + str(production_model.id).zfill(8)
    db.session.add(production_model)
    db.session.commit()
    return BaseResponse()


@production_route.route("edit_production", methods=["POST"])
def run_edit_production():
    """

    :return:
    """
    json_data = request.get_json()
    production_id = json_data["production_id"]
    production_name = json_data.get("production_name", None)
    title = json_data.get("title", None)
    brand_id = json_data.get("brand_id", None)
    production_type_id = json_data.get("production_type_id", None)
    price = json_data.get("price", None)
    original_price = json_data.get("original_price", None)
    weight = json_data.get("weight", None)
    weight_unit = json_data.get("weight_unit", None)
    weight_error = json_data.get("weight_error", None)
    expiration_date = json_data.get("expiration_date", None)
    expiration_date_unit = json_data.get("expiration_date_unit", None)
    is_expiration_date = json_data.get("is_expiration_date", None)
    img = json_data.get("img", None)
    tags = json_data.get("tags", None)
    content = json_data.get("content", None)
    summary = json_data.get("summary", None)

    production_model = Production.query.filter_by(id=production_id).first()
    if not production_model:
        return jsonify(NO_PRODUCTION_ERROR)
    if production_name:
        production_model.production_name = production_name
    if title:
        production_model.title = title
    if brand_id:
        production_model.brand_id = brand_id
    if production_type_id:
        production_model.production_type_id = production_type_id
    if price:
        production_model.price = price
    if original_price:
        production_model.original_price = original_price
    if weight:
        production_model.weight = weight
    if weight_unit:
        production_model.weight_unit = weight_unit
    if weight_error:
        production_model.weight_error = weight_error
    if expiration_date:
        production_model.expiration_date = expiration_date
    if expiration_date_unit:
        production_model.expiration_date_unit = expiration_date_unit
    if is_expiration_date:
        production_model.is_expiration_date = is_expiration_date
    if img:
        production_model.img = img
    if tags:
        production_model.tags = tags
    if content:
        production_model.content = content
    if summary:
        production_model.summary = summary
    db.session.add(production_model)
    db.session.commit()
    return BaseResponse()


@production_route.route("production_detail", methods=["POST"])
def get_production_detail():
    """

    :return:
    """
    json_data = request.get_json()
    production_id = json_data["production_id"]

    admin = g.user
    select_sql = """select p.id, p.production_no, p.production_name, p.title, p.brand_id,p.production_type_id, p.price,p.original_price,
                       p.weight, p.weight_unit, p.expiration_date, p.expiration_date_unit, p.is_expiration_date,
                       p.weight_error, p.img, p.tags, p.content,p.summary, p.status,
                       brand.brand_name as brand_name, production_type.production_type_name as production_type_name
                       """
    from_sql = """  from production p 
                    left join brand on p.brand_id = brand.id
                    left join production_type on p.production_type_id = production_type.id
                    where p.id in ( 
                               select production_id from admin_production where 
                               admin_production.user_id = {} and admin_production.status = 1
                               )
                     
                            """.format(admin.id)

    where_sql = "  and p.id={}".format(production_id)

    result = db.session.execute(select_sql + from_sql + where_sql).fetchall()
    if not result or len(result) != 1:
        return jsonify(NO_PRODUCTION_ERROR)

    info = result[0]

    return BaseResponse(
        data={"production_name": info.production_name, "prodcution_id": info.id, "production_no": info.production_no,
              "title": info.title, "brand_id": info.brand_id, "brand_name": info.brand_name,
              "production_type_id": info.production_type_id, "production_type_name": info.production_type_name,
              "price": info.price, "original_price": info.original_price, "weight": info.weight,
              "weight_unit": info.weight_unit,
              "expiration_date": info.expiration_date, "expiration_date_unit": info.expiration_date_unit,
              "is_expiration_date": info.is_expiration_date,
              "weight_error": info.weight_error,
              "img": info.img, "tags": info.tags, "content": info.content,
              "summary": info.summary, "status": info.status,
              })


@production_route.route("brand_list", methods=["POST"])
def run_brand_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    keyword = json_data.get("keyword", None)

    admin = g.user
    select_sql = """select b.id,  b.brand_name,b.status, b.img
                    """
    count_sql = "select count(b.id) as total_count"
    from_sql = """ from brand b where b.id in ( 
                                                    select brand_id from admin_brand where 
                                                    admin_brand.user_id = {} and admin_brand.status = 1
                                                    )
                         """.format(admin.id)

    where_sql = ""
    if keyword:
        where_sql += """
                    and CONCAT( b.brand_name) LIKE '%{keyword}%'
                        """.format(keyword=keyword)
    order_sql = "  ORDER BY b.id ASC, b.status ASC"
    limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    for info in result:
        return_data.append({"brand_id": info.id, "brand_name": info.brand_name, "status": info.status,
                            "img": info.img})

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@production_route.route("add_brand", methods=["POST"])
def run_add_brand():
    """

    :return:
    """
    json_data = request.get_json()
    brand_name = json_data["brand_name"]
    img = json_data.get("img", None)

    brand_model = Brand()
    brand_model.brand_name = brand_name
    brand_model.img = img
    db.session.add(brand_model)
    db.session.commit()
    db.session.commit()

    admin_brand = AdminBrand()
    admin_brand.user_id = g.user.id
    admin_brand.user_no = g.user.user_no
    admin_brand.brand_id = brand_model.id
    db.session.add(admin_brand)
    db.session.commit()

    return BaseResponse()


@production_route.route("edit_brand", methods=["POST"])
def run_edit_brand():
    """

    :return:
    """
    json_data = request.get_json()
    brand_id = json_data["brand_id"]
    brand_name = json_data.get("brand_name", None)
    img = json_data.get("img", None)
    status = json_data.get("status", None)

    brand_model = Brand.query.filter_by(id=brand_id).first()
    if not brand_model:
        return jsonify(NO_PRODUCTION_ERROR)
    if brand_name:
        brand_model.brand_name = brand_name
    if img:
        brand_model.img = img
    if status:
        brand_model.status = status
    db.session.add(brand_model)
    db.session.commit()
    return BaseResponse()


@production_route.route("brand_detail", methods=["POST"])
def get_brand_detail():
    """

    :return:
    """
    json_data = request.get_json()
    brand_id = json_data["brand_id"]

    admin = g.user
    select_sql = """select b.id,b.brand_name,b.status, b.img
                       """
    from_sql = """ from brand b """

    where_sql = " where b.id ={}".format(brand_id)

    result = db.session.execute(select_sql + from_sql + where_sql).fetchall()
    if not result or len(result) != 1:
        return jsonify(NO_PRODUCTION_ERROR)

    info = result[0]

    return BaseResponse(
        data={"brand_id": info.id, "brand_name": info.brand_name,
              "status": info.status, "img": info.img
              })


@production_route.route("production_type_list", methods=["POST"])
def run_production_type_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    keyword = json_data.get("keyword", None)

    admin = g.user
    select_sql = """select p.id,  p.production_type_name,p.status
                    """
    count_sql = "select count(p.id) as total_count"
    from_sql = """ from production_type p where p.id in ( 
                                                    select production_type_id from admin_production_type where 
                                                    admin_production_type.user_id = {} and admin_production_type.status = 1
                                                    )
                         """.format(admin.id)

    where_sql = " "
    if keyword:
        where_sql += """
                    and CONCAT( p.production_type_name) LIKE '%{keyword}%'
                        """.format(keyword=keyword)
    order_sql = "  ORDER BY p.id ASC, p.status ASC"
    limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    for info in result:
        return_data.append(
            {"production_type_id": info.id, "production_type_name": info.production_type_name, "status": info.status})

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@production_route.route("add_production_type", methods=["POST"])
def run_add_production_type():
    """

    :return:
    """
    json_data = request.get_json()
    production_type_name = json_data["production_type_name"]
    img = json_data.get("img", None)

    production_type_model = ProductionType()
    production_type_model.production_type_name = production_type_name
    production_type_model.img = img
    db.session.add(production_type_model)
    db.session.commit()
    db.session.commit()

    admin_production_type = AdminProductionType()
    admin_production_type.user_id = g.user.id
    admin_production_type.user_no = g.user.user_no
    admin_production_type.production_type_id = production_type_model.id
    db.session.add(admin_production_type)
    db.session.commit()

    return BaseResponse()


@production_route.route("edit_production_type", methods=["POST"])
def run_edit_production_type():
    """

    :return:
    """
    json_data = request.get_json()
    production_type_id = json_data["production_type_id"]
    production_type_name = json_data.get("production_type_name", None)
    status = json_data.get("status", None)

    production_type_model = ProductionType.query.filter_by(id=production_type_id).first()
    if not production_type_model:
        return jsonify(NO_PRODUCTION_ERROR)
    if production_type_name:
        production_type_model.production_type_name = production_type_name
    if status:
        production_type_model.status = status
    db.session.add(production_type_model)
    db.session.commit()
    return BaseResponse()


@production_route.route("production_type_detail", methods=["POST"])
def get_production_type_detail():
    """

    :return:
    """
    json_data = request.get_json()
    production_type_id = json_data["production_type_id"]

    admin = g.user
    select_sql = """select b.id,b.production_type_name,b.status
                       """
    from_sql = """ from production_type b """

    where_sql = " where b.id ={}".format(production_type_id)

    result = db.session.execute(select_sql + from_sql + where_sql).fetchall()
    if not result or len(result) != 1:
        return jsonify(NO_PRODUCTION_ERROR)

    info = result[0]

    return BaseResponse(
        data={"production_type_id": info.id, "production_type_name": info.production_type_name,
              "status": info.status,
              })
