# -*- coding: utf-8 -*-
import datetime
import logging
import time
from flask import Blueprint, jsonify, request, g
from pymongo import MongoClient, ASCENDING
from config.wechat_config import platform_config_list
from config.commen_config import LOGIN_TYPE, ACCOUNT_STATUS
from mongodb_collections.agent_modules import Modules, AdminModules
from service.admin_service import AdminService
from utils.error_code import ACCOUNT_AGENT_SPOT_NULL_ERROR, ACCOUNT_NOT_EXISTS_ERROR, \
    ACCOUNT_ALREADY_EXISTS_ERROR, ACCOUNT_ALREADY_DELETE_ERROR, AGNET_MODULES_ERROR, MODULES_NOT_EXISTS_ERROR, \
    OPERATE_LEVEL_ERROR, Param_Invalid_Error, COMMON_MONGO_ERROR
from utils.error_code import PHONE_NOT_NULL_ERROR, PHONE_NOT_VALID_ERROR, TOKEN_NOT_VALID_ERROR, \
    VERIFICATION_CODE_INVALID_ERROR, VERIFICATION_CODE_ERROR, PASSWORD_ERROR
from models.base_model import db, Base
from models.models import AdminAccount, AdminLoginRecord, AdminMachine, AdminPlace, Place, Business, AdminBusiness, \
    AdminOpenid
from utils.jwt_util import verify_jwt, generate_jwt
from utils.my_response import BaseResponse
from service.sms_service import SMSService
from utils.mytools import json2obj

logger = logging.getLogger(__name__)

admin_route = Blueprint('admin', __name__)


@admin_route.route('/test')
def test():
    ip = request.remote_addr
    return BaseResponse(**{'code': 200, 'msg': 'success!', 'data': ip})


@admin_route.route('/login', methods=['GET', 'POST'])
def user_login():
    token = request.headers.get('Authorization')
    platform = request.headers.get('platform')
    cur_ip = request.remote_addr
    json_data = request.get_json()

    data = {}
    phone = json_data['phone'] if 'phone' in json_data else None
    code = json_data['code'] if 'code' in json_data else None
    # login_type = json_data['type'] if 'type' in json_data else 1  # 1.验证码登录，2.密码登录
    login_type = 2
    if token:
        # token登录
        # "校验token"
        payload = verify_jwt(token)
        # "判断token的校验结果"
        if not payload:
            return BaseResponse(**TOKEN_NOT_VALID_ERROR)

        # "获取载荷中的信息赋值"
        user_id = payload.get('user_id')
        if not user_id:
            return BaseResponse(**TOKEN_NOT_VALID_ERROR)
        user_info = AdminAccount.query.filter_by(id=user_id, status=1).first()
    else:
        if login_type == 1:
            # 验证码登录
            # 判断验证码是否正确
            sms = SMSService()
            res = sms.verificate(phone, code)
            if res == -1:
                return BaseResponse(**VERIFICATION_CODE_INVALID_ERROR)
            elif res == -2:
                return BaseResponse(**VERIFICATION_CODE_ERROR)

            user_info = AdminAccount.query.filter_by(phone=phone, status=1).first()
            if not user_info:
                return BaseResponse(**PHONE_NOT_VALID_ERROR)
        else:
            # 密码登录
            # 判断密码是否正确
            user_info = AdminAccount.query.filter_by(phone=phone, status=1).first()
            if not user_info:
                return BaseResponse(**PHONE_NOT_VALID_ERROR)

            if not user_info.check_password(pasword=code):
                return jsonify(PASSWORD_ERROR)

    new_token = generate_jwt(payload={"user_id": user_info.id}, expiry=time.time() + 24 * 60 * 60)

    admin_log = AdminLoginRecord()
    admin_log.phone = user_info.phone
    admin_log.ip = cur_ip
    admin_log.platform = platform_config_list.index(platform)
    admin_log.last_login = datetime.datetime.now()
    admin_log.login_type = LOGIN_TYPE['token_login']
    admin_log.created_at = datetime.datetime.now()
    admin_log.updated_at = datetime.datetime.now()
    db.session.add(admin_log)
    db.session.commit()

    data['token'] = new_token
    data['user_name'] = user_info.user_name
    data['phone'] = user_info.phone
    data['level'] = user_info.level
    return BaseResponse(data=data)


@admin_route.route('/add_account', methods=['GET', 'POST'])
def add_user():
    admin = g.user
    json_data = request.get_json()
    user_name = json_data['user_name']
    phone = json_data['phone']
    level = int(json_data['level'])
    if level < admin.level:
        return jsonify(OPERATE_LEVEL_ERROR)
    password = json_data.get('password', "123456")
    comment = json_data.get('comment', "")
    parent_id = json_data.get("parent_id", admin.id)
    draw = json_data.get("draw", 0)
    business_id = json_data["business_id"]

    account = AdminAccount.query.filter_by(phone=phone).first()
    if account:
        if account.status != -1:
            return jsonify(account)

    else:
        account = AdminAccount()

    account.user_no = "todo"
    account.user_name = user_name
    account.phone = phone
    account.level = level
    account.draw = draw
    account.parent_id = parent_id
    account.status = 1
    account.comment = comment
    account.created_at = datetime.datetime.now()
    account.updated_at = datetime.datetime.now()
    if password is not None:
        account.password = password
    db.session.add(account)
    db.session.commit()
    account.user_no = "XX" + str(account.id).zfill(6)
    db.session.add(account)
    db.session.commit()

    AdminService.add_or_edit_admin_business(account, business_id)

    return BaseResponse()


@admin_route.route('/account_list', methods=["POST"])
def get_account_list():
    json_data = request.get_json()
    page = json_data.get("page", None)
    page_size = json_data.get("pageSize", None)
    keyword = json_data.get("keyword", None)

    return_data = AdminService.get_admin_account_list(keyword=keyword, page=page, page_size=page_size)

    return BaseResponse(return_data)


@admin_route.route('/account_detail', methods=["POST"])
def get_account_detail():
    json_data = request.get_json()
    phone = json_data["phone"]
    if phone == g.user.phone:
        admin_info = g.user
    else:
        result = AdminService.get_admin_account_list(phone=phone)
        if result["total_count"] != 1:
            return BaseResponse(**ACCOUNT_NOT_EXISTS_ERROR)
        admin_info = json2obj(result["list"][0])

    user_info = {
        "id": admin_info.id,
        "user_no": admin_info.user_no,
        "user_name": admin_info.user_name,
        "phone": admin_info.phone,
        "level": admin_info.level,
        "status": admin_info.status,
        "comment": admin_info.comment
    }

    business_list = db.session.query(Business).join(AdminBusiness, Business.id == AdminBusiness.business_id,
                                                    ).filter(Business.status == 1,
                                                             AdminBusiness.user_id == admin_info.id,
                                                             AdminBusiness.status == 1).all()
    user_info["business_list"] = []
    for i in business_list:
        user_info["business_list"].append({"business_id": i.id, "business_name": i.business_name})
    return BaseResponse(data=user_info)


@admin_route.route('/edit_account', methods=['GET', 'POST'])
def edit_user():
    json_data = request.get_json()
    old_phone = json_data['old_phone'] if 'old_phone' in json_data else None
    new_phone = json_data['new_phone'] if 'new_phone' in json_data else None
    user_name = json_data['user_name'] if 'user_name' in json_data else None
    password = json_data['password'] if 'password' in json_data else None
    comment = json_data['comment'] if 'comment' in json_data else None
    level = json_data['level'] if 'level' in json_data else None
    status = json_data['status'] if 'status' in json_data else None
    if not old_phone:
        return BaseResponse(error_code=-1, error_message='old phone is null')

    if not new_phone:
        return BaseResponse(**PHONE_NOT_NULL_ERROR)

    if not status:
        return BaseResponse(**Param_Invalid_Error)

    if old_phone == g.user.phone:
        admin_info = g.user
    else:
        result = AdminService.get_admin_account_list(phone=old_phone)
        if result["total_count"] != 1:
            return BaseResponse(**ACCOUNT_NOT_EXISTS_ERROR)
        admin = json2obj(result["list"][0])
        admin_info = AdminAccount.query.filter_by(id=admin.id).first()
        if not admin_info:
            return BaseResponse(**ACCOUNT_NOT_EXISTS_ERROR)
        if level and level > g.user.level:
            admin_info.level = level
        if status is not None:
            admin_info.status = status
        if comment is not None:
            admin_info.comment = comment

    if user_name is not None:
        admin_info.user_name = user_name
    if new_phone is not None:
        admin_info.phone = new_phone
    if password is not None:
        admin_info.password = password

    db.session.add(admin_info)
    db.session.commit()

    return BaseResponse()


@admin_route.route('/delete_account', methods=['GET', 'POST'])
def delete_user():
    json_data = request.get_json()
    phone = json_data['phone'] if 'phone' in json_data else None
    if not phone:
        return BaseResponse(**PHONE_NOT_NULL_ERROR)

    result = AdminService.get_admin_account_list(phone=phone)
    if result["total_count"] != 1:
        return BaseResponse(**ACCOUNT_NOT_EXISTS_ERROR)
    admin = json2obj(result["list"][0])
    admin_info = AdminAccount.query.filter_by(id=admin.id).first()
    if not admin_info:
        return BaseResponse(**ACCOUNT_NOT_EXISTS_ERROR)

    admin_info.status = ACCOUNT_STATUS['delete']
    db.session.add(admin_info)
    db.session.commit()

    return BaseResponse()


@admin_route.route('/edit_openid', methods=['GET', 'POST'])
def run_edit_openid():
    json_data = request.get_json()
    openids = json_data['openids']

    AdminOpenid.query.filter_by(user_id=g.user.id).update({"status": -1})
    for i in openids:
        openid = i["openid"]
        real_name = i["real_name"]
        rs = AdminOpenid.query.filter_by(user_id=g.user.id, openid=openid).first()
        if rs:
            rs.status = 1
            db.session.add(rs)
        else:
            ao_model = AdminOpenid()
            ao_model.user_id = g.user.id
            ao_model.user_no = g.user.user_no
            ao_model.openid = openid
            ao_model.real_name = real_name
            ao_model.status = 1
            db.session.add(ao_model)
    db.session.commit()
    return BaseResponse()


@admin_route.route('/openid_list', methods=['GET', 'POST'])
def run_openid_list():
    rs = AdminOpenid.query.filter_by(user_id=g.user.id, status=1).all()
    if rs:
        return BaseResponse(data={"list": [{"openid": x.openid, "real_name": x.real_name} for x in rs]})
    else:
        return BaseResponse(data={"list": []})
