#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@file: hatch_portal.py
"""
import logging

from flask import Blueprint, request, jsonify, g

from models.base_model import db
from models.models import Machine, Production, Hatch, RentDetail
from utils.error_code import MACHINE_NOT_EXIST_ERROR, HATCH_NOT_EXIST_ERROR
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

hatch_route = Blueprint('hatch', __name__)


@hatch_route.route('list', methods=["post"])
def get_production_list():
    json_data = request.get_json()
    machine_no = json_data["machine_no"]

    machine_info = Machine.query.filter_by(machine_no=machine_no, status=1).first()
    if not machine_info:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    hatch_list = Hatch.query.filter_by(machine_no=machine_no, status=1).order_by(Hatch.hatch_no.asc()).all()
    if not hatch_list:
        return jsonify(HATCH_NOT_EXIST_ERROR)

    tmp_dict = {}
    for i in hatch_list:
        if tmp_dict.get(i.production_id, None) is None:
            tmp_dict[i.production_id] = {
                "machine_no": i.machine_no,
                "hatch_no": [i.hatch_no],
                "production_id": i.production_id,
                "name": i.production_name,
                "title": i.title,
                "brand_id": i.brand_id,
                "brand_name": i.brand_name,
                "production_type_id": i.production_type_id,
                "production_type_name": i.production_type_name,
                "price": i.price,
                "original_price": i.original_price,
                "img": i.img,
                "tags": i.tags,
                "content": i.content,
                "summary": i.summary,
                "status": i.status,
                "count": i.left_count
            }
        else:
            tmp_dict[i.production_id]["count"] += i.left_count
            tmp_dict[i.production_id]["hatch_no"].append(i.hatch_no)
    hatch_data = list(tmp_dict.values())
    return BaseResponse(data=hatch_data)


@hatch_route.route('info', methods=["post"])
def get_production_info():
    json_data = request.get_json()
    machine_no = json_data["machine_no"]
    hatch_no = json_data["hatch_no"]

    machine_info = Machine.query.filter_by(machine_no=machine_no, status=1).first()
    if not machine_info:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    hatch_info = Hatch.query.filter_by(machine_no=machine_no, hatch_no=hatch_no).first()
    if not hatch_info:
        return jsonify(HATCH_NOT_EXIST_ERROR)

    hatch_data = {
        "machine_no": hatch_info.machine_no,
        "hatch_no": hatch_info.hatch_no,
        "production_id": hatch_info.production_id,
        "name": hatch_info.production_name,
        "title": hatch_info.title,
        "brand_id": hatch_info.brand_id,
        "brand_name": hatch_info.brand_name,
        "production_type_id": hatch_info.production_type_id,
        "production_type_name": hatch_info.production_type_name,
        "price": hatch_info.price,
        "original_price": hatch_info.original_price,
        "img": hatch_info.img,
        "tags": hatch_info.tags,
        "content": hatch_info.content,
        "summary": hatch_info.summary,
        "status": hatch_info.status,
        "count": hatch_info.left_count
    }

    return BaseResponse(data=hatch_data)


@hatch_route.route("/hatch_open", methods=["POST"])
def run_hatch_open():
    json_data = request.get_json()
    machine_no = json_data['machine_no']
    hatch_no = json_data['hatch_no']
    user_id = g.user.id
    rent_detail = RentDetail.query.filter(RentDetail.user_id == user_id, RentDetail.machine_no == machine_no,
                                          RentDetail.hatch_no == hatch_no,
                                          RentDetail.status != -1,
                                          RentDetail.is_take == 0).order_by(RentDetail.id.desc()).first()
    if rent_detail:
        # 查询到柜子中的物品 数量减一
        sql = "update hatch set left_count = left_count - 1 where machine_no = '{}' and hatch_no='{}'".format(
            machine_no, hatch_no)
        # 对订单中已经取出过的数量 + 1
        sql_updata = "update rent_detail set takeout_count = takeout_count + 1 where id = '{}'".format(rent_detail.id)
        db.session.execute(sql)
        db.session.commit()
        db.session.execute(sql_updata)
        db.session.commit()

        # 改变rentDatail中的is_take
        # 22-06-08 Author famon
        # 已取出的数量 和 订单数量一致才算取出
        if rent_detail.takeout_count == rent_detail.rent_count:
            rent_detail.is_take = 1
            db.session.add(rent_detail)

        # 当数量小于等于1时，将柜子物品状态改为已售空
        left_res = Hatch.query.filter(Hatch.hatch_no == hatch_no,
                                      Hatch.machine_no == machine_no).first()
        if left_res.left_count <= 0:
            left_res.status = 2
        # 执行语句
        db.session.add(left_res)
        db.session.commit()

    return BaseResponse()
