#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@file: hatch_portal.py
"""
import logging

from flask import Blueprint, request, jsonify, g

from models.base_model import db
from models.models import Machine, Production, Hatch, RentDetail
from utils.error_code import MACHINE_NOT_EXIST_ERROR, HATCH_NOT_EXIST_ERROR
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

machine_route = Blueprint('machine', __name__)


@machine_route.route('mac_upload', methods=["post"])
def run_machine_mac_upload():
    json_data = request.get_json()
    machine_no = json_data["machine_no"]
    mac = json_data["mac"]

    machine = Machine.query.filter_by(machine_no=machine_no, status=1).first()
    if not machine:
        return jsonify(MACHINE_NOT_EXIST_ERROR)
    machine.mac = mac
    db.session.add(machine)
    db.session.commit()
    return BaseResponse()


@machine_route.route('power_upload', methods=["post"])
def run_machine_power_upload():
    json_data = request.get_json()
    machine_no = json_data["machine_no"]
    power = json_data["power"]

    machine = Machine.query.filter_by(machine_no=machine_no, status=1).first()
    if not machine:
        return jsonify(MACHINE_NOT_EXIST_ERROR)
    machine.power = power
    db.session.add(machine)
    db.session.commit()
    return BaseResponse()


@machine_route.route('hatch_number_upload', methods=["post"])
def run_machine_hatch_number_upload():
    json_data = request.get_json()
    machine_no = json_data["machine_no"]
    hatch_number = json_data["hatch_number"]

    machine = Machine.query.filter_by(machine_no=machine_no, status=1).first()
    if not machine:
        return jsonify(MACHINE_NOT_EXIST_ERROR)
    machine.hatch_number = hatch_number
    db.session.add(machine)
    db.session.commit()
    return BaseResponse()


@machine_route.route('hatch_data_upload', methods=["post"])
def run_machine_hatch_data_upload():
    json_data = request.get_json()
    machine_no = json_data["machine_no"]
    hatch_data = json_data["in_stock"]

    machine = Machine.query.filter_by(machine_no=machine_no, status=1).first()
    if not machine:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    Hatch.query.filter(Hatch.hatch_no.in_(hatch_data)).update({"status": 1})
    db.session.commit()
    Hatch.query.filter(Hatch.hatch_no.notin_(hatch_data)).update({"status": 2})
    db.session.commit()
    return BaseResponse()


@machine_route.route('get_machine_no', methods=["post"])
def run_get_machine_no():
    json_data = request.get_json()
    qrcode_no = json_data["qrcode_no"]

    machine = Machine.query.filter_by(qrcode_no=qrcode_no, status=1).first()
    if machine:
        return BaseResponse(data={"machine_no": machine.machine_no, "status": machine.status})
    else:
        return jsonify(MACHINE_NOT_EXIST_ERROR)
