# -*- coding: utf-8 -*-
import datetime
import hashlib
import random
import time

from sqlalchemy.exc import SQLAlchemyError

from utils.Helper.Helper import get_format_date
from models.base_model import db
from models.feedback_models import Feedback, FeedbackImage


class FeedbackService():
    @staticmethod
    def getReplay(customer_id):
        sql = '''
            select feedbacks.id,feedbacks.remark, feedbacks.`status`, feedbacks.reply, feedbacks.created_at, feedback_images.url from feedbacks
            right join feedback_images on feedback_images.feedback_id = feedbacks.id where feedbacks.customer_id = '{customer_id}'
        '''.format(customer_id=customer_id)
        info = db.session.execute(sql)
        return info

    @staticmethod
    def create(customer_id, remark, telephone, pics):
        feedback = FeedbackService.createFeedbackStub(customer_id, remark, telephone)
        if feedback:
            try:
                db.session.add(feedback)
                db.session.commit()
            except SQLAlchemyError as e:
                raise e

            if len(pics) > 0:
                for item in pics:
                    feedback_imgs = FeedbackService.createFeedbackImage(feedback.id, item)
                    if feedback_imgs:
                        try:
                            db.session.add(feedback_imgs)
                            db.session.commit()
                        except SQLAlchemyError as e:
                            raise e

    @staticmethod
    def createFeedbackStub(customer_id, remark, telephone):
        feedback = Feedback()
        feedback.customer_id = customer_id
        feedback.remark = remark
        feedback.telephone = telephone
        feedback.status = 0
        feedback.created_at = datetime.datetime.now()
        feedback.updated_at = datetime.datetime.now()
        return feedback

    @staticmethod
    def createFeedbackImage(feedback_id, pic):
        feedbackImage = FeedbackImage()
        feedbackImage.url = pic
        feedbackImage.feedback_id = feedback_id
        feedbackImage.created_at = datetime.datetime.now()
        feedbackImage.updated_at = datetime.datetime.now()

        return feedbackImage

    @staticmethod
    def guid():
        timestamp = int(time.time())
        ranstr = random.randint(9999, 9999999999)

        return FeedbackService.MD5(str(timestamp) + str(ranstr)) + FeedbackService.MD5(str(ranstr))[0:8]

    @staticmethod
    def formReplayInfo(data):
        da = []
        for item in data:
            cur_data = {}
            cur_data['id'] = item.id
            cur_data['created_at'] = get_format_date(item.created_at)
            cur_data['remark'] = item.remark
            cur_data['status'] = '未处理' if item.status == 0 else '已处理'
            cur_data['reply'] = '暂无回复' if item.reply is None else item.reply
            urls = []
            urls.append(item.url)
            cur_data['urls'] = urls
            da.append(cur_data)
        return da

    @staticmethod
    def MD5(info):
        m = hashlib.md5()
        m.update(info.encode("utf-8"))
        return m.hexdigest()
