#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/12
@file: machine_portal.py
@function:
@modify:
"""
import logging

from flask import Blueprint, g, request, jsonify

from models.base_model import db
from models.models import AdminMachine, Machine
from utils.error_code import NO_PLACE_ERROR
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

machine_route = Blueprint('machine', __name__)


@machine_route.route("machine_list", methods=["GET"])
def run_machine_list():
    """

    :return:
    """
    admin = g.user
    admin_machine_list = AdminMachine.query.filter_by(admin_no=admin.id, status=1).all()
    if admin_machine_list:
        machine_no_list = [i.machine_no for i in admin_machine_list]
    else:
        return BaseResponse(data=[])

    machine_list = db.session.query(Machine).filter(Machine.id.in_(machine_no_list)).all()

    if machine_list:
        machine_data_list = [
            {"machine_name": i.machine_name, "machine_id": i.id, "address": i.address, "parent_id": i.parent_id} for i in
            machine_list]
        return BaseResponse(data=machine_data_list)
    else:
        return BaseResponse(data=[])


@machine_route.route("add_machine", methods=["GET"])
def run_add_machine():
    """

    :return:
    """
    json_data = request.get_json()
    machine_name = json_data["machine_name"]
    address = json_data.get("address", "")
    parent_id = json_data.get("parent_id", 0)

    machine_model = Machine()
    machine_model.machine_name = machine_name
    machine_model.address = address
    machine_model.parent_id = parent_id
    db.session.add(machine_model)

    db.session.commit()
    return BaseResponse()


@machine_route.route("edit_machine", methods=["GET"])
def run_edit_machine():
    """

    :return:
    """
    json_data = request.get_json()
    id = json_data["id"]
    machine_name = json_data.get("machine_name", "")
    address = json_data.get("address", "")
    parent_id = json_data.get("parent_id", 0)
    status = json_data.get("status", None)

    machine_model = Machine.query.filter_by(id=id).first()
    machine_model.machine_name = machine_name
    machine_model.address = address
    machine_model.parent_id = parent_id
    machine_model.status = status
    db.session.add(machine_model)
    db.session.commit()
    return BaseResponse()


@machine_route.route("machine_detail", methods=["GET"])
def get_machine_detail():
    """

    :return:
    """
    json_data = request.get_json()
    id = json_data["id"]

    machine_model = Machine.query.filter_by(id=id).first()
    if machine_model:
        return jsonify({"machine_name": machine_model.machine_name,
                        "address": machine_model.address,
                        "parent_id": machine_model.parent_id,
                        "status": machine_model.status, })
    else:
        return jsonify(NO_PLACE_ERROR)
