# -*- coding: utf-8 -*-
import datetime
import random

from sqlalchemy.exc import SQLAlchemyError
import logging

from utils.my_redis_cache import redis_client

logger = logging.getLogger(__name__)


class RentService(object):

    @staticmethod
    def create_order_no(prefix="R"):
        """
        生成订单号
        :return:
        """
        data_str = datetime.datetime.now().strftime('%Y%m%d%H%M%S')
        int_str = str(random.randint(1, 9999)).zfill(4)
        return prefix + data_str + int_str

    @staticmethod
    def create_order(rent_no, data, machine, platform, type=1):
        """
        生成订单数据
        :param data: 接口请求数据
        :param user_id: 用户id
        :param machine: 机柜
        :param type: 类型
        :return:
        """
        try:
            model = Rent()
            model.rent_no = rent_no
            model.number = data["number"]
            model.deposit = machine.deposit
            model.one_day_price = machine.one_day_price
            model.free_time = machine.free_time
            model.machine_id = machine.id
            model.customer_id = data["user_id"]
            model.add_time = datetime.datetime.now()
            model.spot_id = machine.spot_id
            model.business_id = machine.business_id
            model.rent_type = type
            model.mch_platform = platform
            prepay_id = redis_client.get(USER_RENT_PREPAY_ID + str(data["user_id"]) + rent_no)
            if prepay_id:
                model.prepay_id = prepay_id
            if data["power_type"]:
                model.power_type = data["power_type"]
                power_money = PowerMoney.query.filter_by(machine_id=machine.id,
                                                         power_type=data["power_type"]).first()
                model.one_day_price = machine.one_day_price if not power_money else power_money.total
            db.session.add(model)
            db.session.commit()
            return model

        except SQLAlchemyError as e:
            db.session.rollback()
            raise e

    @staticmethod


if __name__ == '__main__':
    rent = RentService.getMyRecord(15, 1, 10)
