#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@file: __init__.py.py
"""
from flask import Flask

from myapps.sukang24h.api.wx_auth_portal import wx_auth_route
from myapps.sukang24h.api.hatch_portal import hatch_route
from myapps.sukang24h.api.rent_portal import rent_route
from myapps.sukang24h.api.tallyman_portal import tallyman_route
from myapps.sukang24h.api.machine_portal import machine_route
from myapps.sukang24h.api.nfc_card_portal import nfc_card_route


def register_sukang_blueprint(app: Flask):
    prefix = "/sukang"
    app.register_blueprint(wx_auth_route, url_prefix=prefix + "/wx_auth")
    app.register_blueprint(hatch_route, url_prefix=prefix + "/hatch")
    app.register_blueprint(rent_route, url_prefix=prefix + "/rent")
    app.register_blueprint(tallyman_route, url_prefix=prefix + "/tallyman")
    app.register_blueprint(machine_route, url_prefix=prefix + "/machine")
    app.register_blueprint(nfc_card_route, url_prefix=prefix + "/nfc_card")
