#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@file: file_protal.py
"""
import logging
import uuid

from flask import Blueprint, request, jsonify

logger = logging.getLogger(__name__)

upload_route = Blueprint('upload', __name__)


@upload_route.route("/upload", methods=['POST'])
def upload_file():
    file = request.files["file"]
    filename = str(file.filename)
    if len(filename) >= 20:  # 限制文件名的长度必须在20个字符以内
        return jsonify({"error_code": "500", "error_message": "文件名长度超出了限制!"})
    else:
        if filename.find(".") >= 0:  # 查找文件中是否包含点这个字符
            filetype = file.filename.split(".")[1]  # 取出文件类型,后期做判断
            if filetype != None and filetype == "bmp":  # 后缀格式必须是bmp结尾
                uid = uuid.uuid4()  # 生成随机名称
                save_file_name = str(uid) + "." + filetype  # 拼接名称
                file.save(save_file_name)  # 保存文件
                return jsonify({"error_code": "0", "error_message": "文件上传成功 {}".format(save_file_name)})
        else:
            return jsonify({"error_code": "500", "error_message": "没有选择文件,或不是图片格式,上传失败!"})
