#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@file: file_protal.py
"""
import logging
import os
import uuid

from flask import Blueprint, request, jsonify, send_from_directory

from config.env_path_config import img_file_path
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

file_route = Blueprint('file', __name__)

ALLOWED_EXTENSIONS = ('pdf', 'png', 'jpg', 'jpeg', 'gif')


@file_route.route("/upload_img", methods=['POST'])
def run_upload_img():
    file = request.files["file"]
    filename = str(file.filename)
    if len(filename) >= 20:  # 限制文件名的长度必须在20个字符以内
        return jsonify({"error_code": "500", "error_message": "文件名长度超出了限制!"})
    else:
        if filename.find(".") >= 0:  # 查找文件中是否包含点这个字符
            filetype = file.filename.split(".")[1]  # 取出文件类型,后期做判断
            if filetype and filetype in ALLOWED_EXTENSIONS:  # 后缀格式必须是bmp结尾
                uid = uuid.uuid4()  # 生成随机名称
                save_file_name = str(uid) + "." + filetype  # 拼接名称
                file.save(os.path.join(img_file_path, save_file_name))  # 保存文件
                return BaseResponse(data={"filename": save_file_name})

        return jsonify({"error_code": "500", "error_message": "没有选择文件,或不是图片格式,上传失败!"})


@file_route.route('/img/<filename>', )
def run_download_img(filename):
    return send_from_directory(img_file_path, filename)
