import json
import logging
import re
import time

from flask import Blueprint, request, jsonify, g
from sqlalchemy import extract

from config.commen_config import USER_RENT_PREPAY_ID
from config.wechat_config import platform_appid_config_list, pay_config_list, NFC_PAY_CALLBCK_URL
from models.base_model import db
from models.models import NfcCard, NfcCardPayRecord, NfcCardPayRefund
from service.rent_service import RentService
from service.wechat_service import WeChatPayService
from utils.error_code import NFC_CARD_NOT_EXIST, NFC_CARD_ACTIVATED_ERROR, WE_MINIAPP_PAY_FAIL, NO_RENT_RECORD, \
    NO_NFC_CARD_ERROR
from utils.my_redis_cache import redis_client
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

card_edit_route = Blueprint('card_edit', __name__) #创建蓝图
#增
@card_edit_route.route("add",methods=["post"])
def card_add():
    json_data = request.get_json()
    card_no = json_data["card_no"]
    #如果有重复的卡，则报错

    card = NfcCard.query.filter_by(card_no=card_no, status=1).first()
    if card:
        return jsonify(RE_NFC_CARD_ERROR) #账号重复

    #先添加 添加一条行的记录
    newCard = NfcCard(card_no=card_no,status=0,money=0,limit_count=-1)
    db.session.add(newCard)
    db.session.commit()

    return BaseResponse()

#删
@card_edit_route.route("delete",methods=["post"])
def card_delete():
    json_data = request.get_json()
    card_no = json_data["card_no"]

    card = NfcCard.query.filter_by(card_no=card_no, status=1).first()
    if not card:
        return jsonify(NFC_CARD_NOT_EXIST)

    card.status = -1

    db.session.add(card)
    db.session.commit()

    return BaseResponse()

#查 列出所有用户 根据分页来展示
@card_edit_route.route("users_card",methods=["post"])
def card_users_card():
    json_data = request.get_json()
    page = json_data["page"]
    page_size = json_data["pageSize"]

    filter_list = [
        NfcCard.status.in_([1])
    ]


    total_count = NfcCard.query.filter(*filter_list).count()
    if not total_count:
        return BaseResponse(data=[], total=0, page=page, pageSize=page_size)
    cards = NfcCard.query.filter(*filter_list).offset((page - 1) * page_size).limit(page_size).all() #查询
    return_data = [] #返回的结果
    for card in cards:
        tmp_data = {
            "card_no": card.card_no,
            "nick_name": card.nick_name,
            "phone": card.phone,
            "money": card.money,
            "status": card.status,
        }
        return_data.append(tmp_data)
    return   BaseResponse(data=return_data, total=total_count, page=page, pageSize=page_size)

#根据卡号查询
@card_edit_route.route("found_user_card",methods=["post"])
def found_users_card():
    json_data = request.get_json()
    card_no = json_data["card_no"]

    filter_list = [
        NfcCard.card_no == card_no,
        NfcCard.status.in_([1])
    ]

    cards = NfcCard.query.filter(*filter_list).all()
    if not cards:
        return jsonify(NO_NFC_CARD_ERROR)

    return_data = []
    for card in cards:
        tmp_data = {
            "card_no": card.card_no,
            "nick_name": card.nick_name,
            "phone": card.phone,
            "money": card.money,
            "status": card.status,
        }
        return_data.append(tmp_data)

    return BaseResponse(data=return_data)


