#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@file: wx_auth.py
"""
import logging
import time

from flask import Blueprint, request, g, jsonify
from wechatpy.crypto import WeChatWxaCrypto

from config.commen_config import WX_SESSION_KEY
from config.wechat_config import platform_appid_config_dict, platform_appid_config_list
from models.base_model import db
from models.models import WxUser
from service.wechat_service import WxMPService
from utils.error_code import WX_LOGIN_DATA_ERROR, WX_LOGIN_CODE_ERROR, PHONE_NOT_BINDING_ERROR, TOKEN_EXPIRE_ERROR

from utils.jwt_util import generate_jwt
from utils.my_redis_cache import redis_client
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

wx_auth_route = Blueprint('wx_auth', __name__)


@wx_auth_route.route('/test', methods=['POST'])
def my_test():
    a = {'error_code': '0', 'error_message': 'Success'}
    return jsonify(a)


@wx_auth_route.route('/login_wx_mp', methods=['POST'])
def mini_login():
    """
    小程序登陆接口
    :return:
    """
    req = request.get_json()
    platform = req.get('platform')
    code = req.get('code')
    encrypted_data = req.get('encryptedData')
    iv = req.get('iv')

    if not code or not encrypted_data or not iv or not platform:
        return jsonify(WX_LOGIN_DATA_ERROR)

    app_id = platform_appid_config_dict.get(platform)
    logger.info(platform_appid_config_dict)
    wx_client = WxMPService(platform)
    user_session = wx_client.code_to_session(code)
    logger.info(user_session)
    if user_session is None:
        logger.info(WX_LOGIN_CODE_ERROR)
        return jsonify(WX_LOGIN_CODE_ERROR)

    try:
        user_info = WeChatWxaCrypto(user_session["session_key"], iv, app_id).decrypt_message(encrypted_data)
    except:
        try:
            session_key = redis_client.get(WX_SESSION_KEY + user_session["openid"])
            user_info = WeChatWxaCrypto(session_key, iv, app_id).decrypt_message(encrypted_data)
        except:
            return BaseResponse(error_code=500, error_message='user info decrypt error')

    is_new_user = 0
    wx_user_model = WxUser.query.filter_by(openid=user_session["openid"]).first()
    if not wx_user_model:
        wx_user_model = WxUser()
        wx_user_model.status = 1
        is_new_user = 1

    wx_user_model.mini_program_open_id = user_session["openid"]
    if user_session.get("unionid", None):
        wx_user_model.unionid = user_session["unionid"]
    wx_user_model.nick_name = user_info["nickName"]
    wx_user_model.gender = user_info["gender"]
    wx_user_model.language = user_info["language"]
    wx_user_model.avatar_url = user_info["avatarUrl"]
    wx_user_model.city = user_info["city"]
    wx_user_model.province = user_info["province"]
    wx_user_model.country = user_info["country"]
    # wx_user_model.platform = 1
    wx_user_model.platform = platform_appid_config_list.index(app_id)
    db.session.add(wx_user_model)
    db.session.commit()
    token = generate_jwt(payload={"user_id": wx_user_model.id}, expiry=time.time() + 24 * 60 * 60)
    return jsonify({
        'customer_id': wx_user_model.id,
        'token': token,
        'error_code': 0,
        "is_new_user": is_new_user
    })


@wx_auth_route.route('/checkPhone', methods=["POST"])
def check_phone():
    """
    验证手机号是否登陆过接口
    :return:
    """
    if not g.user.phone:
        return jsonify(PHONE_NOT_BINDING_ERROR)
    return BaseResponse(data={'phone_number': g.user.phone})


@wx_auth_route.route('/bindPhone', methods=['POST'])
def bind_phone():
    '''
    绑定手机号接口
    :return:
    '''
    req = request.get_json()
    encrypted_data = req.get('encryptedData', '')
    iv = req.get('iv', '')

    if not encrypted_data or not iv:
        logger.info(WX_LOGIN_DATA_ERROR)
        return BaseResponse(**WX_LOGIN_DATA_ERROR)

    user_info = WxUser.query.filter_by(id=g.user.id).first()
    if not user_info:
        return BaseResponse(**WX_LOGIN_DATA_ERROR)
    try:
        session_key = redis_client.get(WX_SESSION_KEY + user_info.mini_program_open_id)
        session_key = str(session_key, encoding='utf-8')
    except Exception:
        session_key = None
    if not session_key:
        return jsonify(TOKEN_EXPIRE_ERROR)
    try:
        app_id = platform_appid_config_list[g.user.platform]
        phone_info = WeChatWxaCrypto(session_key, iv, app_id).decrypt_message(
            encrypted_data)
    except Exception as e:
        logger.error(e)
        return BaseResponse(error_code=500, error_message='phone info decrypt error')
    user_info.phone = phone_info['phoneNumber']
    db.session.add(user_info)
    db.session.commit()
    return BaseResponse()
