# -*- coding: utf-8 -*-
import hashlib
import json
import random
import string
import requests
from itsdangerous import TimedJSONWebSignatureSerializer as Serializer, SignatureExpired, BadSignature

from utils.jwt_util import generate_jwt, verify_jwt
from models.user_models import CustomerModel as User


class UserService():
    @staticmethod
    def geneSalt(length=16):
        keylist = [random.choice((string.ascii_letters + string.digits)) for i in range(length)]
        return ("".join(keylist))

    @staticmethod
    def generate_auth_token(id, expiration=604800):
        """
        生成用户接口权限Token
        :param id: 用户ID
        :param expiration: 过期时间，默认用7*24*60*60
        :return:
        """
        result = generate_jwt(payload={"user_id": id}, expiry=expiration)
        return result

    @staticmethod
    def checkAuthCode(token=None):
        auth_info = token.split("#")
        if len(auth_info) != 2:
            return False

        try:
            user_info = User.query.filter_by(id=auth_info[1]).first()
        except Exception:
            return False

        if user_info is None:
            return False

        if auth_info[0] != UserService.geneAuthCode(user_info):
            return False

        if user_info.status != 1:
            return False

        return user_info

    @staticmethod
    def verify_auth_token(token):
        result = verify_jwt(token)

        return result


if __name__ == '__main__':
    print(UserService().generate_auth_token(21, 60000000))
