# -*- coding: utf-8 -*-
from utils.Helper.Helper import get_format_date
from models.guide_record_models import GuideRecordModel
from models.spot_models import Spot


class WeGuideService():
    @staticmethod
    def getMyRecord(customer_id, page, limit):
        record_list = \
            GuideRecordModel.query.filter(GuideRecordModel.customer_id == customer_id and GuideRecordModel.is_pay == 1).order_by(
                GuideRecordModel.pay_time.desc()).all()[page - 1: limit]
        return record_list

    @staticmethod
    def formatWeGuideRecordModel(weguide_info):
        data = []
        for item in weguide_info:
            cur_data = {}
            cur_data['address'] = Spot.query.filter_by(id=item.spot_id).first().spotname
            cur_data['guide_no'] = item.guide_no
            cur_data['total'] = item.total
            cur_data['real_total'] = item.real_total
            cur_data['pay_time'] = get_format_date(item.pay_time)
            data.append(cur_data)
        return data
