#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/12
@file: place_portal.py
@function:
@modify:
"""
import logging

from flask import Blueprint, g, request, jsonify

from models.base_model import db
from models.models import AdminPlace, Place
from utils.error_code import NO_PLACE_ERROR
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

place_route = Blueprint('place', __name__)


@place_route.route("place_list", methods=["POST"])
def run_place_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", None)
    page_size = json_data.get("pageSize", None)
    keyword = json_data.get("keyword", None)

    admin = g.user
    select_sql = "select place.place_name, place.address, place.parent_id,place.status, place.id "
    count_sql = "select count(place.id) as total_count"
    from_sql = " from place"

    if g.user.level == 1:
        where_sql = " where 0=0 "
    else:
        where_sql = """  where place.id in ( select place_id from admin_place where   
                                        admin_place.user_id = {} and admin_place.status = 1) """.format(admin.id)

    if keyword:
        where_sql += """
                    and CONCAT(place.place_name, place.address) LIKE '%{keyword}%'

                        """.format(keyword=keyword)
    order_sql = "  ORDER BY place.id ASC, place.status ASC"
    limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    for info in result:
        return_data.append(
            {"place_name": info.place_name, "place_id": info.id, "address": info.address, "parent_id": info.parent_id,
             "status": info.status
             })

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@place_route.route("add_place", methods=["POST"])
def run_add_place():
    """

    :return:
    """
    json_data = request.get_json()
    place_name = json_data["place_name"]
    address = json_data.get("address", "")
    parent_id = json_data.get("parent_id", 0)

    place_model = Place()
    place_model.place_name = place_name
    place_model.address = address
    place_model.parent_id = parent_id
    db.session.add(place_model)
    db.session.commit()
    admin_place = AdminPlace()
    admin_place.user_id = g.user.id
    admin_place.user_no = g.user.user_no
    admin_place.place_id = place_model.id
    db.session.add(admin_place)
    db.session.commit()
    return BaseResponse()


@place_route.route("edit_place", methods=["POST"])
def run_edit_place():
    """

    :return:
    """
    json_data = request.get_json()
    id = json_data["id"]
    place_name = json_data.get("place_name", "")
    address = json_data.get("address", "")
    parent_id = json_data.get("parent_id", 0)
    status = json_data.get("status", None)

    place_model = Place.query.filter_by(id=id).first()
    place_model.place_name = place_name
    place_model.address = address
    place_model.parent_id = parent_id
    place_model.status = status
    db.session.add(place_model)
    db.session.commit()
    return BaseResponse()


@place_route.route("place_detail", methods=["POST"])
def get_place_detail():
    """

    :return:
    """
    json_data = request.get_json()
    id = json_data["id"]

    place_model = Place.query.filter_by(id=id).first()
    if place_model:
        return BaseResponse(data={"place_name": place_model.place_name,
                                  "address": place_model.address,
                                  "parent_id": place_model.parent_id,
                                  "status": place_model.status, })
    else:
        return jsonify(NO_PLACE_ERROR)
