# -*- coding: utf-8 -*-
import base64
import datetime
import hashlib
import random
import string

from config.commen_config import ACCOUNT_STATUS
from models.models import AdminAccount
from models.base_model import db
from models.models import Place
# from models.user_models import AgentAccount
# from service.spot_service import SpotService


class AdminService():
    @staticmethod
    def gene_salt(length=16):
        key_list = [random.choice((string.ascii_letters + string.digits)) for i in range(length)]
        return ("".join(key_list))

    @staticmethod
    def gene_agent_code(agent_info, salt):
        """

        :param agent_info:
        :param salt:
        :return:
        """
        m = hashlib.md5()
        str = "%s-%s-%s-%s" % (agent_info.id, agent_info.user_name, agent_info.phone, salt)
        m.update(str.encode("utf-8"))
        return m.hexdigest()

    @staticmethod
    def gene_pwd(pwd, salt):
        """

        :param pwd:
        :param salt:
        :return:
        """
        m = hashlib.md5()
        str = "%s-%s" % (base64.encodebytes(pwd.encode("utf-8")), salt)
        m.update(str.encode("utf-8"))
        return m.hexdigest()

    @staticmethod
    def check_agent_token(token):
        """

        :param token:
        :return:
        """
        token = base64.b64decode(token).decode("utf-8")
        try:
            agent_info = AgentAccount.query.filter_by(access_token=token).first()
        except Exception as e:
            return 1

        if not agent_info:
            return 1

        s = token.split("#")
        if len(s) != 2:
            return 1

        if AgentService.gene_agent_code(agent_info, agent_info.salt) != s[0]:
            return 1

        if agent_info.expire_time < datetime.datetime.now():
            return 2

        return agent_info

    @staticmethod
    def create_agent_no():
        '''
        生成用户编号
        :return:
        '''
        ran_int = str(random.randint(1, 999999)).zfill(6)
        return 'ssw' + ran_int

    @staticmethod
    def get_spot_info(agent_info):
        """

        :param agent_info:
        :return:
        """
        spot_info = []
        infos = db.session.query(AgentSpot, Spot).join(
            Spot, Spot.id == AgentSpot.spot_no).filter(AgentSpot.agent_no == agent_info.id,
                                                       AgentSpot.status == ACCOUNT_STATUS['on_use']).all()
        for info in infos:
            cur_info = {}
            cur_info['id'] = info.Spot.id
            cur_info['spotname'] = info.Spot.spotname
            cur_info['letter'] = SpotService.get_pinyin(info.Spot.spotname)
            spot_info.append(cur_info)
        return spot_info
