# -*- coding: utf-8 -*-
import datetime
import time

import requests
import json

import wechatpy
from wechatpy import WeChatClient
from wechatpy.messages import ImageMessage

import logging

from wechatpy.session.redisstorage import RedisStorage

from config.commen_config import WX_ACCESS_TOKEN_EXPIRE, WX_ACCESS_TOKEN
from config.wechat_config import oa_id_config, platform_appid_config_list, oa_id_mini_program_dict, SXXJ_OA_CONFIG, \
    SXXJ_OA_TO_XT_MINI_PROGRAM_MAC_LIST, XT_CONFIG
from models.base_model import db
from models.machine_models import Machine
from models.user_models import CustomerModel
from utils.my_redis_cache import redis_client

logger = logging.getLogger(__name__)


class WXOAService(WeChatClient):
    """
    微信公众号服务
    """

    def __init__(self, config):
        session_interface = RedisStorage(
            redis_client,
            prefix="wx"
        )
        super(WXOAService, self).__init__(config["app_id"], config["app_secret"], session=session_interface)
        self.platform = platform_appid_config_list.index(self.appid)
        self.oa_id = config["oa_id"]

    @staticmethod
    def get_wxCode_token(oa_id):
        """

        :param oa_id:
        :return:
        """
        try:
            access_token_expire = redis_client.get(WX_ACCESS_TOKEN_EXPIRE + "" + oa_id)
            access_token = redis_client.get(WX_ACCESS_TOKEN + "" + oa_id)
            if access_token_expire and access_token:
                access_token_expire = int(float(str(access_token_expire, encoding="utf-8")))
                # access_token有效时间2小时（7200秒）,提前5分钟进行过期处理
                tmp_time = access_token_expire - int(time.time())
                if tmp_time < 300:
                    pass
                else:
                    return str(access_token, encoding="utf-8")
            oa_config = WXOAService.get_wx_oa_config_by_oa_id(oa_id)
            if oa_config is None:
                return None
            params = {"grant_type": "client_credential",
                      "appid": oa_config["app_id"],
                      "secret": oa_config["app_secret"]
                      }
            url = 'https://api.weixin.qq.com/cgi-bin/token'
            req = requests.get(url, params=params)
            res = json.loads(req.text)
            access_token = res["access_token"]
            access_token_expire = res["expires_in"]
            redis_client.set(WX_ACCESS_TOKEN + "" + oa_id, access_token)
            redis_client.set(WX_ACCESS_TOKEN_EXPIRE + "" + oa_id, int(time.time() + int(access_token_expire)))
            return access_token
        except Exception as e:
            print(e)
            return None

    @staticmethod
    def get_wx_oa_config_by_oa_id(oa_id):
        """

        :param oa_id:
        :return:
        """
        return oa_id_config.get(oa_id, None)

    def event_handler(self, message):
        if message.event.startswith("subscribe"):
            to_user = message.target
            from_user = message.source
            create_time = message.create_time

            customer_info = CustomerModel.query.filter_by(openid=from_user, status=1).first()
            if not customer_info:
                # 用户不存在，绑定用户
                model_user = CustomerModel()
                model_user.openid = from_user
                model_user.platform = self.platform
                model_user.status = 1
                db.session.add(model_user)
                db.session.commit()

            if message.event == "subscribe_scan":
                mac_no = message.scene_id
                ticket = message.ticket
                machine = Machine.query.filter_by(mac_no=mac_no).first()
                if machine:
                    self.send_rent_template(to_user, from_user, mac_no, create_time, machine)
                    return_data = None
                    return return_data
            return_data = """
                <xml>
                  <ToUserName><![CDATA[{toUser}]]></ToUserName>
                  <FromUserName><![CDATA[{fromUser}]]></FromUserName>
                  <CreateTime>{createTime}</CreateTime>
                  <MsgType><![CDATA[text]]></MsgType>
                  <Content><![CDATA[{content}]]></Content>
                </xml>
            """.format(toUser=from_user, fromUser=to_user, createTime=int(time.time()),
                       content="二维码信息不正确，无法正常使用，可联系客服电话400-110-7981进行咨询")
            return return_data
        elif message.event == 'unsubscribe':
            return None

        elif message.event == "scan":
            to_user = message.target
            from_user = message.source
            create_time = message.create_time
            mac_no = message.scene_id
            ticket = message.ticket

            if mac_no and ticket:
                machine = Machine.query.filter_by(mac_no=mac_no).first()
                if machine:
                    self.send_rent_template(to_user, from_user, mac_no, create_time, machine)
                    return_data = None
                    return return_data
            return_data = """
                            <xml>
                              <ToUserName><![CDATA[{toUser}]]></ToUserName>
                              <FromUserName><![CDATA[{fromUser}]]></FromUserName>
                              <CreateTime>{createTime}</CreateTime>
                              <MsgType><![CDATA[text]]></MsgType>
                              <Content><![CDATA[{content}]]></Content>
                            </xml>
                        """.format(toUser=from_user, fromUser=to_user, createTime=int(time.time()),
                                   content="二维码信息不正确，无法正常使用，可联系客服电话400-110-7981进行咨询")
            return return_data
        elif message.event == "templatesendjobfinish":
            return ""
        else:
            return None

    @classmethod
    def send_welcome_template(cls, oa_id, open_id, mac_no, createtime, machine):
        token = cls.get_wxCode_token(oa_id)
        url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token={}".format(token)
        post_data = {
            "touser": open_id,
            "miniprogram": {
                "appid": "wxa66199e581b19d51",
                "pagepath": "pages/Index/Index?machine_no={}".format(mac_no)
            },
            "data": {
                "first": {
                    "value": "欢迎扫码使用灰兔智能导游讲解器",
                },
                "keyword1": {
                    "value": "{}".format(
                        datetime.datetime.fromtimestamp(int(createtime)).strftime("%Y-%m-%d %H:%M:%S")),
                },
                "keyword2": {
                    "value": machine.short_address if machine.short_address else "",
                },
                "remark": {
                    "value": "点击详情进入小程序租借使用",
                }
            }
        }
        if oa_id == "gh_598e6bc39f09":
            post_data["template_id"] = "4pNc9IknD3ilNWMt3AJHxYOloFQzFhtwsvcrufZUtEU"
        elif oa_id == "gh_c3bea8443020":
            post_data["template_id"] = "ysPWD-ZobNas37byJWH-NvOjnJ-p5cAIuVGYGEvTPHw"
        else:
            return None
        post_data = json.dumps(post_data, ensure_ascii=False)
        result = requests.post(url=url, data=post_data.encode('utf-8'), verify=None)
        logger.info(result.text)

    @classmethod
    def send_scan_template(cls, oa_id, open_id, mac_no, createtime, machine):
        """

        :param oa_id:
        :param open_id:
        :param mac_no:
        :param createtime:
        :param machine:
        :return:
        """
        token = cls.get_wxCode_token(oa_id)
        url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token={}".format(token)
        post_data = {
            "touser": open_id,
            "miniprogram": {
                "appid": "wxa66199e581b19d51",
                "pagepath": "pages/Index/Index?machine_no={}".format(mac_no)
            },
            "data": {
                "first": {
                    "value": "欢迎扫码使用灰兔智能导游讲解器",
                },
                "keyword1": {
                    "value": "{}".format(
                        datetime.datetime.fromtimestamp(int(createtime)).strftime("%Y-%m-%d %H:%M:%S")),
                },
                "keyword2": {
                    "value": machine.short_address if machine.short_address else "",
                },
                "remark": {
                    "value": "点击详情进入小程序租借使用",
                }
            }
        }
        if oa_id == "gh_598e6bc39f09":
            post_data["template_id"] = "4pNc9IknD3ilNWMt3AJHxYOloFQzFhtwsvcrufZUtEU"
        elif oa_id == "gh_c3bea8443020":
            post_data["template_id"] = "ysPWD-ZobNas37byJWH-NvOjnJ-p5cAIuVGYGEvTPHw"
        else:
            return None
        post_data = json.dumps(post_data, ensure_ascii=False)
        result = requests.post(url=url, data=post_data.encode('utf-8'), verify=None)
        logger.info(result.text)

    def get_media_list(self, media_type):
        result = self.material.batchget(media_type=media_type)
        return result

    def push_image_message(self, msg):
        from wechatpy.replies import ImageReply
        # ImageMessage
        result = self.material.batchget()
        reply = ImageReply(message=msg)
        reply.media_id = 'image media id'
        # 转换成 XML
        xml = reply.render()

    def send_rent_message(self, to_user, from_user, mac_no, create_time, machine):

        content = """您终于来了，晓兔在此恭候多时，感谢关注晓兔
        
欢迎使用灰兔智能讲解器，游玩怎能少了讲解陪伴，来听我聊聊景点故事吧。
        
你可以通过我：

1.联系客服人员

2.高端定制游：会议、招待、住宿、婚礼、园林包场、皆可定制

————————————————————————
想了解详情小伙伴可扫码联系客服进行咨询。

<a href="http://www.qq.com" data-miniprogram-appid="wxa66199e581b19d51" data-miniprogram-path="pages/Index/Index?machine_no={mac_id}">点击跳小程序</a>
        """.format(mac_id=mac_no)

        result = self.message.send_text(from_user, content)
        logger.info(result)

    def send_rent_template(self, to_user, from_user, mac_no, create_time, machine):
        """

        :param to_user:
        :param from_user:
        :param mac_no:
        :param create_time:
        :param machine:
        :return:
        """
        color = "#CD0000"
        mini_program_data = oa_id_mini_program_dict[self.oa_id]
        if self.oa_id == SXXJ_OA_CONFIG["oa_id"] and mac_no in SXXJ_OA_TO_XT_MINI_PROGRAM_MAC_LIST:
            mini_program_data["app_id"] = XT_CONFIG["app_id"]

        miniprogram = {
            "appid": mini_program_data["app_id"],
            "pagepath": "pages/Index/Index?machine_no={}".format(mac_no)
        }
        data = {
            "first": {
                "value": "欢迎扫码使用智能导游讲解器"
            },
            "keyword1": {
                "value": "{}".format(
                    create_time.strftime("%Y-%m-%d %H:%M:%S")),
            },
            "keyword2": {
                "value": machine.short_address if machine.short_address else "",
            },
            "remark": {
                "value": "点击详情进入小程序租借使用",
                "color": color
            }
        }
        if self.oa_id == "gh_598e6bc39f09":
            template_id = "4pNc9IknD3ilNWMt3AJHxYOloFQzFhtwsvcrufZUtEU"
        elif self.oa_id == "gh_c3bea8443020":
            template_id = "ysPWD-ZobNas37byJWH-NvOjnJ-p5cAIuVGYGEvTPHw"
        elif self.oa_id == "gh_b2a7d67e5686":
            template_id = "1gCjOrtWM66gMkyKyeuS_kdempehLye0DGutxx_GDyM"  # 随心晓见
        else:
            template_id = ""
        result = self.message.send_template(from_user, template_id, data, mini_program=miniprogram)
        logger.info(result)

    def send_rent_mini_program(self, to_user, from_user, mac_no, create_time, machine):

        mini_program_data = oa_id_mini_program_dict[self.oa_id]
        if self.oa_id == SXXJ_OA_CONFIG["oa_id"] and mac_no in SXXJ_OA_TO_XT_MINI_PROGRAM_MAC_LIST:
            mini_program_data["app_id"] = XT_CONFIG["app_id"]

        mini_program = {
            "title": "欢迎使用灰兔智能",
            "appid": mini_program_data["app_id"],
            "pagepath": "pages/Index/Index?machine_no={}".format(mac_no),
            "thumb_media_id": mini_program_data["thumb_media_id"],
        }
        result = self.message.send_mini_program_page(from_user, mini_program)
