#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/12
@file: place_portal.py
@function:
@modify:
"""
import logging

from flask import Blueprint, g, request, jsonify

from models.base_model import db
from models.models import AdminPlace, Place
from utils.error_code import NO_PLACE_ERROR
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

place_route = Blueprint('place', __name__)


@place_route.route("place_list", methods=["POST"])
def run_place_list():
    """

    :return:
    """
    admin = g.user
    admin_place_list = AdminPlace.query.filter_by(user_id=admin.id, status=1).all()
    if admin_place_list:
        place_id_list = [i.place_id for i in admin_place_list]
    else:
        return BaseResponse(data=[])

    place_list = db.session.query(Place).filter(Place.id.in_(place_id_list)).all()

    if place_list:
        place_data_list = [
            {"place_name": i.place_name, "place_id": i.id, "address": i.address, "parent_id": i.parent_id} for i in
            place_list]
        return BaseResponse(data=place_data_list)
    else:
        return BaseResponse(data=[])


@place_route.route("add_place", methods=["POST"])
def run_add_place():
    """

    :return:
    """
    json_data = request.get_json()
    place_name = json_data["place_name"]
    address = json_data.get("address", "")
    parent_id = json_data.get("parent_id", 0)

    place_model = Place()
    place_model.place_name = place_name
    place_model.address = address
    place_model.parent_id = parent_id
    db.session.add(place_model)
    db.session.commit()
    admin_place = AdminPlace()
    admin_place.user_id = g.user.id
    admin_place.user_no = g.user.user_no
    admin_place.place_id = place_model.id
    admin_place.place_id = place_model.id
    db.session.add(admin_place)
    db.session.commit()
    return BaseResponse()


@place_route.route("edit_place", methods=["POST"])
def run_edit_place():
    """

    :return:
    """
    json_data = request.get_json()
    id = json_data["id"]
    place_name = json_data.get("place_name", "")
    address = json_data.get("address", "")
    parent_id = json_data.get("parent_id", 0)
    status = json_data.get("status", None)

    place_model = Place.query.filter_by(id=id).first()
    place_model.place_name = place_name
    place_model.address = address
    place_model.parent_id = parent_id
    place_model.status = status
    db.session.add(place_model)
    db.session.commit()
    return BaseResponse()


@place_route.route("place_detail", methods=["POST"])
def get_place_detail():
    """

    :return:
    """
    json_data = request.get_json()
    id = json_data["id"]

    place_model = Place.query.filter_by(id=id).first()
    if place_model:
        return jsonify({"place_name": place_model.place_name,
                        "address": place_model.address,
                        "parent_id": place_model.parent_id,
                        "status": place_model.status, })
    else:
        return jsonify(NO_PLACE_ERROR)
