#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/12
@file: place_portal.py
@function:
@modify:
"""
import logging

from flask import Blueprint, g, request, jsonify

from models.base_model import db
from models.models import AdminPlace, Place, Business, AdminBusiness
from utils.error_code import NO_PLACE_ERROR, NO_BUSINESS_ERROR
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

business_route = Blueprint('business', __name__)


@business_route.route("business_list", methods=["POST"])
def run_business_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    keyword = json_data.get("keyword", None)

    admin = g.user
    select_sql = "select business.business_name,business.status, business.id "
    count_sql = "select count(business.id) as total_count"
    from_sql = """ from business  """

    if g.user.level == 1:
        where_sql = " where 0=0 "
    else:
        where_sql = """  where business.id in (
                                        select business_id from admin_business where 
                                        admin_business.user_id = {} and admin_business.status = 1
                                    )""".format(admin.id)
    if keyword:
        where_sql += """ and CONCAT(business.business_name) LIKE '%{keyword}%' """.format(keyword=keyword)

    order_sql = "  ORDER BY business.id ASC, business.status ASC"
    limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    for info in result:
        return_data.append({"business_name": info.business_name, "business_id": info.id, "status": info.status})

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@business_route.route("add_business", methods=["POST"])
def run_add_place():
    """

    :return:
    """
    json_data = request.get_json()
    business_name = json_data["business_name"]

    business_model = Business()
    business_model.business_name = business_name
    db.session.add(business_model)
    db.session.commit()

    admin_business = AdminBusiness()
    admin_business.user_id = g.user.id
    admin_business.user_no = g.user.user_no
    admin_business.business_id = business_model.id
    db.session.add(admin_business)
    db.session.commit()
    return BaseResponse()


@business_route.route("edit_business", methods=["POST"])
def run_edit_business():
    """

    :return:
    """
    json_data = request.get_json()
    business_id = json_data["business_id"]
    business_name = json_data.get("business_name", "")
    status = json_data.get("status", None)

    business_model = Business.query.filter_by(id=business_id).first()
    if business_name:
        business_model.business_name = business_name
    if status:
        business_model.status = status
    db.session.add(business_model)
    db.session.commit()
    return BaseResponse()


@business_route.route("business_detail", methods=["POST"])
def get_business_detail():
    """

    :return:
    """
    json_data = request.get_json()
    business_id = json_data["business_id"]

    business_model = Business.query.filter_by(id=business_id).first()
    if business_model:
        return BaseResponse(data={"business_name": business_model.business_name,
                                  "status": business_model.status, })
    else:
        return jsonify(NO_BUSINESS_ERROR)
