# -*- coding: utf-8 -*-
import logging

from models.models import TallymanMachine, Machine, Hatch

logger = logging.getLogger(__name__)


class TallymanService(object):
    @classmethod
    def get_machine_list(cls, tallyman):
        machine_infos = Machine.query.join(TallymanMachine,
                                           TallymanMachine.machine_no == Machine.machine_no).filter(
            TallymanMachine.user_id == tallyman.id, TallymanMachine.status == 1).all()

        # machine_infos = db.session.query(Machine).join(TallymanMachine,
        #                                                TallymanMachine.machine_no == Machine.machine_no).filter(
        #     TallymanMachine.user_id == tallyman.id, TallymanMachine.status == 1).all()

        return_data = []
        for tmp_machine in machine_infos:
            cur_machine = {}
            cur_machine['machine_no'] = tmp_machine.machine_no
            cur_machine['short_address'] = tmp_machine.short_address
            cur_machine['address'] = tmp_machine.address
            cur_machine['place_id'] = tmp_machine.place_id
            cur_machine['empty_number'] = Hatch.query.filter(Hatch.machine_no == tmp_machine.machine_no,
                                                             Hatch.status == 2).count()
            return_data.append(cur_machine)
        return return_data

    @classmethod
    def get_machine_info(cls, tallyman, machine_no):
        machine_info = Machine.query.join(
            TallymanMachine,
            TallymanMachine.machine_no == Machine.machine_no
        ).filter(
            TallymanMachine.user_id == tallyman.id, TallymanMachine.status == 1,
            Machine.machine_no == machine_no
        ).first()
        if not machine_info:
            return None

