#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/12
@file: machine_portal.py
@function:
@modify:
"""
import logging

from flask import Blueprint, g, request, jsonify

from config.commen_config import DISCOUNTS_TYPES
from models.base_model import db
from models.models import AdminMachine, Machine, Hatch
from utils.error_code import MACHINE_NOT_EXIST_ERROR, HATCH_COUNT_MAX_ERROR, HATCH_NO_DUPLICATE_ERROR
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

hatch_route = Blueprint('hatch', __name__)


@hatch_route.route("hatch_list", methods=["POST"])
def run_hatch_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", None)
    page_size = json_data.get("pageSize", None)
    keyword = json_data.get("keyword", None)

    admin = g.user
    select_sql = """select hatch.machine_no, hatch.hatch_no,hatch.production_id,hatch.production_name,hatch.title,hatch.left_count,
                    hatch.total_count,hatch.brand_id,hatch.brand_name,hatch.production_type_id,hatch.production_type_name,
                    hatch.price,hatch.original_price, hatch.weight,hatch.weight_unit,hatch.weight_error,
                    hatch.expiration_date,hatch.expiration_date_unit,hatch.is_expiration_date,
                    hatch.img, hatch.tags, hatch.content,hatch.summary,hatch.status
        """
    count_sql = "select count(hatch.id) as total_count"
    from_sql = """ from hatch
                        where hatch.machine_no in ( select machine_no from admin_machine where  
                        admin_machine.user_id = {user_id} and admin_machine.status = 1)  
                         """.format(user_id=admin.id)

    where_sql = " "
    if keyword:
        where_sql += """
                        and CONCAT(hatch.machine_no,ifnull(hatch.brand_name,''), ifnull(hatch.production_type_name,'')) 
                        LIKE '%{keyword}%'

                            """.format(keyword=keyword)
    order_sql = "  ORDER BY hatch.id ASC, hatch.status ASC"
    limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count
    print(select_sql + from_sql + where_sql + order_sql + limit_sql)
    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    for info in result:
        return_data.append(
            {"production_name": info.production_name, "production_id": info.production_id,
             "machine_no": info.machine_no,
             "hatch_no": info.hatch_no,
             "left_count": info.left_count,
             "total_count": info.total_count,
             "title": info.title, "brand_id": info.brand_id, "brand_name": info.brand_name,
             "production_type_id": info.production_type_id, "production_type_name": info.production_type_name,
             "price": info.price, "original_price": info.original_price, "weight": info.weight,
             "weight_unit": info.weight_unit,
             "expiration_date": info.expiration_date, "expiration_date_unit": info.expiration_date_unit,
             "is_expiration_date": info.is_expiration_date,
             "weight_error": info.weight_error,
             "img": info.img, "tags": info.tags, "content": info.content,
             "summary": info.summary, "status": info.status,
             })

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@hatch_route.route("add_hatch", methods=["POST"])
def run_add_machine():
    """

    :return:
    """
    json_data = request.get_json()
    machine_no = json_data["machine_no"]
    admin_machine = AdminMachine.query.filter_by(machine_no=machine_no, user_id=g.user.id, status=1).first()
    if not admin_machine:
        return jsonify(MACHINE_NOT_EXIST_ERROR)
    machine = Machine.query.filter_by(machine_no=machine_no, status=1).first()
    if not machine:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    hatch_num = machine.hatch_number
    hatchs = Hatch.query.filter_by(machine_no=machine_no).all()
    if len(hatchs) >= hatch_num:
        return jsonify(HATCH_COUNT_MAX_ERROR)

    hatch_no = json_data["hatch_no"]
    for i in hatchs:
        if i.hatch_no == hatch_no:
            return jsonify(HATCH_NO_DUPLICATE_ERROR)

    production_id = json_data["production_id"]
    production_name = json_data["production_name"]
    title = json_data.get("title", "")
    brand_id = json_data.get("brand_id", 0)
    production_type_id = json_data.get("production_type_id", 0)
    price = json_data.get("price", 0)
    original_price = json_data.get("original_price", 0)
    weight = json_data.get("weight", 0)
    weight_unit = json_data.get("weight_unit", "g")
    weight_error = json_data.get("weight_error", 0)
    expiration_date = json_data.get("expiration_date", 0)
    expiration_date_unit = json_data.get("expiration_date_unit", "月")
    is_expiration_date = json_data.get("is_expiration_date", 0)
    img = json_data.get("img", None)
    tags = json_data.get("tags", None)
    content = json_data.get("content", None)
    summary = json_data.get("summary", None)

    hatch_model = Hatch()
    hatch_model.production_id = production_id
    hatch_model.production_name = production_name
    hatch_model.title = title
    hatch_model.brand_id = brand_id
    hatch_model.production_type_id = production_type_id
    hatch_model.price = price
    hatch_model.original_price = original_price
    hatch_model.weight = weight
    hatch_model.weight_unit = weight_unit
    hatch_model.weight_error = weight_error
    hatch_model.expiration_date = expiration_date
    hatch_model.expiration_date_unit = expiration_date_unit
    hatch_model.is_expiration_date = is_expiration_date
    hatch_model.img = img
    hatch_model.tags = tags
    hatch_model.content = content
    hatch_model.summary = summary
    db.session.add(hatch_model)
    db.session.commit()
    return BaseResponse()


@hatch_route.route("edit_machine", methods=["POST"])
def run_edit_machine():
    """

    :return:
    """
    json_data = request.get_json()
    machine_no = json_data["machine_no"]
    address = json_data.get("address", None)
    device_id = json_data.get("device_id", None)
    qrcode_no = json_data.get("qrcode_no", None)
    mac = json_data.get("mac", None)
    power = json_data.get("power", None)
    hatch_number = json_data.get("hatch_number", None)
    place_id = json_data.get("place_id", None)
    type = json_data.get("type", None)
    status = json_data.get("status", None)
    discounts_id = json_data.get("discounts_id", None)

    machine_model = Machine.query.filter_by(machine_no=machine_no).first()
    if not machine_model:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    if device_id:
        machine_model.device_id = device_id
    if qrcode_no:
        machine_model.qrcode_no = qrcode_no
    if mac:
        machine_model.mac = mac
    if power:
        machine_model.power = power
    if place_id:
        machine_model.place_id = place_id
    if address:
        machine_model.address = address
    if hatch_number:
        machine_model.hatch_number = hatch_number
    if type:
        machine_model.type = type
    if status:
        machine_model.status = status
    if discounts_id:
        machine_model.discounts_id = discounts_id
    db.session.add(machine_model)

    db.session.commit()
    return BaseResponse()


@hatch_route.route("machine_detail", methods=["POST"])
def get_machine_detail():
    """

    :return:
    """
    json_data = request.get_json()
    machine_no = json_data["machine_no"]

    admin = g.user
    select_sql = """select machine.id, machine.machine_no, machine.device_id, machine.qrcode_no,machine.status,
                            machine.mac, machine.power, machine.hatch_number, machine.type,machine.place_id, 
                            place.place_name, machine.discounts_id
            """
    from_sql = """ from machine  left join place on machine.place_id = place.id
                            where machine.machine_no in ( select machine_no from admin_machine where  
                            admin_machine.user_id = {user_id} and admin_machine.status = 1)  
                             """.format(user_id=admin.id)

    where_sql = " and machine.machine_no = {}".format(machine_no)

    result = db.session.execute(select_sql + from_sql + where_sql).fetchall()
    if not result or len(result) != 1:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    info = result[0]
    return BaseResponse(data={"machine_no": info.machine_no, "device_id": info.device_id, "place_name": info.place_name,
                              "mac": info.mac, "power": info.power, "hatch_number": info.hatch_number,
                              "type": info.type, "status": info.status, "place_id": info.place_id,
                              "discounts_id": info.discounts_id,
                              "discounts_name": DISCOUNTS_TYPES.get(int(info.discounts_id), "无此优惠"),

                              })
