#!usr/bin/env python
# -*- coding:utf-8 _*-

import json
import logging
import re
import time

from flask import Blueprint, request, jsonify, g
from models.base_model import db
from utils.my_response import BaseResponse
from models.models import Management
from utils.error_code import PASSWORD_ERROR
from service.make_token import generate_token,certify_token
logger = logging.getLogger(__name__)
# 创建蓝图
login_route = Blueprint('login', __name__)

#登录
@login_route.route("login_phone",methods=["post"])
def login():
    json_date = request.get_json()
    number = json_date["number"]
    password = json_date['password']
    #手机号登录
    phone_result = Management.query.filter_by(phone=number, status=1).first()
    if phone_result:
        # 进行密码验证
        if phone_result.check_password(password) == True:
            # 从获取库里获取key
            return BaseResponse()
        else:
            return BaseResponse(**PASSWORD_ERROR)

    #用户id登录
    user_result = Management.query.filter_by(user_no=number, status=1).first()
    if user_result:
        # 进行密码验证
        if user_result.check_password(password) == True:
            return BaseResponse()
        else:
            return BaseResponse(**PASSWORD_ERROR)

    return BaseResponse(date="无法登录，用户id或手机号错误")
