# -*- coding: utf-8 -*-
import datetime
import logging
import time
from flask import Blueprint, jsonify, request, g
from pymongo import MongoClient, ASCENDING
from config.wechat_config import platform_config_list
from config.commen_config import LOGIN_TYPE, ACCOUNT_STATUS
from mongodb_collections.agent_modules import Modules, AdminModules
from service.admin_service import AdminService
from utils.error_code import ACCOUNT_AGENT_SPOT_NULL_ERROR, ACCOUNT_NOT_EXISTS_ERROR, \
    ACCOUNT_ALREADY_EXISTS_ERROR, ACCOUNT_ALREADY_DELETE_ERROR, AGNET_MODULES_ERROR, MODULES_NOT_EXISTS_ERROR, \
    OPERATE_LEVEL_ERROR, Param_Invalid_Error, COMMON_MONGO_ERROR
from utils.error_code import PHONE_NOT_NULL_ERROR, PHONE_NOT_VALID_ERROR, TOKEN_NOT_VALID_ERROR, \
    VERIFICATION_CODE_INVALID_ERROR, VERIFICATION_CODE_ERROR, PASSWORD_ERROR
from models.base_model import db
from models.models import AdminAccount, AdminLoginRecord, AdminMachine, AdminPlace, Place
from utils.jwt_util import verify_jwt, generate_jwt
from utils.my_response import BaseResponse
from service.sms_service import SMSService

logger = logging.getLogger(__name__)

admin_route = Blueprint('admin', __name__)


@admin_route.route('/test')
def test():
    ip = request.remote_addr
    return BaseResponse(**{'code': 200, 'msg': 'success!', 'data': ip})


@admin_route.route('/login', methods=['GET', 'POST'])
def user_login():
    token = request.headers.get('Authorization')
    platform = request.headers.get('platform')
    cur_ip = request.remote_addr
    json_data = request.get_json()

    data = {}
    phone = json_data['phone'] if 'phone' in json_data else None
    code = json_data['code'] if 'code' in json_data else None
    # login_type = json_data['type'] if 'type' in json_data else 1  # 1.验证码登录，2.密码登录
    login_type = 2
    if token:
        # token登录
        # "校验token"
        payload = verify_jwt(token)
        # "判断token的校验结果"
        if not payload:
            return BaseResponse(**TOKEN_NOT_VALID_ERROR)

        # "获取载荷中的信息赋值"
        user_id = payload.get('user_id')
        if not user_id:
            return BaseResponse(**TOKEN_NOT_VALID_ERROR)
        user_info = AdminAccount.query.filter_by(id=user_id, status=1).first()
    else:
        if login_type == 1:
            # 验证码登录
            # 判断验证码是否正确
            sms = SMSService()
            res = sms.verificate(phone, code)
            if res == -1:
                return BaseResponse(**VERIFICATION_CODE_INVALID_ERROR)
            elif res == -2:
                return BaseResponse(**VERIFICATION_CODE_ERROR)

            user_info = AdminAccount.query.filter_by(phone=phone, status=1).first()
            if not user_info:
                return BaseResponse(**PHONE_NOT_VALID_ERROR)
        else:
            # 密码登录
            # 判断密码是否正确
            user_info = AdminAccount.query.filter_by(phone=phone, status=1).first()
            if not user_info:
                return BaseResponse(**PHONE_NOT_VALID_ERROR)

            if not user_info.check_password(pasword=code):
                return jsonify(PASSWORD_ERROR)

    new_token = generate_jwt(payload={"user_id": user_info.id}, expiry=time.time() + 24 * 60 * 60)

    admin_log = AdminLoginRecord()
    admin_log.phone = user_info.phone
    admin_log.ip = cur_ip
    admin_log.platform = platform_config_list.index(platform)
    admin_log.last_login = datetime.datetime.now()
    admin_log.login_type = LOGIN_TYPE['token_login']
    admin_log.created_at = datetime.datetime.now()
    admin_log.updated_at = datetime.datetime.now()
    db.session.add(admin_log)
    db.session.commit()

    data['token'] = new_token
    data['user_name'] = user_info.user_name
    data['phone'] = user_info.phone
    data['level'] = user_info.level
    return BaseResponse(data=data)


@admin_route.route('/add_account', methods=['GET', 'POST'])
def add_user():
    admin = g.user
    json_data = request.get_json()
    user_name = json_data['user_name']
    phone = json_data['phone']
    level = int(json_data['level'])
    if level < admin.level:
        return jsonify(OPERATE_LEVEL_ERROR)
    password = json_data.get('password', "123456")
    comment = json_data.get('comment', "")
    parent_id = json_data.get("parent_id", admin.id)
    draw = json_data.get("draw", 0)
    rate = json_data.get("rate", 0)

    account = AdminAccount.query.filter_by(phone=phone).first()
    if account:
        if account.status != -1:
            return jsonify(account)

    else:
        account = AdminAccount()

    account.user_no = "todo"
    account.user_name = user_name
    account.phone = phone
    account.level = level
    account.draw = draw
    account.rate = rate
    account.parent_id = parent_id
    account.status = 1
    account.comment = comment
    account.created_at = datetime.datetime.now()
    account.updated_at = datetime.datetime.now()
    if password:
        account.password = password
    db.session.add(account)
    db.session.commit()
    account.user_no = "XX" + str(account.id).zfill(6)
    db.session.add(account)
    db.session.commit()

    return BaseResponse()


@admin_route.route('/account_list', methods=["POST"])
def get_account_list():
    json_data = request.get_json()
    page = json_data.get("page", None)
    page_size = json_data.get("pageSize", None)
    keyword = json_data.get("keyword", None)

    select_sql = """select admin_account.user_name, admin_account.phone, admin_account.level, admin_account.status,
                    admin_account.comment,admin_account.parent_id,admin_account.rate, admin_account.created_at, 
                    admin_account.updated_at,admin_account.id, admin_account.user_no
                    """
    count_sql = "select count(admin_account.id) as total_count"

    from_sql = " from admin_account where admin_account.id in ( select admin_account.id  "
    from_sql += " from admin_account  "
    where_sql = " where 0=0  and admin_account.level > {} and admin_account.parent_id = {}".format(g.user.level,
                                                                                                   g.user.id)
    if keyword:
        where_sql += """
            and CONCAT(admin_account.user_name,admin_account.phone, admin_account.user_no) LIKE '%{keyword}%'

                """.format(keyword=keyword)
    where_sql += " ) "
    order_sql = "  ORDER BY admin_account.id ASC, admin_account.status ASC"
    limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    print(select_sql + from_sql + where_sql + order_sql + limit_sql)
    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    for info in result:
        return_data.append(
            {"user_name": info.user_name, "phone": info.phone, "level": info.level, "status": info.status,
             "comment": info.comment, "user_id": info.id, "user_no": info.user_no,
             "create_time": info.created_at.strftime("%Y-%m-%d %H:%M:%S"),
             "update_time": info.updated_at.strftime("%Y-%m-%d %H:%M:%S"),
             })

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@admin_route.route('/account_detail', methods=["POST"])
def get_account_detail():
    json_data = request.get_json()
    phone = json_data["phone"]
    if phone == g.user.phone:
        admin_info = g.user
    else:
        admin_info = AdminAccount.query.filter(AdminAccount.phone == phone,
                                               AdminAccount.level > g.user.level,
                                               AdminAccount.parent_id == g.user.id).first()
    if not admin_info:
        return BaseResponse(**ACCOUNT_NOT_EXISTS_ERROR)

    user_info = {
        "user_id": admin_info.id,
        "user_no": admin_info.user_no,
        "user_name": admin_info.user_name,
        "phone": admin_info.phone,
        "level": admin_info.level,
        "status": admin_info.status,
        "comment": admin_info.comment
    }

    return BaseResponse(data=user_info)


@admin_route.route('/edit_account', methods=['GET', 'POST'])
def edit_user():
    json_data = request.get_json()
    old_phone = json_data['old_phone'] if 'old_phone' in json_data else ''
    new_phone = json_data['new_phone'] if 'new_phone' in json_data else ''
    user_name = json_data['user_name'] if 'user_name' in json_data else 'SSW'
    password = json_data['password'] if 'password' in json_data else ''
    comment = json_data['comment'] if 'comment' in json_data else ''
    level = json_data['level'] if 'level' in json_data else ''
    status = json_data['status'] if 'status' in json_data else ''
    if not old_phone:
        return BaseResponse(error_code=-1, error_message='old phone is null')

    if not new_phone:
        return BaseResponse(**PHONE_NOT_NULL_ERROR)

    if not status:
        return BaseResponse(**Param_Invalid_Error)

    if old_phone == g.user.phone:
        admin_info = g.user
        if level:
            admin_info.level = int(level)
    else:
        admin_info = AdminAccount.query.filter(AdminAccount.phone == old_phone,
                                               AdminAccount.level > g.user.level,
                                               AdminAccount.parent_id == g.user.id
                                               ).first()
    if not admin_info:
        return BaseResponse(**ACCOUNT_NOT_EXISTS_ERROR)

    admin_info.user_name = user_name
    admin_info.phone = new_phone
    admin_info.status = status
    admin_info.comment = comment

    if password:
        admin_info.password = password

    db.session.add(admin_info)
    db.session.commit()
    return BaseResponse()


@admin_route.route('/delete_account', methods=['GET', 'POST'])
def delete_user():
    json_data = request.get_json()
    phone = json_data['phone'] if 'phone' in json_data else ''
    if not phone:
        return BaseResponse(**PHONE_NOT_NULL_ERROR)

    admin_info = AdminAccount.query.filter(AdminAccount.phone == phone,
                                           AdminAccount.level > g.user.level).first()
    if not admin_info:
        return BaseResponse(**ACCOUNT_NOT_EXISTS_ERROR)

    admin_info.status = ACCOUNT_STATUS['delete']
    db.session.add(admin_info)
    db.session.commit()

    return BaseResponse()
