#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/12
@file: machine_portal.py
@function:
@modify:
"""
import logging

from flask import Blueprint, g, request, jsonify

from config.commen_config import DISCOUNTS_TYPES
from models.base_model import db
from models.models import AdminMachine, Machine, Hatch
from utils.error_code import MACHINE_NOT_EXIST_ERROR, HATCH_COUNT_MAX_ERROR, HATCH_NO_DUPLICATE_ERROR, \
    HATCH_NOT_EXIST_ERROR
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

hatch_route = Blueprint('hatch', __name__)


@hatch_route.route("hatch_list", methods=["POST"])
def run_hatch_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    keyword = json_data.get("keyword", None)

    admin = g.user
    select_sql = """select hatch.id,hatch.machine_no, hatch.hatch_no,hatch.production_id,hatch.production_name,
                    hatch.title,hatch.left_count,hatch.total_count,hatch.brand_id,hatch.brand_name,
                    hatch.production_type_id,hatch.production_type_name,
                    hatch.price,hatch.original_price, hatch.weight,hatch.weight_unit,hatch.weight_error,
                    hatch.expiration_date,hatch.expiration_date_unit,hatch.is_expiration_date,
                    hatch.img, hatch.tags, hatch.content,hatch.summary,hatch.status
        """
    count_sql = "select count(hatch.id) as total_count"
    from_sql = """ from hatch
                       
                         """
    if g.user.level == 1:
        where_sql = " where 0=0"
    else:
        where_sql = """  where hatch.machine_no in ( select machine_no from admin_machine where  
                        admin_machine.user_id = '{user_id}' and admin_machine.status = 1)  
                                                       """.format(user_id=admin.id)
    if keyword:
        where_sql += """
                        and CONCAT(hatch.machine_no,ifnull(hatch.brand_name,''), ifnull(hatch.production_type_name,''),
                            ifnull(hatch.production_name,'')) 
                        LIKE '%{keyword}%'

                            """.format(keyword=keyword)
    order_sql = "  ORDER BY hatch.id ASC, hatch.status ASC"
    limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count
    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    for info in result:
        return_data.append(
            {"production_name": info.production_name, "production_id": info.production_id,
             "machine_no": info.machine_no,
             "hatch_no": info.hatch_no,
             "hatch_id": info.id,
             "left_count": info.left_count,
             "total_count": info.total_count,
             "title": info.title, "brand_id": info.brand_id, "brand_name": info.brand_name,
             "production_type_id": info.production_type_id, "production_type_name": info.production_type_name,
             "price": info.price, "original_price": info.original_price, "weight": info.weight,
             "weight_unit": info.weight_unit,
             "expiration_date": info.expiration_date, "expiration_date_unit": info.expiration_date_unit,
             "is_expiration_date": info.is_expiration_date,
             "weight_error": info.weight_error,
             "img": info.img, "tags": info.tags, "content": info.content,
             "summary": info.summary, "status": info.status,
             })

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@hatch_route.route("add_hatch", methods=["POST"])
def run_add_machine():
    """

    :return:
    """
    json_data = request.get_json()
    machine_no = json_data["machine_no"]
    admin_machine = AdminMachine.query.filter_by(machine_no=machine_no, user_id=g.user.id, status=1).first()
    if not admin_machine:
        return jsonify(MACHINE_NOT_EXIST_ERROR)
    machine = Machine.query.filter(Machine.machine_no == machine_no, Machine.status != -1).first()
    if not machine:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    hatch_num = machine.hatch_number
    hatchs = Hatch.query.filter_by(machine_no=machine_no).all()
    if len(hatchs) >= hatch_num:
        return jsonify(HATCH_COUNT_MAX_ERROR)

    hatch_no = int(json_data["hatch_no"])
    for i in hatchs:
        if i.hatch_no == hatch_no:
            return jsonify(HATCH_NO_DUPLICATE_ERROR)

    production_id = json_data["production_id"]
    production_name = json_data["production_name"]
    title = json_data.get("title", "")
    brand_id = json_data.get("brand_id", 0)
    brand_name = json_data.get("brand_name", "")
    production_type_id = json_data.get("production_type_id", 0)
    production_type_name = json_data.get("production_type_name", "")
    price = json_data.get("price", 0)
    original_price = json_data.get("original_price", 0)
    weight = json_data.get("weight", 0)
    weight_unit = json_data.get("weight_unit", "g")
    weight_error = json_data.get("weight_error", 0)
    expiration_date = json_data.get("expiration_date", 0)
    expiration_date_unit = json_data.get("expiration_date_unit", "月")
    is_expiration_date = json_data.get("is_expiration_date", 0)
    img = json_data.get("img", None)
    tags = json_data.get("tags", None)
    content = json_data.get("content", None)
    summary = json_data.get("summary", None)
    left_count = json_data.get("left_count", 0)
    total_count = json_data["total_count"]

    hatch_model = Hatch()
    hatch_model.machine_no = machine_no
    hatch_model.hatch_no = hatch_no
    hatch_model.production_id = production_id
    hatch_model.production_name = production_name
    hatch_model.title = title
    hatch_model.left_count = left_count
    hatch_model.total_count = total_count
    hatch_model.brand_id = brand_id
    hatch_model.brand_name = brand_name
    hatch_model.production_type_id = production_type_id
    hatch_model.production_type_name = production_type_name
    hatch_model.price = price
    hatch_model.original_price = original_price
    hatch_model.weight = weight
    hatch_model.weight_unit = weight_unit
    hatch_model.weight_error = weight_error
    hatch_model.expiration_date = expiration_date
    hatch_model.expiration_date_unit = expiration_date_unit
    hatch_model.is_expiration_date = is_expiration_date
    hatch_model.img = img
    hatch_model.tags = tags
    hatch_model.content = content
    hatch_model.summary = summary
    db.session.add(hatch_model)
    db.session.commit()
    return BaseResponse()


@hatch_route.route("edit_hatch", methods=["POST"])
def run_edit_hatch():
    """

    :return:
    """
    json_data = request.get_json()
    hatch_id = json_data["hatch_id"]
    hatch = Hatch.query.filter_by(id=hatch_id).first()
    if not hatch:
        return jsonify(HATCH_NOT_EXIST_ERROR)

    admin_machine = AdminMachine.query.filter_by(machine_no=hatch.machine_no, user_id=g.user.id, status=1).first()
    if not admin_machine:
        return jsonify(MACHINE_NOT_EXIST_ERROR)
    machine = Machine.query.filter(Machine.machine_no == hatch.machine_no, Machine.status != -1).first()
    if not machine:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    production_id = json_data.get("production_id", None)
    production_name = json_data.get("production_name", None)
    title = json_data.get("title", None)
    brand_id = json_data.get("brand_id", None)
    brand_name = json_data.get("brand_name", None)
    production_type_id = json_data.get("production_type_id", None)
    production_type_name = json_data.get("production_type_name", None)
    price = json_data.get("price", None)
    original_price = json_data.get("original_price", None)
    weight = json_data.get("weight", None)
    weight_unit = json_data.get("weight_unit", None)
    weight_error = json_data.get("weight_error", None)
    expiration_date = json_data.get("expiration_date", None)
    expiration_date_unit = json_data.get("expiration_date_unit", None)
    is_expiration_date = json_data.get("is_expiration_date", None)
    img = json_data.get("img", None)
    tags = json_data.get("tags", None)
    content = json_data.get("content", None)
    summary = json_data.get("summary", None)
    left_count = json_data.get("left_count", None)
    total_count = json_data.get("total_count", None)

    if production_id:
        hatch.production_id = production_id
        hatch.production_name = production_name
    if title:
        hatch.title = title
    if brand_id:
        hatch.brand_id = brand_id
        hatch.brand_name = brand_name
    if production_type_id:
        hatch.production_type_id = production_type_id
        hatch.production_type_name = production_type_name
    if price:
        hatch.price = price
    if original_price:
        hatch.original_price = original_price
    if weight:
        hatch.weight = weight
    if weight_unit:
        hatch.weight_unit = weight_unit
    if weight_error:
        hatch.weight_error = weight_error
    if expiration_date:
        hatch.expiration_date = expiration_date
    if expiration_date_unit:
        hatch.expiration_date_unit = expiration_date_unit
    if is_expiration_date:
        hatch.is_expiration_date = is_expiration_date
    if img:
        hatch.img = img
    if tags:
        hatch.tags = tags
    if content:
        hatch.content = content
    if summary:
        hatch.summary = summary
    if left_count:
        hatch.left_count = left_count
    if total_count:
        hatch.total_count = total_count
    db.session.add(hatch)
    db.session.commit()
    return BaseResponse()
