import json
import logging
import re
import time

from flask import Blueprint, request, jsonify, g
from sqlalchemy import extract

from config.commen_config import USER_RENT_PREPAY_ID
from config.wechat_config import platform_appid_config_list, pay_config_list, NFC_PAY_CALLBCK_URL
from models.base_model import db
from models.models import NfcCard, NfcCardPayRecord, NfcCardPayRefund
from service.rent_service import RentService
from service.wechat_service import WeChatPayService
from utils.error_code import NFC_CARD_NOT_EXIST, NFC_CARD_ACTIVATED_ERROR, WE_MINIAPP_PAY_FAIL, NO_RENT_RECORD, \
    NO_NFC_CARD_ERROR
from utils.my_redis_cache import redis_client
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

card_route = Blueprint('card', __name__)

