#!usr/bin/.env python
# -*- coding:utf-8 _*-
"""
@version:
@author:Aeolus
@file: __init__.py
@function:
@modify:
"""
from flask import Flask
from flask_cors import CORS
from flask_log_request_id import RequestID
from dotenv import load_dotenv

from models.base_model import db
from utils.my_redis_cache import redis_client
from utils.mylogger import set_logger


def create_app(config_name):
    from config.env_path_config import env_path
    load_dotenv(dotenv_path=env_path, verbose=True, override=True)
    set_logger()

    app = Flask("sukang24h")
    from config.app_config import config
    app.config.from_object(config[config_name])
    CORS(app)
    db.init_app(app)
    redis_client.init_app(app)
    RequestID(app)

    from utils.middlewares import jwt_authentication, log_enter_interface, log_out_interface, close_db_session, \
        get_platform, all_options_pass
    app.before_request(log_enter_interface)
    app.before_request(all_options_pass)
    app.before_request(get_platform)
    app.before_request(jwt_authentication)
    app.after_request(log_out_interface)
    app.after_request(close_db_session)

    # todo register blueprint
    from myapps.sukang24h.api import register_sukang_blueprint
    register_sukang_blueprint(app)
    return app
