# coding: utf-8
from sqlalchemy import Column, DateTime, Index, String, TIMESTAMP, Text, text
from sqlalchemy.dialects.mysql import INTEGER, TEXT, TINYINT, VARCHAR
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()
metadata = Base.metadata


class AdminAccount(Base):
    __tablename__ = 'admin_account'

    id = Column(INTEGER(10), primary_key=True, unique=True)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False, unique=True)
    user_name = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False)
    phone = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, unique=True)
    level = Column(TINYINT(2), nullable=False)
    parent_id = Column(INTEGER(10), nullable=False)
    draw = Column(TINYINT(1), nullable=False, server_default=text("'0'"))
    rate = Column(INTEGER(10), nullable=False)
    status = Column(INTEGER(1), nullable=False)
    _password_hash_ = Column(String(255, 'utf8mb4_unicode_ci'))
    comment = Column(String(255, 'utf8mb4_unicode_ci'))
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class AdminLoginRecord(Base):
    __tablename__ = 'admin_login_record'

    id = Column(INTEGER(10), primary_key=True)
    phone = Column(VARCHAR(40), nullable=False)
    platform = Column(TINYINT(4), nullable=False, server_default=text("'1'"))
    ip = Column(VARCHAR(40), nullable=False)
    last_login = Column(DateTime, nullable=False)
    login_type = Column(INTEGER(1), nullable=False)
    created_at = Column(DateTime, nullable=False)
    updated_at = Column(DateTime, nullable=False)


class AdminMachine(Base):
    __tablename__ = 'admin_machine'

    id = Column(INTEGER(11), primary_key=True)
    user_id = Column(INTEGER(11), nullable=False)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    machine_no = Column(INTEGER(11), nullable=False)
    status = Column(INTEGER(1), nullable=False, server_default=text("'1'"))
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class AdminPlace(Base):
    __tablename__ = 'admin_place'

    id = Column(INTEGER(11), primary_key=True)
    user_id = Column(INTEGER(11), nullable=False)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    place_id = Column(INTEGER(11), nullable=False)
    status = Column(INTEGER(1), nullable=False, server_default=text("'1'"))
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class AdminProduction(Base):
    __tablename__ = 'admin_production'

    id = Column(INTEGER(11), primary_key=True)
    user_id = Column(INTEGER(11), nullable=False)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    production_id = Column(INTEGER(11), nullable=False)
    status = Column(INTEGER(1), nullable=False, server_default=text("'1'"))
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class Brand(Base):
    __tablename__ = 'brand'

    id = Column(INTEGER(10), primary_key=True)
    name = Column(VARCHAR(191), nullable=False, index=True)
    img = Column(VARCHAR(191), nullable=False)
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class Hatch(Base):
    __tablename__ = 'hatch'
    __table_args__ = (
        Index('hatch_machine_UNIQUE', 'machine_no', 'hatch_no', unique=True),
    )

    id = Column(INTEGER(10), primary_key=True, unique=True)
    machine_no = Column(String(20, 'utf8mb4_unicode_ci'), nullable=False)
    hatch_no = Column(TINYINT(3), nullable=False)
    production_id = Column(INTEGER(10), nullable=False)
    name = Column(String(100, 'utf8mb4_unicode_ci'), nullable=False)
    title = Column(String(200, 'utf8mb4_unicode_ci'), nullable=False)
    left_count = Column(TINYINT(3), nullable=False, server_default=text("'1'"))
    total_count = Column(TINYINT(3), nullable=False, server_default=text("'1'"))
    brand_id = Column(INTEGER(10), nullable=False)
    brand_name = Column(String(100, 'utf8mb4_unicode_ci'), nullable=False)
    cate_id = Column(INTEGER(10), nullable=False)
    cate_name = Column(String(200, 'utf8mb4_unicode_ci'), nullable=False)
    price = Column(INTEGER(10), nullable=False)
    original_price = Column(INTEGER(10), nullable=False)
    img = Column(String(200, 'utf8mb4_unicode_ci'))
    tags = Column(String(255, 'utf8mb4_unicode_ci'))
    content = Column(Text(collation='utf8mb4_unicode_ci'))
    summary = Column(Text(collation='utf8mb4_unicode_ci'))
    status = Column(TINYINT(3), nullable=False, server_default=text("'1'"))
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class Machine(Base):
    __tablename__ = 'machine'

    id = Column(INTEGER(10), primary_key=True)
    machine_no = Column(String(20, 'utf8mb4_unicode_ci'), nullable=False, unique=True)
    device_id = Column(String(45, 'utf8mb4_unicode_ci'), unique=True)
    qrcode_no = Column(String(20, 'utf8mb4_unicode_ci'), unique=True)
    mac = Column(String(30, 'utf8mb4_unicode_ci'), unique=True)
    power = Column(TINYINT(3), nullable=False, server_default=text("'0'"))
    short_address = Column(VARCHAR(45))
    address = Column(String(191, 'utf8mb4_unicode_ci'))
    place_id = Column(INTEGER(10))
    mch_platform = Column(INTEGER(11), nullable=False, server_default=text("'1'"))
    position = Column(String(20, 'utf8mb4_unicode_ci'))
    hatch_number = Column(TINYINT(3), nullable=False, server_default=text("'0'"))
    type = Column(TINYINT(3), nullable=False, server_default=text("'1'"))
    status = Column(TINYINT(1), server_default=text("'0'"))
    created_at = Column(TIMESTAMP, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))
    command_time = Column(INTEGER(4), nullable=False, server_default=text("'1'"))
    discounts_id = Column(INTEGER(10), server_default=text("'0'"))


class MachineProduction(Base):
    __tablename__ = 'machine_production'

    id = Column(INTEGER(10), primary_key=True)
    machine_id = Column(INTEGER(10), nullable=False)
    production_id = Column(INTEGER(10), nullable=False)
    hatch_no = Column(INTEGER(10), nullable=False)
    status = Column(TINYINT(1), nullable=False)
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class ManagementLogin(Base):
    __tablename__ = 'management_login'

    id = Column(INTEGER(10), primary_key=True)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    user_name = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    phone = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False)
    level = Column(INTEGER(1), nullable=False)
    status = Column(INTEGER(1), nullable=False)
    _password_hash_ = Column(String(255, 'utf8mb4_unicode_ci'))
    last_login = Column(DateTime)
    expire_time = Column(DateTime)
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))


class ManagementMachine(Base):
    __tablename__ = 'management_machine'

    id = Column(INTEGER(11), primary_key=True)
    management_id = Column(INTEGER(255), nullable=False)
    machine_no = Column(INTEGER(255), nullable=False)
    level = Column(INTEGER(255), nullable=False)
    status = Column(INTEGER(1), nullable=False)
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))


class ManagementTallyman(Base):
    __tablename__ = 'management_tallyman'

    id = Column(INTEGER(11), primary_key=True)
    management_id = Column(INTEGER(255), nullable=False)
    tallyman_id = Column(INTEGER(255), nullable=False)
    status = Column(INTEGER(1), nullable=False)
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))


class NfcCard(Base):
    __tablename__ = 'nfc_card'

    id = Column(INTEGER(10), primary_key=True)
    card_no = Column(String(40, 'utf8mb4_unicode_ci'))
    user_id = Column(INTEGER(10))
    nick_name = Column(String(40, 'utf8mb4_unicode_ci'))
    phone = Column(String(40, 'utf8mb4_unicode_ci'), index=True)
    money = Column(INTEGER(10), nullable=False)
    mch_platform = Column(INTEGER(11), nullable=False, server_default=text("'1'"))
    limit_count = Column(TINYINT(1), nullable=False, server_default=text("'-1'"))
    status = Column(TINYINT(4), nullable=False)
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class NfcCardPayRecord(Base):
    __tablename__ = 'nfc_card_pay_record'

    id = Column(INTEGER(10), primary_key=True)
    card_no = Column(String(40, 'utf8mb4_unicode_ci'), index=True)
    rent_no = Column(VARCHAR(40), nullable=False)
    user_id = Column(INTEGER(10), nullable=False)
    is_pay = Column(TINYINT(3), nullable=False, server_default=text("'0'"))
    pay_money = Column(INTEGER(10), nullable=False)
    mch_platform = Column(INTEGER(11), nullable=False, server_default=text("'1'"))
    prepay_id = Column(VARCHAR(191))
    refund_no = Column(VARCHAR(191))
    status = Column(TINYINT(4), nullable=False)
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class NfcCardPayRefund(Base):
    __tablename__ = 'nfc_card_pay_refund'

    id = Column(INTEGER(11), primary_key=True)
    refund_no = Column(VARCHAR(191), nullable=False)
    rent_no = Column(VARCHAR(191), nullable=False)
    fee = Column(INTEGER(11), nullable=False)
    cause = Column(VARCHAR(191))
    comment = Column(TEXT)
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class Place(Base):
    __tablename__ = 'place'

    id = Column(INTEGER(10), primary_key=True)
    parent_id = Column(INTEGER(10))
    place_name = Column(VARCHAR(191), nullable=False, index=True)
    img = Column(VARCHAR(191))
    logo = Column(VARCHAR(191))
    address = Column(VARCHAR(255), server_default=text("''"))
    position = Column(String(20, 'utf8mb4_unicode_ci'))
    open_time = Column(VARCHAR(191))
    close_time = Column(VARCHAR(191))
    open_week = Column(VARCHAR(255), server_default=text("''"))
    status = Column(INTEGER(1), nullable=False, server_default=text("'1'"))
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class PlaceMachine(Base):
    __tablename__ = 'place_machine'

    id = Column(INTEGER(11), primary_key=True)
    machine_id = Column(INTEGER(25))
    place_id = Column(INTEGER(25))
    status = Column(INTEGER(1))
    created_at = Column(DateTime, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, server_default=text("CURRENT_TIMESTAMP"))


class Production(Base):
    __tablename__ = 'production'

    id = Column(INTEGER(10), primary_key=True)
    production_no = Column(String(45, 'utf8mb4_unicode_ci'), nullable=False)
    production_name = Column(String(100, 'utf8mb4_unicode_ci'), nullable=False, index=True)
    title = Column(String(200, 'utf8mb4_unicode_ci'), nullable=False)
    brand_id = Column(INTEGER(10), nullable=False)
    production_type_id = Column(INTEGER(10), nullable=False)
    price = Column(INTEGER(10), nullable=False)
    original_price = Column(INTEGER(10), nullable=False)
    weight = Column(INTEGER(10), server_default=text("'0'"))
    weight_unit = Column(String(10, 'utf8mb4_unicode_ci'), server_default=text("'g'"))
    expiration_date = Column(INTEGER(10), server_default=text("'0'"))
    expiration_date_unit = Column(String(10, 'utf8mb4_unicode_ci'), server_default=text("''"))
    is_expiration_date = Column(TINYINT(1), server_default=text("'0'"))
    weight_error = Column(INTEGER(10), server_default=text("'0'"))
    img = Column(String(200, 'utf8mb4_unicode_ci'))
    tags = Column(String(255, 'utf8mb4_unicode_ci'))
    content = Column(Text(collation='utf8mb4_unicode_ci'))
    summary = Column(Text(collation='utf8mb4_unicode_ci'))
    status = Column(TINYINT(1))
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class ProductionType(Base):
    __tablename__ = 'production_type'

    id = Column(INTEGER(10), primary_key=True)
    name = Column(VARCHAR(191), nullable=False, index=True)
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))
    catecol = Column(String(45, 'utf8mb4_unicode_ci'))


class Rent(Base):
    __tablename__ = 'rent'

    id = Column(INTEGER(10), primary_key=True)
    rent_no = Column(VARCHAR(40), nullable=False, index=True)
    machine_no = Column(String(40, 'utf8mb4_unicode_ci'), nullable=False, index=True)
    user_id = Column(INTEGER(10), nullable=False, index=True)
    card_no = Column(String(40, 'utf8mb4_unicode_ci'), index=True)
    place_id = Column(INTEGER(10), nullable=False, index=True)
    total = Column(INTEGER(10), server_default=text("'0'"))
    real_total = Column(INTEGER(10), server_default=text("'0'"))
    agent_total = Column(INTEGER(10), server_default=text("'0'"))
    back_money = Column(INTEGER(10), nullable=False, server_default=text("'0'"))
    is_pay = Column(TINYINT(3), nullable=False, server_default=text("'0'"))
    rent_type = Column(TINYINT(3), nullable=False, server_default=text("'1'"))
    mch_platform = Column(INTEGER(1), nullable=False, server_default=text("'1'"))
    add_time = Column(TIMESTAMP, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))
    pay_time = Column(TIMESTAMP)
    is_over = Column(TINYINT(3), nullable=False, server_default=text("'0'"))
    is_cancel = Column(TINYINT(3), nullable=False, server_default=text("'0'"))
    refund_no = Column(VARCHAR(191))
    expire_handle = Column(TINYINT(3), nullable=False, server_default=text("'0'"))
    prepay_id = Column(VARCHAR(191))
    over_time = Column(TIMESTAMP)
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class RentDetail(Base):
    __tablename__ = 'rent_detail'

    id = Column(INTEGER(10), primary_key=True, unique=True)
    rent_no = Column(String(40, 'utf8mb4_unicode_ci'), nullable=False)
    user_id = Column(INTEGER(10), nullable=False)
    machine_no = Column(String(20, 'utf8mb4_unicode_ci'), nullable=False)
    hatch_no = Column(TINYINT(3), nullable=False)
    production_id = Column(INTEGER(10), nullable=False)
    is_take = Column(TINYINT(3), nullable=False, server_default=text("'0'"))
    name = Column(String(100, 'utf8mb4_unicode_ci'), nullable=False)
    title = Column(String(200, 'utf8mb4_unicode_ci'), nullable=False)
    brand_id = Column(INTEGER(10), nullable=False)
    brand_name = Column(String(100, 'utf8mb4_unicode_ci'), nullable=False)
    cate_id = Column(INTEGER(10), nullable=False)
    cate_name = Column(String(200, 'utf8mb4_unicode_ci'), nullable=False)
    price = Column(INTEGER(10), nullable=False)
    rent_count = Column(TINYINT(3), nullable=False)
    img = Column(String(200, 'utf8mb4_unicode_ci'))
    tags = Column(String(255, 'utf8mb4_unicode_ci'))
    content = Column(Text(collation='utf8mb4_unicode_ci'))
    summary = Column(Text(collation='utf8mb4_unicode_ci'))
    status = Column(TINYINT(3), nullable=False, server_default=text("'1'"))
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class SalePlan(Base):
    __tablename__ = 'sale_plan'

    id = Column(INTEGER(10), primary_key=True)
    name = Column(String(100, 'utf8mb4_unicode_ci'), nullable=False)
    title = Column(String(200, 'utf8mb4_unicode_ci'), nullable=False)
    status = Column(TINYINT(1), nullable=False)
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class SalePlanMachine(Base):
    __tablename__ = 'sale_plan_machine'

    id = Column(INTEGER(10), primary_key=True)
    plan_id = Column(INTEGER(10), nullable=False)
    machine_id = Column(INTEGER(10), nullable=False)
    status = Column(TINYINT(1), nullable=False)
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class SalePlanProduction(Base):
    __tablename__ = 'sale_plan_production'

    id = Column(INTEGER(10), primary_key=True)
    plan_id = Column(INTEGER(10), nullable=False)
    production_id = Column(INTEGER(10), nullable=False)
    index = Column(INTEGER(10), nullable=False)
    status = Column(TINYINT(1), nullable=False)
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class TallyRecord(Base):
    __tablename__ = 'tally_record'

    id = Column(INTEGER(10), primary_key=True)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False)
    user_name = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False)
    machine_no = Column(String(20, 'utf8mb4_unicode_ci'), nullable=False)
    hatch_no = Column(TINYINT(3), nullable=False)
    production_id = Column(INTEGER(10), nullable=False)
    production_name = Column(String(100, 'utf8mb4_unicode_ci'), nullable=False)
    tally_count = Column(TINYINT(3), nullable=False, server_default=text("'1'"))
    status = Column(TINYINT(3), nullable=False, server_default=text("'1'"))
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class TallymanAccount(Base):
    __tablename__ = 'tallyman_account'

    id = Column(INTEGER(10), primary_key=True, unique=True)
    user_no = Column(String(25, 'utf8mb4_unicode_ci'), nullable=False, unique=True)
    user_name = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False)
    phone = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, unique=True)
    level = Column(INTEGER(1), nullable=False)
    status = Column(INTEGER(1), nullable=False)
    _password_hash_ = Column(String(255, 'utf8mb4_unicode_ci'))
    comment = Column(String(255, 'utf8mb4_unicode_ci'))
    last_login = Column(DateTime)
    expire_time = Column(DateTime)
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))


class TallymanLoginRecord(Base):
    __tablename__ = 'tallyman_login_record'

    id = Column(INTEGER(10), primary_key=True)
    phone = Column(VARCHAR(255), nullable=False)
    platform = Column(TINYINT(4), nullable=False, server_default=text("'2'"))
    ip = Column(VARCHAR(255), nullable=False)
    last_login = Column(DateTime, nullable=False)
    login_type = Column(INTEGER(1), nullable=False)
    created_at = Column(DateTime, nullable=False)
    updated_at = Column(DateTime, nullable=False)


class TallymanMachine(Base):
    __tablename__ = 'tallyman_machine'

    id = Column(INTEGER(11), primary_key=True)
    user_id = Column(INTEGER(255), nullable=False)
    machine_no = Column(INTEGER(255), nullable=False)
    status = Column(INTEGER(1), nullable=False)
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))


class TallymanPlace(Base):
    __tablename__ = 'tallyman_place'

    id = Column(INTEGER(11), primary_key=True)
    user_id = Column(INTEGER(255), nullable=False)
    place_id = Column(INTEGER(255), nullable=False)
    status = Column(INTEGER(1), nullable=False)
    created_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(DateTime, nullable=False, server_default=text("CURRENT_TIMESTAMP"))


class WxUser(Base):
    __tablename__ = 'wx_user'

    id = Column(INTEGER(10), primary_key=True)
    openid = Column(String(40, 'utf8mb4_unicode_ci'), index=True)
    unionid = Column(String(40, 'utf8mb4_unicode_ci'))
    platform = Column(TINYINT(4), nullable=False, server_default=text("'0'"))
    phone = Column(String(40, 'utf8mb4_unicode_ci'), index=True)
    language = Column(String(40, 'utf8mb4_unicode_ci'))
    nick_name = Column(String(40, 'utf8mb4_unicode_ci'))
    gender = Column(TINYINT(4), nullable=False, server_default=text("'0'"))
    avatar_url = Column(String(191, 'utf8mb4_unicode_ci'))
    city = Column(String(45, 'utf8mb4_unicode_ci'))
    province = Column(String(45, 'utf8mb4_unicode_ci'))
    country = Column(String(45, 'utf8mb4_unicode_ci'))
    status = Column(TINYINT(4), nullable=False)
    last_login_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))
    created_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP"))
    updated_at = Column(TIMESTAMP, server_default=text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"))
