#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/12
@file: place_portal.py
@function:
@modify:
"""
import logging

from flask import Blueprint, g, request, jsonify

from models.base_model import db
from models.models import AdminPlace, Place, Business, AdminBusiness, AdminAccount
from service.admin_service import AdminService
from utils.error_code import NO_PLACE_ERROR, NO_BUSINESS_ERROR, ADMIN_BUSINESS_NOT_EXIST, OPERATE_LEVEL_ERROR, \
    ACCOUNT_NOT_EXISTS_ERROR, RATE_INVALID_ERROR
from utils.my_response import BaseResponse
from utils.mytools import json2obj

logger = logging.getLogger(__name__)

business_route = Blueprint('business', __name__)


@business_route.route("business_list", methods=["POST"])
def run_business_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    keyword = json_data.get("keyword", None)

    admin = g.user
    select_sql = "select business.business_name,business.status, business.id "
    count_sql = "select count(business.id) as total_count"
    from_sql = """ from business  """

    if g.user.level == 1:
        where_sql = " where 0=0 "
    else:
        where_sql = """  where business.id in (
                                        select business_id from admin_business where 
                                        admin_business.user_id = {} and admin_business.status = 1
                                    )""".format(admin.id)
    if keyword:
        where_sql += """ and CONCAT(business.business_name) LIKE '%{keyword}%' """.format(keyword=keyword)

    order_sql = "  ORDER BY business.id ASC, business.status ASC"
    limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    for info in result:
        return_data.append({"business_name": info.business_name, "business_id": info.id, "status": info.status})

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@business_route.route("add_business", methods=["POST"])
def run_add_business():
    """

    :return:
    """
    json_data = request.get_json()
    business_name = json_data["business_name"]

    business_model = Business()
    business_model.business_name = business_name
    db.session.add(business_model)
    db.session.commit()

    admin_business = AdminBusiness()
    admin_business.user_id = g.user.id
    admin_business.user_no = g.user.user_no
    admin_business.business_id = business_model.id
    db.session.add(admin_business)
    db.session.commit()
    return BaseResponse()


@business_route.route("edit_business", methods=["POST"])
def run_edit_business():
    """

    :return:
    """
    json_data = request.get_json()
    business_id = json_data["business_id"]
    business_name = json_data.get("business_name", "")
    status = json_data.get("status", None)

    business_model = Business.query.filter_by(id=business_id).first()
    if business_name is not None:
        business_model.business_name = business_name
    if status is not None:
        business_model.status = status
    db.session.add(business_model)
    db.session.commit()
    return BaseResponse()


@business_route.route("business_detail", methods=["POST"])
def get_business_detail():
    """

    :return:
    """
    json_data = request.get_json()
    business_id = json_data["business_id"]

    business_model = Business.query.filter_by(id=business_id).first()
    if business_model:
        return BaseResponse(data={"business_name": business_model.business_name,
                                  "status": business_model.status, "business_id": business_id})
    else:
        return jsonify(NO_BUSINESS_ERROR)


@business_route.route("business_account_list", methods=["POST"])
def get_business_account_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    keyword = json_data.get("keyword", None)
    business_id = json_data.get("business_id", None)

    admin = g.user

    if g.user.level != 1:
        result = AdminBusiness.query.filter_by(business_id=business_id, user_id=admin.id, status=1).first()
        if not result:
            return jsonify(ADMIN_BUSINESS_NOT_EXIST)

    select_sql = """select admin_account.id, admin_account.user_no,admin_account.user_name, admin_account.phone, 
                    admin_account.level, admin_business.rate """
    count_sql = "select count(admin_account.id) as total_count"
    from_sql = """ from admin_account  left join admin_business on admin_account.id = admin_business.user_id  """
    where_sql = """  where  admin_business.business_id = '{}' and admin_business.status = '1'
                             and admin_account.level >= '{}'  
                """.format(business_id, admin.level)
    if keyword:
        where_sql += """ and CONCAT(admin_account.user_name, admin_account.phone) LIKE '%{keyword}%' 
        """.format(keyword=keyword)
    order_sql = "  ORDER BY admin_account.id ASC"
    limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()
    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count
    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()
    return_data = []
    for info in result:
        return_data.append({"user_name": info.user_name, "user_id": info.id, "user_no": info.user_no,
                            "phone": info.phone, "level": info.level, "rate": info.rate
                            })
    super_sql = """  where  admin_business.business_id = '{}' and admin_business.status = '1'
                            and admin_account.status = '1' and admin_account.level < '{}'  
                """.format(business_id, admin.level)
    super_result = db.session.execute(select_sql + from_sql + super_sql).fetchall()
    super_data = [{"user_name": "咻咻科技", "user_id": 0, "user_no": '0', "phone": "0", "level": 1, "rate": 0}]
    for info in super_result:
        if info.level in (1, 3):
            super_data[0]["rate"] += info.rate
        else:
            super_data.append({"user_name": info.user_name, "user_id": info.id, "user_no": info.user_no,
                               "phone": info.phone, "level": info.level, "rate": info.rate
                               })
    return BaseResponse({"super_list": super_data, "list": return_data, "page": page, "pageSize": page_size,
                         "total_count": total_count})


@business_route.route("edit_admin_account", methods=["POST"])
def run_edit_admin_account():
    """

    :return:
    """
    json_data = request.get_json()
    business_id = json_data["business_id"]
    user_data = json_data["user_data"]

    admin = g.user
    if admin.level not in (1, 2, 4, 5):
        return jsonify(OPERATE_LEVEL_ERROR)
    if admin.level != 1:
        result = AdminBusiness.query.filter_by(business_id=business_id, user_id=admin.id, status=1).first()
        if not result:
            return jsonify(ADMIN_BUSINESS_NOT_EXIST)

    select_sql = """select sum(rate) as total_rate """
    from_sql = """ from admin_account  left join admin_business on admin_account.id = admin_business.user_id  """
    super_sql = """  where  admin_business.business_id = '{}' and admin_business.status = '1'
                            and admin_account.level < '{}'  
                    """.format(business_id, admin.level)
    super_rate = db.session.execute(select_sql + from_sql + super_sql).fetchone()["total_rate"]

    total_rate = 100 - super_rate
    for i in user_data:
        rate = int(i["rate"])
        total_rate = total_rate - rate
    if total_rate < 0:
        return jsonify(RATE_INVALID_ERROR)

    select_sql = """select admin_account.id as user_id"""
    from_sql = """ from admin_account  left join admin_business on admin_account.id = admin_business.user_id  """
    where_sql = """  where  admin_business.business_id = '{}' and admin_business.status = '1'
                             and admin_account.level >= '{}'  
                     """.format(business_id, admin.level)
    user_id_list = [x["user_id"] for x in (db.session.execute(select_sql + from_sql + where_sql).fetchall())]

    AdminBusiness.query.filter(AdminBusiness.business_id == business_id,
                               AdminBusiness.user_id.in_(user_id_list)).update({"status": -1})
    for i in user_data:
        user_id = i["user_id"]
        rate = int(i["rate"])
        if user_id == admin.id:
            user_info = admin
        else:
            result = AdminService.get_admin_account_list(user_id=user_id)
            if result["total_count"] != 1:
                return BaseResponse(**ACCOUNT_NOT_EXISTS_ERROR)
            user_info = json2obj(result["list"][0])
        admin_business = AdminBusiness.query.filter_by(business_id=business_id, user_id=user_id).first()
        if admin_business:
            admin_business.rate = rate
            admin_business.status = 1
        else:
            admin_business = AdminBusiness()
            admin_business.user_id = user_id
            admin_business.user_no = user_info.user_no
            admin_business.business_id = business_id
            admin_business.rate = rate
            admin_business.status = 1
        db.session.add(admin_business)

    db.session.commit()
    return BaseResponse()
