#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@file: error_code.py
"""

###  通用错误相关
Param_Invalid_Error = {
    "error_code": "500",
    "error_message": "params is invalid, 参数无效"
}

TOKEN_NOT_VALID_ERROR = {
    "error_code": "1001",
    "error_message": "无效的token"
}

TOKEN_NOT_PROVIDED_ERROR = {
    "error_code": "1002",
    "error_message": "token未提供"
}

TOKEN_EXPIRE_ERROR = {
    "error_code": "1003",
    "error_message": "token超时"
}

PHONE_NOT_BINDING_ERROR = {
    "error_code": "1004",
    "error_message": "未绑定手机号"
}

PHONE_NOT_NULL_ERROR = {
    "error_code": "1005",
    "error_message": "手机号为空"
}

PHONE_NOT_VALID_ERROR = {
    "error_code": "1006",
    "error_message": "无效的手机号"
}

USER_ALREADY_REGISTER_ERROR = {
    "error_code": "1007",
    "error_message": "用户已注册"
}

VERIFICATION_CODE_NULL_ERROR = {
    "error_code": "1008",
    "error_message": "验证码为空"
}

VERIFICATION_CODE_INVALID_ERROR = {
    "error_code": "1009",
    "error_message": "验证码已失效"
}

VERIFICATION_CODE_ERROR = {
    "error_code": "1010",
    "error_message": "验证码错误"
}

PASSWORD_ERROR = {
    "error_code": "1011",
    "error_message": "账号或密码错误"
}

# 账号相关  12开头
ACCOUNT_ALREADY_EXISTS_ERROR = {
    "error_code": '1012',
    "error_message": "该账号已存在"
}

ACCOUNT_NOT_EXISTS_ERROR = {
    "error_code": '1013',
    "error_message": "账号不存在"
}

ACCOUNT_ALREADY_DELETE_ERROR = {
    "error_code": '1014',
    "error_message": "账号已被删除"
}

ACCOUNT_AGENT_SPOT_NULL_ERROR = {
    "error_code": '1015',
    "error_message": "代理商景点列表为空"
}

AGNET_MODULES_ERROR = {
    "error_code": '1016',
    "error_message": "用户未绑定模块"
}

OPERATE_TYPE_ERROR = {
    "error_code": '1017',
    "error_message": "type错误"
}

OPERATE_LEVEL_ERROR = {
    "error_code": '1018',
    "error_message": "权限错误"
}

OPERATE_ERROR = {
    "error_code": '1019',
    "error_message": "操作有误"
}

MODULES_NOT_EXISTS_ERROR = {
    "error_code": '1020',
    "error_message": "modules not exists,模块不存在"
}

ACCOUNT_AGENT_SPOT_NOT_EXIST = {
    "error_code": '1021',
    "error_message": "agent spot not exists,代理景区不存在"
}

AGENT_MACHINE_NOT_EXIST = {
    "error_code": '1022',
    "error_message": "agent machine not exists,代理机柜不存在"
}

## 微信登陆相关
WX_LOGIN_DATA_ERROR = {
    "error_code": "3001",
    "error_message": "微信登录数据错误"
}

WX_LOGIN_CODE_ERROR = {
    "error_code": "3002",
    "error_message": "微信登录code值错误"
}

WX_OPENID_NOT_GET_ERROR = {
    "error_code": "3003",
    "error_message": "微信OpenId获取失败，请刷新重试"
}

WX_SESSION_KEY_ERROR = {
    "error_code": "3004",
    "error_message": "session key error"
}

###  微信支付相关

WE_MINIAPP_PAY_FAIL = {
    "error_code": "3101",
    "error_message": "小程序下单失败"
}

###  消息推送相关

WXBizMsgCrypt_OK = {
    "error_code": "0",
    "error_message": "WXBizMsgCrypt_OK"
}

WXBizMsgCrypt_ValidateSignature_Error = {
    "error_code": "4001",
    "error_message": "验证签名错误"
}

WXBizMsgCrypt_ParseXml_Error = {
    "error_code": "4002",
    "error_message": "解析xml错误"
}

WXBizMsgCrypt_ComputeSignature_Error = {
    "error_code": "4003",
    "error_message": "计算签名错误"
}

WXBizMsgCrypt_IllegalAesKey = {
    "error_code": "4004",
    "error_message": "Aes key非法错误"
}

WXBizMsgCrypt_ValidateAppid_Error = {
    "error_code": "4005",
    "error_message": "appid错误"
}

WXBizMsgCrypt_EncryptAES_Error = {
    "error_code": "4006",
    "error_message": "aes加密错误"
}

WXBizMsgCrypt_DecryptAES_Error = {
    "error_code": "4007",
    "error_message": "aes解密错误"
}

WXBizMsgCrypt_IllegalBuffer = {
    "error_code": "4008",
    "error_message": "illegal buffer"
}

WXBizMsgCrypt_EncodeBase64_Error = {
    "error_code": "4009",
    "error_message": "base64加密错误"
}

WXBizMsgCrypt_DecodeBase64_Error = {
    "error_code": "4010",
    "error_message": "base64解密错误"
}

WXBizMsgCrypt_GenReturnXml_Error = {
    "error_code": "4011",
    "error_message": "gen return xml error"
}

MACHINE_NOT_EXIST_ERROR = {
    "error_code": '5001',
    "error_message": "机柜不存在"
}
MACHINE_IS_USE_ERROR = {
    "error_code": '5002',
    "error_message": "已有他人正在租借中，请稍后"
}

MACHINE_IS_NOT_ONLINE_ERROR = {
    "error_code": '5003',
    "error_message": "机柜不在线"
}

MACHINE_ADD_ERROR = {
    "error_code": '5004',
    "error_message": "机柜添加失败"
}

MACHINE_NO_DUPLICATE_ERROR = {
    "error_code": '5005',
    "error_message": "machine_no duplicate,机柜编号重复"
}

MACHINE_EDIT_ERROR = {
    "error_code": '5006',
    "error_message": "machine edit error, 机柜修改错误"
}

HATCH_NOT_EXIST_ERROR = {
    "error_code": "5007",
    "error_message": "no hatch, 没有商品信息"
}

HATCH_NOT_ALL_EXIST_ERROR = {
    "error_code": "5008",
    "error_message": "no all hatch, 存在已售出商品"
}

HATCH_COUNT_ERROR = {
    "error_code": "5009",
    "error_message": "hatch count error, 商品数量错误，检查数量"
}

MACHINE_ACTIVATED_ERROR = {
    "error_code": '5010',
    "error_message": "machine activated, 机柜已激活"
}

### 订单相关
RENT_ORDER_NOT_BACK_ERROR = {
    "error_code": '6101',
    "error_message": "有未归还的订单"
}

RENT_ORDER_NOT_TAKE_ERROR = {
    "error_code": '6102',
    "error_message": "有未取货的订单"
}

RENT_ORDER_NUMBER_MAX = {
    "error_code": '6103',
    "error_message": "订单数量达到上限"
}

TAKE_CODE_NOT_VALID = {
    "error_code": '6104',
    "error_message": "取货码错误请确认手机号及取货码是否匹配"
}

CODE_CANCEL_ERROR = {
    "error_code": '6105',
    "error_message": "取货码已取消"
}

CODE_USED_ERROR = {
    "error_code": '6108',
    "error_message": "取货码已使用"
}

NO_POWER_ERROR = {
    "error_code": '6106',
    "error_message": "没有可租借设备"
}
NO_RENT_RECORD = {
    "error_code": '6107',
    "error_message": "订单不存在"
}

CODE_USED_ERROR = {
    "error_code": '6108',
    "error_message": "取货码已使用"
}

RENT_ORDER_NUMBER_LIMIT = {
    "error_code": '6109',
    "error_message": "机柜只允许租借一台"
}

REFUND_NOT_RENT_INFO = {
    "error_code": "6301",
    "error_message": "没有该订单信息"
}

REFUND_BACK_TIME_ERROR = {
    "error_code": "6302",
    "error_message": "归还时间异常"
}

REFUND_NOT_PRODUCTION_INFO = {
    "error_code": "6303",
    "error_message": "没有该讲解器信息"
}

REFUND_MONEY_IS_ZERO = {
    "error_code": "6304",
    "error_message": "退款金额为零"
}

REFUND_NO_DUPLICATE = {
    "error_code": "6305",
    "error_message": "退款单号重复"
}

TALLYMAN_ACCOUNT_EXIST = {
    "error_code": "7001",
    "error_message": "tallyman account exist, 补货员账号已存在"
}

TALLYMAN_ACCOUNT_NOT_EXIST = {
    "error_code": "7002",
    "error_message": "tallyman account not exist, 补货员账号不存在"
}

NFC_CARD_NOT_EXIST = {
    "error_code": "8001",
    "error_message": "nfc card not exist, 卡号错误"
}

NFC_CARD_ACTIVATED_ERROR = {
    "error_code": "8002",
    "error_message": "nfc card  activated, 卡片已激活"
}

NO_NFC_CARD_ERROR = {
    "error_code": "8003",
    "error_message": "no nfc card , 不存在卡片"
}

RE_NFC_CARD_ERROR = {
    "error_code": "8004",
    "error_message": "re nfc card , 卡片已存在"
}

NFC_PAY_LOAD_SECRET_ERROR = {
    "error_code": "8005",
    "error_message": "secret error , 身份验证失败"
}
NO_PLACE_ERROR = {
    "error_code": "9001",
    "error_message": "no place error,不存在场景"
}
