# -*- coding: utf-8 -*-
import datetime
import logging
import time
from flask import Blueprint, jsonify, request, g
from pymongo import MongoClient, ASCENDING
from config.wechat_config import platform_config_list
from config.commen_config import LOGIN_TYPE, ACCOUNT_STATUS
from service.admin_service import AdminService
from utils.error_code import ACCOUNT_AGENT_SPOT_NULL_ERROR, ACCOUNT_NOT_EXISTS_ERROR, \
    ACCOUNT_ALREADY_EXISTS_ERROR, ACCOUNT_ALREADY_DELETE_ERROR, AGNET_MODULES_ERROR, MODULES_NOT_EXISTS_ERROR, \
    OPERATE_LEVEL_ERROR
from utils.error_code import PHONE_NOT_NULL_ERROR, PHONE_NOT_VALID_ERROR, TOKEN_NOT_VALID_ERROR, \
    VERIFICATION_CODE_INVALID_ERROR, VERIFICATION_CODE_ERROR, PASSWORD_ERROR
from models.base_model import db
from models.models import AdminAccount, AdminLoginRecord, AdminMachine
from utils.jwt_util import verify_jwt, generate_jwt
from utils.my_response import BaseResponse
from service.sms_service import SMSService

logger = logging.getLogger(__name__)

admin_route = Blueprint('admin', __name__)


@admin_route.route('/test')
def test():
    ip = request.remote_addr
    return BaseResponse(**{'code': 200, 'msg': 'success!', 'data': ip})


@admin_route.route('/login', methods=['GET', 'POST'])
def user_login():
    token = request.headers.get('Authorization')
    platform = request.headers.get('platform')
    cur_ip = request.remote_addr
    json_data = request.get_json()

    data = {}
    phone = json_data['phone'] if 'phone' in json_data else None
    code = json_data['code'] if 'code' in json_data else None
    # login_type = json_data['type'] if 'type' in json_data else 1  # 1.验证码登录，2.密码登录
    login_type = 2
    if token:
        # token登录
        # "校验token"
        payload = verify_jwt(token)
        # "判断token的校验结果"
        if not payload:
            return BaseResponse(**TOKEN_NOT_VALID_ERROR)

        # "获取载荷中的信息赋值"
        user_id = payload.get('user_id')
        if not user_id:
            return BaseResponse(**TOKEN_NOT_VALID_ERROR)
        user_info = AdminAccount.query.filter_by(id=user_id, status=1).first()
    else:
        if login_type == 1:
            # 验证码登录
            # 判断验证码是否正确
            sms = SMSService()
            res = sms.verificate(phone, code)
            if res == -1:
                return BaseResponse(**VERIFICATION_CODE_INVALID_ERROR)
            elif res == -2:
                return BaseResponse(**VERIFICATION_CODE_ERROR)

            user_info = AdminAccount.query.filter_by(phone=phone, status=1).first()
            if not user_info:
                return BaseResponse(**PHONE_NOT_VALID_ERROR)
        else:
            # 密码登录
            # 判断密码是否正确
            user_info = AdminAccount.query.filter_by(phone=phone, status=1).first()
            if not user_info:
                return BaseResponse(**PHONE_NOT_VALID_ERROR)

            if not user_info.check_password(pasword=code):
                return jsonify(PASSWORD_ERROR)

    new_token = generate_jwt(payload={"user_id": user_info.id}, expiry=time.time() + 24 * 60 * 60)

    agent_log = AdminLoginRecord()
    agent_log.phone = user_info.phone
    agent_log.ip = cur_ip
    agent_log.platform = platform_config_list.index(platform)
    agent_log.last_login = datetime.datetime.now()
    agent_log.login_type = LOGIN_TYPE['token_login']
    agent_log.created_at = datetime.datetime.now()
    agent_log.updated_at = datetime.datetime.now()
    db.session.add(agent_log)
    db.session.commit()

    data['token'] = new_token
    data['user_name'] = user_info.user_name
    data['phone'] = user_info.phone
    data['level'] = user_info.level
    return BaseResponse(data=data)


@admin_route.route('/add_account', methods=['GET', 'POST'])
def add_user():
    admin = g.user
    json_data = request.get_json()
    user_name = json_data['user_name']
    phone = json_data['phone']
    level = int(json_data['level'])
    if level < admin.level:
        return jsonify(OPERATE_LEVEL_ERROR)
    password = json_data.get('password', "123456")
    comment = json_data.get('comment', "")
    parent_id = json_data.get("parent_id", 0)
    draw = json_data.get("draw", 0)
    rate = json_data.get("rate", 0)

    account = AdminAccount.query.filter_by(phone=phone).first()
    if account:
        if account.status != -1:
            return jsonify(account)

    else:
        account = AdminAccount()

    account.user_no = "todo"
    account.user_name = user_name
    account.phone = phone
    account.level = level
    account.draw = draw
    account.rate = rate
    account.parent_id = parent_id
    account.status = 1
    account.comment = comment
    account.created_at = datetime.datetime.now()
    account.updated_at = datetime.datetime.now()
    if password:
        account.password = password
    db.session.add(account)
    db.session.commit()
    account.user_no = "SK" + str(account.id).zfill(6)
    db.session.add(account)
    db.session.commit()

    return BaseResponse()


@admin_route.route('/account_list', methods=["POST"])
def get_account_list():
    json_data = request.get_json()
    page = json_data.get("page", None)
    page_size = json_data.get("pageSize", None)
    keyword = json_data.get("keyword", None)

    select_sql = """select agent_account.user_name, agent_account.phone, agent_account.level, agent_account.status,
                    agent_account.comment, agent_account.created_at, agent_account.updated_at, agent_account.last_login,
                    agent_account.id
                    """
    count_sql = "select count(agent_account.id) as total_count"

    from_sql = " from agent_account where agent_account.id in ( select agent_account.id  "
    from_sql += " from agent_account  "
    from_sql += " left join agent_spot on agent_account.id = agent_spot.agent_no "
    from_sql += " left join spot on spot.id = agent_spot.spot_no "
    where_sql = " where 0=0 "
    if keyword:
        where_sql += """
            and CONCAT(agent_account.user_name,agent_account.phone,spot.spotname) LIKE '%{keyword}%'

                """.format(keyword=keyword)
    where_sql += " ) "
    order_sql = "  ORDER BY agent_account.created_at ASC, agent_account.status ASC"
    limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    for info in result:
        return_data.append(
            {"user_name": info.user_name, "phone": info.phone, "level": info.level, "status": info.status,
             "comment": info.comment, "agent_id": info.id,
             "create_time": info.created_at.strftime("%Y-%m-%d %H:%M:%S") if info.last_login else "",
             "update_time": info.updated_at.strftime("%Y-%m-%d %H:%M:%S") if info.last_login else "",
             "login_time": info.last_login.strftime("%Y-%m-%d %H:%M:%S") if info.last_login else ""})

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@admin_route.route('/account_detail', methods=["POST"])
def get_account_detail():
    json_data = request.get_json()
    phone = json_data["phone"]

    agent_info = AdminAccount.query.filter_by(phone=phone).first()
    if not agent_info:
        return BaseResponse(**ACCOUNT_NOT_EXISTS_ERROR)
    user_info = {}
    user_info["agent_no"] = agent_info.agent_no
    user_info["user_name"] = agent_info.user_name
    user_info["phone"] = phone
    user_info["level"] = agent_info.level
    user_info["status"] = ACCOUNT_STATUS['on_use']
    user_info["comment"] = agent_info.comment

    agent_spot_list = AgentSpot.query.filter_by(agent_no=agent_info.id, status=1).all()
    if agent_spot_list:
        spot_no_list = [i.spot_no for i in agent_spot_list]
    else:
        user_info["spot_list"] = []
        return BaseResponse(data=user_info)

    spot_list = db.session.query(Spot).filter(Spot.id.in_(spot_no_list)).all()
    if spot_list:
        spot_data_list = [
            {"spot_name": i.spotname, "spot_id": i.id, "business_id": i.business_id, "spot_address": i.address} for i in
            spot_list]
    else:
        spot_data_list = []
    user_info["spot_list"] = spot_data_list
    return BaseResponse(data=user_info)


@admin_route.route('/edit_account', methods=['GET', 'POST'])
def edit_user():
    json_data = request.get_json()
    old_phone = json_data['old_phone'] if 'old_phone' in json_data else ''
    new_phone = json_data['new_phone'] if 'new_phone' in json_data else ''
    user_name = json_data['name'] if 'name' in json_data else 'SSW'
    password = json_data['password'] if 'password' in json_data else ''
    comment = json_data['comment'] if 'comment' in json_data else ''
    level = json_data['level'] if 'level' in json_data else ''
    status = json_data['status'] if 'status' in json_data else ''
    spot_list = json_data['spot_list'] if 'spot_list' in json_data else []
    if not old_phone:
        return BaseResponse(error_code=-1, error_message='old phone is null')

    if not new_phone:
        return BaseResponse(**PHONE_NOT_NULL_ERROR)

    if not status:
        return BaseResponse(**Param_Invalid_Error)

    result = Helper.check_phone(new_phone)
    if not result:
        return BaseResponse(**PHONE_NOT_VALID_ERROR)

    if not spot_list:
        return BaseResponse(**ACCOUNT_AGENT_SPOT_NULL_ERROR)

    agent_info = AdminAccount.query.filter_by(phone=old_phone).first()
    if not agent_info:
        return BaseResponse(**ACCOUNT_NOT_EXISTS_ERROR)

    agent_info.user_name = user_name
    agent_info.phone = new_phone
    agent_info.status = status
    agent_info.comment = comment

    if level:
        agent_info.level = int(level)

    if password:
        salt = AgentService.gene_salt()
        agent_info.salt_pwd = salt
        agent_info.password = AgentService.gene_pwd(password, salt)

    db.session.add(agent_info)

    agent_spot_info = AgentSpot.query.filter_by(agent_no=agent_info.id).all()
    for info in agent_spot_info:
        info.status = ACCOUNT_STATUS['delete']
        db.session.add(info)

    for i in spot_list:
        cur_spot_info = AgentSpot.query.filter_by(agent_no=agent_info.id, spot_no=i).first()
        if not cur_spot_info:
            cur_agent_spot = AgentSpot()
            cur_agent_spot.agent_no = agent_info.id
            cur_agent_spot.spot_no = i
            cur_agent_spot.status = ACCOUNT_STATUS['on_use']
            cur_agent_spot.created_at = datetime.datetime.now()
            cur_agent_spot.updated_at = datetime.datetime.now()
            db.session.add(cur_agent_spot)
        else:
            cur_spot_info.status = ACCOUNT_STATUS['on_use']
            db.session.add(cur_spot_info)

    db.session.commit()
    return BaseResponse()


@admin_route.route('/delete_account', methods=['GET', 'POST'])
def delete_user():
    json_data = request.get_json()
    phone = json_data['phone'] if 'phone' in json_data else ''
    if not phone:
        return BaseResponse(**PHONE_NOT_NULL_ERROR)

    agent_info = AdminAccount.query.filter_by(phone=phone).first()
    if not agent_info:
        return BaseResponse(**ACCOUNT_NOT_EXISTS_ERROR)

    agent_spot_info = AgentSpot.query.filter_by(agent_no=agent_info.id).all()
    for info in agent_spot_info:
        info.status = ACCOUNT_STATUS['delete']
        db.session.add(info)

    agent_info.status = ACCOUNT_STATUS['delete']
    db.session.add(agent_info)
    db.session.commit()

    return BaseResponse()


@admin_route.route('/sendCode', methods=['GET', 'POST'])
def send_code():
    json_data = request.get_json()
    cur_ip = request.remote_addr
    phone = json_data['phone'] if 'phone' in json_data else None

    if not phone:
        return BaseResponse(**PHONE_NOT_NULL_ERROR)

    # 判断该手机号是否再数据库中，不在返回无权限登录
    agent = AdminAccount.query.filter_by(phone=phone).first()
    if not agent:
        return BaseResponse(**PHONE_NOT_VALID_ERROR)

    # 判断该账号是否已被删除
    if agent.status == ACCOUNT_STATUS['delete']:
        return BaseResponse(**ACCOUNT_ALREADY_DELETE_ERROR)

    # result = Helper.check_phone(phone)
    # if not result:
    #     return BaseResponse(**PHONE_NOT_VALID_ERROR)

    sms = SMSService()
    result = sms.phoneSendCode(phone, 520391, '灰兔智能')
    logger.info(result)

    agent_log = AdminLoginRecord()
    agent_log.phone = phone
    agent_log.ip = cur_ip
    agent_log.last_login = datetime.datetime.now()
    agent_log.login_type = LOGIN_TYPE['send_code']
    agent_log.created_at = datetime.datetime.now()
    agent_log.updated_at = datetime.datetime.now()
    db.session.add(agent_log)
    db.session.commit()

    return BaseResponse()


@admin_route.route('/agent_module_list', methods=['GET', 'POST'])
def get_agent_module_list():
    agent_id = g.user.id
    platform = g.platform
    if int(g.user.level) != 1:
        agent_modules = AgentModules()
        result = agent_modules.find_one({"agent_id": agent_id, "platform": platform})
        return_data = {"agent_id": agent_id, "module_list": result["module_list"]}
        if result:
            return BaseResponse(data=return_data)
        else:
            return BaseResponse(**AGNET_MODULES_ERROR)

    modules = Modules()
    result = modules.collection.find({"platform": platform}).sort(
        [("parent_id", ASCENDING), ("order_no", ASCENDING)])
    if not result:
        return BaseResponse(**MODULES_NOT_EXISTS_ERROR)
    parent_module_list = list(result)
    tmp_data = {}
    for i in parent_module_list:
        i.pop("_id")
        if i["parent_id"] == 0:
            i["children"] = []
            tmp_data[i["id"]] = i
        else:
            tmp_data[i["parent_id"]]["children"].append(i)
    module_list = list(tmp_data.values())

    return_data = {"agent_id": agent_id, "module_list": module_list}
    if result:
        return BaseResponse(data=return_data)
    else:
        return BaseResponse(**AGNET_MODULES_ERROR)


@admin_route.route('/agent_module_list_by_agent_id', methods=['GET', 'POST'])
def get_agent_module_list_by_agent_id():
    admin_user = g.user
    if int(admin_user.level) != 1:
        return BaseResponse(**OPERATE_LEVEL_ERROR)
    platform = g.platform
    json_data = request.get_json()
    agent_id = json_data.get("agent_id", None)
    agent_modules = AgentModules()
    result = agent_modules.find_one({"agent_id": agent_id, "platform": platform})
    if result:
        return_data = {"agent_id": agent_id, "module_list": result["module_list"]}
    else:
        return_data = {"agent_id": agent_id, "module_list": []}
    return BaseResponse(data=return_data)


@admin_route.route("/set_module_list", methods=['GET', 'POST'])
def set_agent_module_list():
    parent_agent_id = g.user.id
    platform = g.platform
    platform_int = platform
    json_data = request.get_json()
    module_list = json_data.get("module_list", [])
    agent_id = json_data.get("agent_id", None)

    if not module_list or not agent_id:
        return BaseResponse(**Param_Invalid_Error)
    agent_modules = AgentModules()
    modules = Modules()
    if int(g.user.level) == 1:

        result = modules.collection.find({"platform": platform}).sort(
            [("parent_id", ASCENDING), ("order_no", ASCENDING)])
        if not result:
            return BaseResponse(**MODULES_NOT_EXISTS_ERROR)
        parent_module_list = list(result)

        return_data = []
        tmp_data = {}
        for i in parent_module_list:
            i.pop("_id")
            if i["id"] in module_list:
                if i["parent_id"] == 0:
                    i["children"] = []
                    tmp_data[i["id"]] = i
                else:
                    tmp_data[i["parent_id"]]["children"].append(i)
        return_data = list(tmp_data.values())

    else:
        result = agent_modules.collection.find_one({"platform": platform_int, "agent_id": parent_agent_id})
        if not result:
            return BaseResponse(**MODULES_NOT_EXISTS_ERROR)
        parent_module_list = result["module_list"]

        return_data = []
        for i in parent_module_list:
            if i["id"] in module_list:
                tmp_data = i
                children_list = i["children"]
                tmp_data["children"] = []
                for j in children_list:
                    if j["id"] in module_list:
                        tmp_data["children"].append(j)
                return_data.append(tmp_data)

    for i in range(3):
        agent_modules.collection.replace_one({'agent_id': agent_id, "platform": platform_int},
                                             {'agent_id': agent_id, "platform": platform_int,
                                              "module_list": return_data},
                                             upsert=True)
        result = agent_modules.collection.find_one({'agent_id': agent_id, "platform": platform_int,
                                                    "module_list": return_data})
        if result:
            return BaseResponse()
        else:
            continue
    return BaseResponse(**COMMON_MONGO_ERROR)


# @admin_route.route("/set_super_user_module_list", methods=['GET', 'POST'])
def set_super_agent_module_list():
    platform = g.platform
    platform_int = platform
    json_data = request.get_json()
    module_list = json_data.get("module_list", [])
    agent_id_list = json_data.get("agent_id_list", None)

    if not module_list or not agent_id_list:
        return BaseResponse(**Param_Invalid_Error)
    agent_modules = AgentModules()
    modules = Modules()
    result = modules.collection.find({"platform": platform_int, "id": {"$in": module_list}}).sort(
        [("parent_id", ASCENDING), ("order_no", ASCENDING)])
    if not result:
        return BaseResponse(**MODULES_NOT_EXISTS_ERROR)
    parent_module_list = list(result)
    tmp_data = {}
    for i in parent_module_list:
        i.pop("_id")
        if i["parent_id"] == 0:
            i["children"] = []
            tmp_data[i["id"]] = i
        else:
            tmp_data[i["parent_id"]]["children"].append(i)
    return_data = list(tmp_data.values())
    for agent_id in agent_id_list:
        for i in range(3):
            agent_modules.collection.replace_one({'agent_id': agent_id, "platform": platform_int},
                                                 {'agent_id': agent_id, "platform": platform_int,
                                                  "module_list": return_data},
                                                 upsert=True)
            result = agent_modules.collection.find_one({'agent_id': agent_id, "platform": platform_int,
                                                        "module_list": return_data})

            if result:
                break
            else:
                continue
    return BaseResponse()
