#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/12
@file: place_portal.py
@function:
@modify:
"""
import logging

from flask import Blueprint, g, request, jsonify
from models.base_model import db
from utils.error_code import OPERATE_LEVEL_ERROR
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

rent_route = Blueprint('rent', __name__)


@rent_route.route("rent_list", methods=["POST"])
def run_rent_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    keyword = json_data.get("keyword", None)
    start_date = json_data.get("startDate", None)
    end_date = json_data.get("endDate", None)
    business_id = json_data.get("business_id", None)
    is_pay = json_data.get("is_pay", None)

    if g.user.level not in (1, 2, 4):
        return jsonify(OPERATE_LEVEL_ERROR)
    select_sql = """
                    SELECT  rent.rent_no, rent.machine_no, rent.user_id,rent.place_id,rent.is_pay,
                        rent_detail.hatch_no, rent_detail.production_id,rent_detail.production_name,
                         rent_detail.status,rent_detail.brand_name, 
                        rent_detail.production_type_name,rent_detail.total,rent_detail.rent_count,
                        rent_detail.refund_total,rent_detail.refund_count, wx_user.phone,place.place_name,
                        rent_detail.id as rent_detail_id, rent.business_id, rent.created_at,rent.pay_time
                    """
    count_sql = " select count(rent.id) as total_count "

    from_sql = """
                    FROM
                        rent
                            LEFT JOIN
                        rent_detail ON rent.rent_no = rent_detail.rent_no
                            LEFT JOIN
                        place ON rent.place_id = place.id
                            LEFT JOIN
                        wx_user ON rent.user_id = wx_user.id
                    """

    where_sql = " WHERE 0=0 "
    if keyword:
        where_sql += """
                        and CONCAT(rent.rent_no,
                                    wx_user.phone) LIKE '%{keyword}%'
                    """.format(keyword=keyword)

    if start_date:
        where_sql += " and rent.created_at > '{}'".format(start_date)
    if end_date:
        where_sql += " and rent.created_at <= '{}'".format(end_date)

    if is_pay:
        where_sql += " and rent.is_pay = '{}'".format(is_pay)

    if business_id:
        where_sql += " and rent.business_id = '{}'".format(business_id)

    if g.user.level != 1:
        where_sql += """ and rent.business_id in ( 
                                    select business_id from admin_business where user_id = '{}' and status = 1)
                     """.format(g.user.id)

    order_sql = " ORDER BY rent.created_at DESC, rent_detail.created_at desc"
    limit_sql = " LIMIT {offset} , {page_size}".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    if result:
        for info in result:
            tmp = {
                "rent_no": info.rent_no, "machine_no": info.machine_no, "user_id": info.user_id,
                "phone": info.phone, "rent_detail_id": info.rent_detail_id, "place_name": info.place_name,
                "place_id": info.place_id, "is_pay": info.is_pay, "total": info.total, "rent_count": info.rent_count,
                "refund_total": info.refund_total, "refund_count": info.refund_count, "business_id": info.business_id,
                "production_name": info.production_name, "production_id": info.production_id,
                "status": info.status, "create_time": info.created_at.strftime("%Y-%m-%d %H:%M:%S"),
                "pay_time": info.pay_time.strftime("%Y-%m-%d %H:%M:%S"),
            }
            return_data.append(tmp)

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@rent_route.route("rent_detail", methods=["POST"])
def get_rent_detail():
    """

    :return:
    """
    json_data = request.get_json()
    rent_no = json_data.get("rent_no", None)
    rent_detail_id = json_data.get("rent_detail_id", None)
    if g.user.level not in (1, 2, 4):
        return jsonify(OPERATE_LEVEL_ERROR)

    select_sql = """
                        SELECT rent.id, rent.rent_no, rent.machine_no, rent.user_id,rent.place_id,rent.is_pay,
                            rent_detail.hatch_no, rent_detail.production_name,rent_detail.title, rent_detail.brand_id,
                            rent_detail.production_type_id, rent_detail.price,rent_detail.original_price,
                            rent_detail.weight, rent_detail.weight_unit, rent_detail.expiration_date, 
                            rent_detail.expiration_date_unit, rent_detail.is_expiration_date,rent_detail.business_id,
                            rent_detail.weight_error, rent_detail.img, rent_detail.tags, rent_detail.content,
                            rent_detail.summary, rent_detail.status,rent_detail.brand_name, 
                            rent_detail.production_type_name,rent_detail.total,rent_detail.rent_count,
                            rent_detail.refund_total,rent_detail.refund_count, wx_user.phone,place.place_name,
                            rent_detail.production_id,rent.business_id, rent.created_at,rent.pay_time,
                            rent_detail.id as rent_detail_id, 
                        """
    from_sql = """
                        FROM
                            rent
                                LEFT JOIN
                            rent_detail ON rent.rent_no = rent_detail.rent_no
                                LEFT JOIN
                            place ON rent.place_id = place.id
                                LEFT JOIN
                            wx_user ON rent.user_id = wx_user.id
                        """

    where_sql = " where rent.rent_no = '{}'".format(rent_no)
    if rent_detail_id:
        where_sql += " and rent_detail.id = '{}'".format(rent_detail_id)
    if g.user.level != 1:
        where_sql += """ and rent.business_id in ( 
                                    select business_id from admin_business where user_id = '{}' and status = 1)
                     """.format(g.user.id)

    result = db.session.execute(select_sql + from_sql + where_sql).fetchone()

    if result:

        return_data = {
            "rent_detail_id": result.rent_detail_id, "rent_no": result.rent_no, "machine_no": result.machine_no,
            "user_id": result.user_id,
            "phone": result.phone, "place_name": result.place_name,
            "place_id": result.id, "is_pay": result.is_pay, "total": result.total, "rent_count": result.rent_count,
            "refund_total": result.refund_total, "refund_count": result.refund_count, "business_id": result.business_id,
            "production_name": result.production_name, "production_id": result.production_id,
            "title": result.title, "brand_id": result.brand_id, "brand_name": result.brand_name,
            "production_type_id": result.production_type_id, "production_type_name": result.production_type_name,
            "price": result.price, "original_price": result.original_price, "weight": result.weight,
            "weight_unit": result.weight_unit,
            "expiration_date": result.expiration_date, "expiration_date_unit": result.expiration_date_unit,
            "is_expiration_date": result.is_expiration_date,
            "weight_error": result.weight_error,
            "img": result.img, "tags": result.tags, "content": result.content,
            "summary": result.summary, "status": result.status,
            "create_time": result.created_at.strftime("%Y-%m-%d %H:%M:%S"),
            "pay_time": result.pay_time.strftime("%Y-%m-%d %H:%M:%S"),
        }
        return BaseResponse({"data": return_data})

    else:
        return BaseResponse()
