#!usr/bin/env python
# -*- coding:utf-8 _*-

import json
import logging
import time
import os

from utils.jwt_util import generate_jwt
from config.env_path_config import env_path
from dotenv import load_dotenv
from flask import Blueprint, request, jsonify, g
from models.base_model import db
from utils.my_response import BaseResponse
from models.models import Management
from utils.error_code import PASSWORD_ERROR
from service.make_token import generate_token,certify_token
logger = logging.getLogger(__name__)
# 创建蓝图
login_route = Blueprint('login', __name__)

#登录
@login_route.route("login_phone",methods=["post"])
def login():
    json_date = request.get_json()
    number = json_date["number"]
    password = json_date['password']
    #手机号登录
    phone_result = Management.query.filter_by(phone=number, status=1).first()
    if phone_result:
        # 进行密码验证
        if phone_result.check_password(password) == True:
            load_dotenv(dotenv_path=env_path, verbose=True, override=True)
            SECRET_KEY = os.getenv('SECRET_KEY')
            token = generate_jwt({"user_id": phone_result.id}, time.time() + 6000, SECRET_KEY)
            date={
                "token": token,
                "success": True
            }
            return BaseResponse(data=date)
        else:
            return BaseResponse(**PASSWORD_ERROR)

    # 用户id登录
    user_result = Management.query.filter_by(user_no=number, status=1).first()
    if user_result:
        # 进行密码验证
        if user_result.check_password(password) == True:
            load_dotenv(dotenv_path=env_path, verbose=True, override=True)
            SECRET_KEY = os.getenv('SECRET_KEY')
            token = generate_jwt({"user_id": user_result.id}, time.time() + 6000, SECRET_KEY)
            date = {
                "token": token,
                "success": True
            }
            return BaseResponse(data=date)
        else:
            return BaseResponse(**PASSWORD_ERROR)

    return BaseResponse(date="无法登录，用户id或手机号错误")
