#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@file: hatch_portal.py
"""
import logging

from flask import Blueprint, request, jsonify

from models.models import Machine, Production, Hatch
from utils.error_code import MACHINE_NOT_EXIST_ERROR, HATCH_NOT_EXIST_ERROR
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

hatch_route = Blueprint('hatch', __name__)


@hatch_route.route('list', methods=["post"])
def get_production_list():
    json_data = request.get_json()
    machine_no = json_data["machine_no"]

    machine_info = Machine.query.filter_by(machine_no=machine_no, status=1).first()
    if not machine_info:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    hatch_list = Hatch.query.filter_by(machine_no=machine_no, status=1).order_by(Hatch.hatch_no.asc()).all()
    if not hatch_list:
        return jsonify(HATCH_NOT_EXIST_ERROR)

    tmp_dict = {}
    for i in hatch_list:
        if tmp_dict.get(i.production_id, None):
            tmp_dict[i.production_id] = {
                "machine_no": i.machine_no,
                "hatch_no": i.hatch_no,
                "production_id": i.production_id,
                "name": i.name,
                "title": i.title,
                "brand_id": i.brand_id,
                "brand_name": i.brand_name,
                "cate_id": i.cate_id,
                "cate_name": i.cate_name,
                "price": i.price,
                "original_price": i.original_price,
                "img": i.img,
                "tags": i.tags,
                "content": i.content,
                "summary": i.summary,
                "status": i.status,
                "count": 1
            }
        else:
            tmp_dict[i.production_id]["count"] += 1
    hatch_data = tmp_dict.values()
    return BaseResponse(data=hatch_data)


@hatch_route.route('info', methods=["post"])
def get_production_info():
    json_data = request.get_json()
    machine_no = json_data["machine_no"]
    hatch_no = json_data["hatch_no"]

    machine_info = Machine.query.filter_by(machine_no=machine_no, status=1).first()
    if not machine_info:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    hatch_info = Hatch.query.filter_by(machine_no=machine_no, hatch_no=hatch_no).first()
    if not hatch_info:
        return jsonify(HATCH_NOT_EXIST_ERROR)

    hatch_data = {
        "machine_no": hatch_info.machine_no,
        "hatch_no": hatch_info.hatch_no,
        "production_id": hatch_info.production_id,
        "name": hatch_info.name,
        "title": hatch_info.title,
        "brand_id": hatch_info.brand_id,
        "brand_name": hatch_info.brand_name,
        "cate_id": hatch_info.cate_id,
        "cate_name": hatch_info.cate_name,
        "price": hatch_info.price,
        "original_price": hatch_info.original_price,
        "img": hatch_info.img,
        "tags": hatch_info.tags,
        "content": hatch_info.content,
        "summary": hatch_info.summary,
        "status": hatch_info.status,
    }

    return BaseResponse(data=hatch_data)
