 # -*- coding: utf-8 -*-
import datetime
import logging
import time

from flask import Blueprint, jsonify, request, g
from sqlalchemy import func

from config.base_config import MONGO_DATABASE_URI
from config.commen_config import LOGIN_TYPE

from models.base_model import db
from models.models import TallymanAccount, TallymanMachine, TallymanLoginRecord, Machine, Hatch, TallyRecord,\
    TallymanPlace
from service.tallyman_service import TallymanService
from utils.error_code import TALLYMAN_ACCOUNT_EXIST, PHONE_NOT_VALID_ERROR, TOKEN_NOT_VALID_ERROR, PASSWORD_ERROR, \
    TALLYMAN_ACCOUNT_NOT_EXIST, MACHINE_NOT_EXIST_ERROR, HATCH_NOT_EXIST_ERROR, MACHINE_ACTIVATED_ERROR,\
    USER_ALREADY_REGISTER_ERROR
from utils.jwt_util import verify_jwt, generate_jwt
from utils.my_response import BaseResponse
logger = logging.getLogger(__name__)

tallyman_route = Blueprint('tallyman', __name__)

@tallyman_route.route('/add_man', methods=['GET', 'POST'])
def add_man():  # 添加补货员账号
    json_data = request.get_json()
    user_name = json_data['name']
    phone = json_data['phone']
    password = json_data['password']
    comment = json_data['comment'] if 'comment' in json_data else None
    # 是否存在手机号码
    tallyman = TallymanAccount.query.filter_by(phone=phone).first()
    if tallyman:
        if tallyman.status != -1:
            return jsonify(TALLYMAN_ACCOUNT_EXIST)
    else:
        tallyman = TallymanAccount()
    tallyman.user_no = "todo"
    tallyman.level =1
    tallyman.user_name = user_name
    tallyman.phone = phone
    tallyman.status = 1
    tallyman.comment = comment
    tallyman.created_at = datetime.datetime.now()
    tallyman.updated_at = datetime.datetime.now()
    if password:
        tallyman.password = password
    db.session.add(tallyman)
    db.session.commit()
    tallyman.user_no = "SK" + str(tallyman.id).zfill(6)
    db.session.add(tallyman)
    db.session.commit()
    return BaseResponse(date={"success": True})

# 删除补货员
@tallyman_route.route('/del_man', methods=['GET', 'POST'])
def del_man():
    json_date = request.get_json()
    tallyman_id = json_date["tallyman_id"]
    tall_result = TallymanAccount.query.filter_by(id=tallyman_id).first()
    if not tall_result:
        return TALLYMAN_ACCOUNT_NOT_EXIST
    tall_result.status = -1
    db.session.add(tall_result)
    db.session.commit()
    return BaseResponse(date={"success": True})

# 补货员list
@tallyman_route.route("/query_man",methods=['POST'])
def tallyman():
    json_date = request.get_json()
    tallyman = json_date['tallyman']
    page = json_date["page"]
    page_size = json_date["page_size"]
    tallyman_result = TallymanAccount.query.filter(TallymanAccount.user_name.like("%"+tallyman+"%"), TallymanAccount.status ==1).offset\
        ((page-1)*page_size).limit(page_size)
    result_date = []
    for i in tallyman_result:
        query1 = "SELECT b.place_name,a.user_id,b.id as 'place_id' FROM tallyman_place as a JOIN place as b ON" \
                 " a.place_id = b.id  where user_id= {} ".format(i.id)
        man_place_res = db.session.execute(query1).fetchone()
        date={
            "tallyman_id": i.id,
            "user_no": i.user_no,
            "user_name": i.user_name,
            "level": i.level,
            "phone": i.phone,
            "status": i.status,
            "last_login": i.last_login,
            "address_id":man_place_res[2],
            "address_name":man_place_res[0]

        }
        result_date.append(date)
    return BaseResponse(date=result_date)

# 编辑补货员信息
@tallyman_route.route("/edit_man",methods=["POST"])
def edit_man():
    json_date = request.get_json()
    tallyman_id = json_date["tallyman_id"]
    phone = json_date["phone"]
    t_name = json_date["t_name"]
    level = json_date["level"]
    machine_place_id = json_date["machine_place_id"]
    man_result = TallymanAccount.query.filter_by(id=tallyman_id).first()
    if not man_result:
        return TALLYMAN_ACCOUNT_NOT_EXIST
    phone_not = TallymanAccount.query.filter_by(phone=phone, status=1).first()
    if phone_not:
        return USER_ALREADY_REGISTER_ERROR
    man_result.phone = phone
    man_result.user_name = t_name
    man_result.level = level
    db.session.add(man_result)
    machine_place_res = TallymanPlace.query.filter_by(user_id=tallyman_id).first()
    if not machine_place_res:
        return TALLYMAN_ACCOUNT_NOT_EXIST
    machine_place_res.place_id = machine_place_id
    db.session.add(machine_place_res)
    db.session.commit()
    return BaseResponse(date={"success": True})

# 为补货员添加机器