# -*- coding: utf-8 -*-
import smtplib
from email.header import Header
from email.mime.text import MIMEText
from email.utils import formataddr

from config.commen_config import EMAIL_CONFIG


class EmailService:
    def __init__(self):
        self.from_addr = EMAIL_CONFIG['KEFU_EMAIL']
        self.password = EMAIL_CONFIG['PASSWORD']
        self.smtp_server = EMAIL_CONFIG['SMTP_SERVER']

    def send_email(self, to_addr, rent, fp_dm, fp_hm, pdf_url):
        content = '''
            <html><body><b>尊敬的用户您好：</b> <br><p>感谢您使用灰晓兔！</p> 
            <p>灰晓兔已经为您开具订单{rent}的电子普通发票，发票数量共计1张，如下：</p>
            <p>发票代码：{fp_dm}，发票号码：{fp_hm}，您可以点击“<a href="{pdf_url}">电子普通发票下载</a>”获取该发票文件；</p>
            <p>电子普通发票是税务机关人口的有效收付款凭证，与纸质发票具有同等法律效力，可用于报销入账等。</p>
            <p>如果您有任何疑问或建议，请联系18068402080。</p>
        '''.format(rent=rent, fp_dm=fp_dm, fp_hm=fp_hm, pdf_url=pdf_url)
        msg = MIMEText(content, 'html', 'utf-8')
        lam_format_addr = lambda name, addr: formataddr((Header(name, 'utf-8').encode(), addr))

        msg['From'] = lam_format_addr(EMAIL_CONFIG['KEFU_NAME'], self.from_addr)
        msg['To'] = lam_format_addr(to_addr, to_addr)

        msg['Subject'] = Header(EMAIL_CONFIG['SUBJECT'], 'utf-8').encode()

        server = smtplib.SMTP_SSL(self.smtp_server, 465)

        server.login(self.from_addr, self.password)

        server.sendmail(self.from_addr, [to_addr], msg.as_string())

        server.quit()
