# -*- coding: utf-8 -*-
import base64
import datetime
import hashlib
import random
import string

from flask import g

from config.commen_config import ACCOUNT_STATUS
from models.models import AdminAccount, Business, AdminBusiness
from models.base_model import db


class AdminService(object):

    @staticmethod
    def get_business_id_list():
        """

        :param business_ids:
        :return:
        """

        if g.user.level == 1:
            business_list = Business.query.filter().all()
            if business_list:
                business_id_list = [i.id for i in business_list]
            else:
                business_id_list = []

        else:
            admin_business_list = AdminBusiness.query.filter_by(user_id=g.user.id, status=1).all()
            if admin_business_list:
                business_id_list = [i.business_id for i in admin_business_list]
            else:
                business_id_list = []

        return business_id_list

    @staticmethod
    def add_or_edit_admin_business(admin_account, business_ids):
        """

        :param business_ids:
        :return:
        """
        my_business_id_list = AdminService.get_business_id_list()
        right_busines_ids = list(set(business_ids).intersection(set(my_business_id_list)))

        insert_sql = " insert into admin_business (user_id, user_no, business_id) values "
        for i in right_busines_ids:
            insert_sql += "('{}','{}','{}'),".format(admin_account.id, admin_account.user_no, i)
        insert_sql = insert_sql[:-1]
        insert_sql += "  ON DUPLICATE KEY UPDATE status = 1"
        db.session.execute(insert_sql)
        db.session.commit()

    @staticmethod
    def get_admin_account_list(user_id=None, phone=None, keyword=None, page=None, page_size=None):
        """

        :return:
        """
        select_sql = """select admin_account.user_name, admin_account.phone, admin_account.level, admin_account.status,
                            admin_account.comment,admin_account.parent_id,admin_account.rate, admin_account.created_at, 
                            admin_account.updated_at,admin_account.id, admin_account.user_no
                            """
        count_sql = "select count(admin_account.id) as total_count"

        from_sql = " from admin_account "
        if g.user.level == 1:
            where_sql = " where 0=0 "
        else:
            where_sql = """
                    where 
                        admin_account.id in (
                                select user_id from admin_business where business_id in (
                                    select business_id from admin_business where user_id = {user_id} and status = 1
                                )
                            )
                        and admin_account.level > {level} 
                """.format(user_id=g.user.id, level=g.user.level)

        if user_id:
            where_sql += " and admin_account.id = '{id}'".format(id=user_id)
        if phone:
            where_sql += " and phone = '{phone}'".format(phone=phone)

        if keyword:
            where_sql += """
                        and CONCAT( admin_account.user_name,
                                    admin_account.phone, 
                                    admin_account.user_no) LIKE '%{keyword}%'
                        """.format(keyword=keyword)

        order_sql = "  ORDER BY admin_account.id ASC, admin_account.status ASC"
        if page and page_size:
            limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)
        else:
            limit_sql = " "
        count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

        if not count_result:
            return {"list": [], "page": page, "pageSize": page_size, "total_count": 0}
        else:
            total_count = count_result.total_count

        result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

        return_data = []
        for info in result:
            return_data.append(
                {"user_name": info.user_name, "phone": info.phone, "level": info.level, "status": info.status,
                 "comment": info.comment, "id": info.id, "user_no": info.user_no,
                 "create_time": info.created_at.strftime("%Y-%m-%d %H:%M:%S"),
                 "update_time": info.updated_at.strftime("%Y-%m-%d %H:%M:%S"),
                 })
        return {"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count}

    @staticmethod
    def get_tallyman_account_list(user_id=None, phone=None, keyword=None, page=None, page_size=None):
        """

        :return:
        """
        select_sql = """select  tallyman_account.user_name, tallyman_account.phone, tallyman_account.level, 
                                tallyman_account.status,tallyman_account.created_at, tallyman_account.updated_at,
                                tallyman_account.id, tallyman_account.user_no, tallyman_account.comment,
                                tallyman_account.business_id
                                """
        count_sql = "select count(tallyman_account.id) as total_count"

        from_sql = " from tallyman_account "
        if g.user.level == 1:
            where_sql = " where 0=0 "
        else:
            where_sql = """
                        where 
                            tallyman_account.business_id in (
                                    select business_id from admin_business where user_id = {user_id} and status = 1
                                )
                    """.format(user_id=g.user.id)

        if user_id:
            where_sql += " and tallyman_account.id = '{id}'".format(id=user_id)
        if phone:
            where_sql += " and phone = '{phone}'".format(phone=phone)

        if keyword:
            where_sql += """
                            and CONCAT( tallyman_account.user_name,
                                        tallyman_account.phone) LIKE '%{keyword}%'
                            """.format(keyword=keyword)

        order_sql = "  ORDER BY tallyman_account.id ASC, tallyman_account.status ASC"
        if page and page_size:
            limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)
        else:
            limit_sql = " "
        count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

        if not count_result:
            return {"list": [], "page": page, "pageSize": page_size, "total_count": 0}
        else:
            total_count = count_result.total_count
        print(select_sql + from_sql + where_sql + order_sql + limit_sql)
        result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

        return_data = []
        for info in result:
            return_data.append(
                {"user_name": info.user_name, "phone": info.phone, "level": info.level, "status": info.status,
                 "comment": info.comment, "id": info.id, "user_no": info.user_no, "business_id": info.business_id,
                 "create_time": info.created_at.strftime("%Y-%m-%d %H:%M:%S"),
                 "update_time": info.updated_at.strftime("%Y-%m-%d %H:%M:%S"),
                 })
        return {"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count}
