#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/12
@file: place_portal.py
@function:
@modify:
"""
import datetime
import logging
import random
import time

from flask import Blueprint, g, request, jsonify
from sqlalchemy.exc import SQLAlchemyError

from config.commen_config import RENT_SALE_LOCK
from config.wechat_config import platform_appid_config_list, pay_config_list
from models.base_model import db
from models.models import Rent, RentDetail, WxUser, Machine, RentRefund, DrawRecord, AdminAccount, AdminOpenid, \
    DrawDetail
from service.rent_service import RentService
from service.wechat_service import WeChatPayService
from utils.error_code import OPERATE_LEVEL_ERROR, ACTION_CODE_ERROR, REFUND_NOT_PRODUCTION_INFO, Param_Invalid_Error, \
    REFUND_MONEY_IS_ZERO, REFUND_MONEY_ERROR, REFUND_LOCK_ERROR, NO_DRAW_RECORD_ERROR, ACCOUNT_NOT_EXISTS_ERROR, \
    ADMIN_OPENID_NOT_EXIST_ERROR
from utils.my_redis_cache import redis_client
from utils.my_response import BaseResponse

logger = logging.getLogger(__name__)

rent_route = Blueprint('rent', __name__)


@rent_route.route("rent_list", methods=["POST"])
def run_rent_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    keyword = json_data.get("keyword", None)
    start_date = json_data.get("startDate", None)
    end_date = json_data.get("endDate", None)
    business_id = json_data.get("business_id", None)
    is_pay = json_data.get("is_pay", None)

    if g.user.level not in (1, 2, 4, 5):
        return jsonify(OPERATE_LEVEL_ERROR)
    select_sql = """
                    SELECT  rent.rent_no, rent.machine_no, rent.user_id,rent.place_id,rent.is_pay,
                        rent_detail.hatch_no, rent_detail.production_id,rent_detail.production_name,
                         rent_detail.status,rent_detail.brand_name, 
                        rent_detail.production_type_name,rent_detail.total,rent_detail.rent_count,
                        rent_detail.refund_total,rent_detail.refund_count, wx_user.phone,place.place_name,
                        rent_detail.id as rent_detail_id, rent.business_id, rent.created_at,rent.pay_time
                    """
    count_sql = " select count(rent.id) as total_count "

    from_sql = """
                    FROM
                        rent
                            LEFT JOIN
                        rent_detail ON rent.rent_no = rent_detail.rent_no
                            LEFT JOIN
                        place ON rent.place_id = place.id
                            LEFT JOIN
                        wx_user ON rent.user_id = wx_user.id
                    """

    where_sql = " WHERE 0=0 "
    if keyword is not None:
        where_sql += """
                        and CONCAT(rent.rent_no,
                                    rent.machine_no,
                                    wx_user.phone) LIKE '%{keyword}%'
                    """.format(keyword=keyword)

    if start_date is not None:
        where_sql += " and rent.created_at > '{}'".format(start_date)
    if end_date is not None:
        where_sql += " and rent.created_at <= '{}'".format(end_date)

    if is_pay is not None:
        where_sql += " and rent.is_pay = '{}'".format(is_pay)

    if business_id is not None:
        where_sql += " and rent.business_id = '{}'".format(business_id)

    if g.user.level != 1:
        where_sql += """ and rent.business_id in ( 
                                    select business_id from admin_business where user_id = '{}' and status = 1)
                     """.format(g.user.id)

    order_sql = " ORDER BY rent.created_at DESC, rent_detail.created_at desc"
    limit_sql = " LIMIT {offset} , {page_size}".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    if result:
        for info in result:
            tmp = {
                "rent_no": info.rent_no, "machine_no": info.machine_no, "user_id": info.user_id,
                "phone": info.phone, "rent_detail_id": info.rent_detail_id, "place_name": info.place_name,
                "place_id": info.place_id, "is_pay": info.is_pay, "total": info.total, "rent_count": info.rent_count,
                "refund_total": info.refund_total, "refund_count": info.refund_count, "business_id": info.business_id,
                "production_name": info.production_name, "production_id": info.production_id,
                "status": info.status, "create_time": info.created_at.strftime("%Y-%m-%d %H:%M:%S"),
                "pay_time": info.pay_time.strftime("%Y-%m-%d %H:%M:%S"),
            }
            return_data.append(tmp)

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@rent_route.route("rent_detail", methods=["POST"])
def get_rent_detail():
    """

    :return:
    """
    json_data = request.get_json()
    rent_no = json_data.get("rent_no", None)
    rent_detail_id = json_data.get("rent_detail_id", None)
    if g.user.level not in (1, 2, 4, 5):
        return jsonify(OPERATE_LEVEL_ERROR)

    select_sql = """
                        SELECT rent.id, rent.rent_no, rent.machine_no, rent.user_id,rent.place_id,rent.is_pay,
                            rent_detail.hatch_no, rent_detail.production_name,rent_detail.title, rent_detail.brand_id,
                            rent_detail.production_type_id, rent_detail.price,rent_detail.original_price,
                            rent_detail.weight, rent_detail.weight_unit, rent_detail.expiration_date, 
                            rent_detail.expiration_date_unit, rent_detail.is_expiration_date,rent_detail.business_id,
                            rent_detail.weight_error, rent_detail.img, rent_detail.tags, rent_detail.content,
                            rent_detail.summary, rent_detail.status,rent_detail.brand_name, 
                            rent_detail.production_type_name,rent_detail.total,rent_detail.rent_count,
                            rent_detail.refund_total,rent_detail.refund_count, wx_user.phone,place.place_name,
                            rent_detail.production_id,rent.business_id, rent.created_at,rent.pay_time,
                            rent_detail.id as rent_detail_id
                        """
    from_sql = """
                        FROM
                            rent
                                LEFT JOIN
                            rent_detail ON rent.rent_no = rent_detail.rent_no
                                LEFT JOIN
                            place ON rent.place_id = place.id
                                LEFT JOIN
                            wx_user ON rent.user_id = wx_user.id
                        """

    where_sql = " where rent.rent_no = '{}'".format(rent_no)
    if rent_detail_id is not None:
        where_sql += " and rent_detail.id = '{}'".format(rent_detail_id)
    if g.user.level != 1:
        where_sql += """ and rent.business_id in ( 
                                    select business_id from admin_business where user_id = '{}' and status = 1)
                     """.format(g.user.id)

    result = db.session.execute(select_sql + from_sql + where_sql).fetchone()

    if result:

        return_data = {
            "rent_detail_id": result.rent_detail_id, "rent_no": result.rent_no, "machine_no": result.machine_no,
            "user_id": result.user_id,
            "phone": result.phone, "place_name": result.place_name,
            "place_id": result.id, "is_pay": result.is_pay, "total": result.total, "rent_count": result.rent_count,
            "refund_total": result.refund_total, "refund_count": result.refund_count, "business_id": result.business_id,
            "production_name": result.production_name, "production_id": result.production_id,
            "title": result.title, "brand_id": result.brand_id, "brand_name": result.brand_name,
            "production_type_id": result.production_type_id, "production_type_name": result.production_type_name,
            "price": result.price, "original_price": result.original_price, "weight": result.weight,
            "weight_unit": result.weight_unit,
            "expiration_date": result.expiration_date, "expiration_date_unit": result.expiration_date_unit,
            "is_expiration_date": result.is_expiration_date,
            "weight_error": result.weight_error,
            "img": result.img, "tags": result.tags, "content": result.content,
            "summary": result.summary, "status": result.status,
            "create_time": result.created_at.strftime("%Y-%m-%d %H:%M:%S"),
            "pay_time": result.pay_time.strftime("%Y-%m-%d %H:%M:%S"),
        }
        return BaseResponse({"data": return_data})

    else:
        return BaseResponse()


@rent_route.route('/rent_money_refund', methods=['GET', 'POST'])
def rent_money_refund_new():
    if g.user.level not in (1, 2, 4, 5):
        return jsonify(OPERATE_LEVEL_ERROR)

    json_data = request.get_json()
    action_pwd = json_data['action_pwd'] if 'action_pwd' in json_data else ''
    rent_no = json_data['rent_no']
    rent_detail_id = json_data['rent_detail_id']
    if action_pwd != "xxzn666":
        return BaseResponse(**ACTION_CODE_ERROR)

    cause = json_data['cause']
    comment = json_data['comment'] if 'comment' in json_data else ''

    lock_res = redis_client.set(RENT_SALE_LOCK + str(rent_no) + "_" + str(rent_detail_id),
                                datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S"), ex=60,
                                nx=True)
    if lock_res:
        pass
    else:
        return jsonify(REFUND_LOCK_ERROR)

    rent = Rent.query.filter_by(rent_no=rent_no).with_for_update().first()
    if not rent:
        return jsonify(REFUND_NOT_PRODUCTION_INFO)
    rent_detail = RentDetail.query.filter_by(rent_no=rent_no, id=rent_detail_id).with_for_update().first()
    if not rent_detail:
        return jsonify(REFUND_NOT_PRODUCTION_INFO)
    wx_user = WxUser.query.filter_by(id=rent.user_id).first()

    refund_count = int(json_data["refund_count"])
    refund_money = refund_count * rent_detail.price

    if refund_money <= 0:
        return jsonify(REFUND_MONEY_IS_ZERO)
    if refund_money > rent_detail.total:  # 不能超出金额退款
        return jsonify(REFUND_MONEY_ERROR)
    new_total = rent_detail.total - refund_money

    # 重新计算订单对应所有讲解器总收入，退款金额
    rent_total = 0
    rent_details = RentDetail.query.filter_by(rent_no=rent.rent_no).all()
    for tmp in rent_details:
        if tmp.id == rent_detail.id:
            rent_total += new_total
        else:
            rent_total += tmp.total

    # 退款操作
    data = {
        "out_refund_no": RentService.create_refund_no(),
        "out_trade_no": rent_no,
        "total_fee": rent.total,
        "refund_fee": refund_money
    }

    result = WeChatPayService(app_id=platform_appid_config_list[wx_user.platform],
                              config_name=pay_config_list[rent.mch_platform]).do_refund(data)
    if result:
        try:
            rent_refund = RentRefund()
            rent_refund.user_id = g.user.id
            rent_refund.refund_no = data["out_refund_no"]
            rent_refund.rent_no = rent.rent_no
            rent_refund.rent_detail_id = rent_detail.id
            rent_refund.total = refund_money
            rent_refund.comment = comment
            rent_refund.cause = cause

            rent.real_total = rent_total
            rent.back_money += refund_money

            rent_detail.total = new_total
            rent_detail.refund_count += refund_count
            rent_detail.refund_total += refund_money

            db.session.add(rent_refund)
            db.session.add(rent)
            db.session.add(rent_detail)
            db.session.commit()
        except SQLAlchemyError as e:
            db.session.rollback()
            logger.info(e)
            raise e
        return BaseResponse()
    else:
        return BaseResponse(error_code=-1, error_message='refund failed')


@rent_route.route("month_bill", methods=["POST"])
def run_month_bill():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    start_date = json_data.get("startDate", None)
    end_date = json_data.get("endDate", None)
    business_id = json_data.get("business_id", None)
    is_pay = json_data.get("is_pay", None)

    select_sql = """
                    select sum(rent.real_total) as total, rent.business_id,DATE_FORMAT(rent.created_at,"%Y-%m") as rent_month,
                    admin_business.rate as rate, business.business_name as business_name
                    """
    count_sql = " select count(1) as total_count  from ("

    from_sql = """
                    FROM
                        rent
                    left join admin_business on admin_business.business_id = rent.business_id
                    left join business on business.id = rent.business_id  
                    """

    now = datetime.datetime.now().date()
    this_month_start = datetime.datetime(now.year, now.month, 1)
    where_sql = " WHERE 0=0  and rent.created_at < '{}'".format(this_month_start.strftime("%Y-%m-%d %H:%M:%S"))

    if start_date is not None:
        where_sql += " and rent.created_at > '{}'".format(start_date)
    if end_date is not None:
        where_sql += " and rent.created_at <= '{}'".format(end_date)

    if is_pay is not None:
        where_sql += " and rent.is_pay = '{}'".format(is_pay)

    if business_id is not None:
        where_sql += " and rent.business_id = '{}'".format(business_id)

    where_sql += """ and  admin_business.user_id = '{}' and  admin_business.status = 1  and admin_business.rate > 0
                 """.format(g.user.id)
    group_sql = """ group by DATE_FORMAT(rent.created_at,"%Y-%m") , rent.business_id """
    order_sql = " ORDER BY rent.created_at DESC, rent.created_at desc"
    limit_sql = " LIMIT {offset} , {page_size}".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + select_sql + from_sql + where_sql + group_sql + ") as ttb").fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + group_sql + order_sql + limit_sql).fetchall()

    return_data = []
    if result:
        for info in result:
            tmp = {
                "total": info.total, "business_id": info.business_id, "rent_month": info.rent_month,
                "rate": info.rate, "business_name": info.business_name
            }
            return_data.append(tmp)

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@rent_route.route("day_bill", methods=["POST"])
def run_day_bill():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    start_date = json_data.get("startDate", None)
    end_date = json_data.get("endDate", None)

    now = datetime.datetime.now().date()
    select_sql = """ select SUM(tab1.real_total) AS real_total, tab1.bill_date, ifnull(draw_record.status,-2) as draw_status,
                    ifnull(draw_record.real_total,0) as drawed_total """
    count_sql = " select count(1)  as total_count"
    from_sql = """
            FROM
                (SELECT 
                    SUM(total * rate/100) AS real_total,
                        rent.business_id,
                        DATE_FORMAT(rent.created_at, '%Y-%m-%d') AS bill_date,
                        admin_business.rate AS rate,
                        business.business_name AS business_name
                FROM
                    rent
                LEFT JOIN admin_business ON admin_business.business_id = rent.business_id
                LEFT JOIN business ON business.id = rent.business_id
                WHERE
                    0 = 0
                        AND rent.created_at < '{}'
                        AND admin_business.user_id = '{}'
                        AND admin_business.status = 1
                        AND admin_business.rate > 0
                GROUP BY DATE_FORMAT(rent.created_at, '%Y-%m-%d') , rent.business_id) AS tab1
    """.format(now.strftime("%Y-%m-%d %H:%M:%S"), g.user.id)
    where_sql = """
            left join draw_record on draw_record.bill_date = tab1.bill_date and draw_record.status != -1
            where tab1.real_total > '0' 
    """
    if start_date is not None:
        where_sql += " and tab1.bill_date >= '{}'".format(start_date)
    if end_date is not None:
        where_sql += " and tab1.bill_date <= '{}'".format(end_date)

    group_sql = """group by tab1.bill_date """
    order_sql = " ORDER BY  tab1.bill_date DESC "
    limit_sql = " LIMIT {offset} , {page_size}".format(offset=(page - 1) * page_size, page_size=page_size)
    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + group_sql + order_sql + limit_sql).fetchall()

    return_data = []
    if result:
        for info in result:
            tmp = {
                "real_total": int(info.real_total), "bill_date": info.bill_date, "total": float(info.real_total),
                "draw_status": info.draw_status,
                "drawed_total": info.drawed_total,
            }
            return_data.append(tmp)

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@rent_route.route("day_bill_detail", methods=["POST"])
def run_day_bill_detail():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    business_id = json_data.get("business_id", None)
    bill_date = json_data["bill_date"]

    select_sql = """
                    select sum(rent.real_total) as total, rent.business_id,
                    DATE_FORMAT(rent.created_at,"%Y-%m-%d") as bill_date,
                    admin_business.rate as rate, business.business_name as business_name
                    """
    count_sql = " select count(1) as total_count  from ("

    from_sql = """
                    FROM
                        rent
                    left join admin_business on admin_business.business_id = rent.business_id
                    left join business on business.id = rent.business_id  
                    """

    where_sql = """ WHERE 0=0  and DATE_FORMAT(rent.created_at,"%Y-%m-%d") = '{}'""".format(bill_date)

    if business_id is not None:
        where_sql += " and rent.business_id = '{}'".format(business_id)

    where_sql += """ and  admin_business.user_id = '{}' and  admin_business.status = 1  and admin_business.rate > 0
                 """.format(g.user.id)
    group_sql = """ group by DATE_FORMAT(rent.created_at,"%Y-%m-%d") , rent.business_id """
    order_sql = " ORDER BY rent.created_at DESC"
    limit_sql = " LIMIT {offset} , {page_size}".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + select_sql + from_sql + where_sql + group_sql + ") as ttb").fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + group_sql + order_sql + limit_sql).fetchall()

    return_data = []
    if result:
        for info in result:
            tmp = {
                "total": int(info.total), "business_id": info.business_id, "bill_date": info.bill_date,
                "rate": info.rate, "business_name": info.business_name,
            }
            return_data.append(tmp)

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@rent_route.route("apply_draw", methods=["POST"])
def run_apply_draw():
    """

    :return:
    """
    json_data = request.get_json()
    draw_data = json_data["draw_data"]

    for data in draw_data:
        bill_date = datetime.datetime.strptime(data["bill_date"], "%Y-%m-%d").strftime("%Y-%m-%d")
        sql = """
            SELECT 
                sum(real_total) as real_total, bill_date
            FROM
                (SELECT 
                   SUM(total * rate / 100) AS real_total,
            
                        rent.business_id,
                        DATE_FORMAT(rent.created_at, '%Y-%m-%d') AS bill_date,
                        admin_business.rate AS rate,
                        business.business_name AS business_name
                FROM
                    rent
                LEFT JOIN admin_business ON admin_business.business_id = rent.business_id
                LEFT JOIN business ON business.id = rent.business_id
                WHERE
                    0 = 0
                        AND rent.created_at < '{}'
                        AND admin_business.user_id = '{}'
                        AND admin_business.status = 1
                        AND admin_business.rate > 0
                GROUP BY DATE_FORMAT(rent.created_at, '%Y-%m-%d') , rent.business_id) AS tab1
            WHERE
                real_total > '0'
                and bill_date = '{}'
        """.format(datetime.datetime.now().date().strftime("%Y-%m-%d %H:%M:%S"), g.user.id, bill_date)

        result = db.session.execute(sql).fetchone()
        if result:
            tmp = DrawRecord.query.filter_by(user_id=g.user.id, bill_date=result["bill_date"]).first()
            if tmp:
                continue
            model = DrawRecord()
            model.user_id = g.user.id
            model.user_no = g.user.user_no
            model.bill_date = result["bill_date"]
            model.real_total = int(result["real_total"])
            model.status = 0
            model.draw_no = RentService.create_order_no(prefix="DR")
            db.session.add(model)
            db.session.commit()

    return BaseResponse()


@rent_route.route("draw_list", methods=["POST"])
def run_draw_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    start_date = json_data.get("startDate", None)
    end_date = json_data.get("endDate", None)
    business_id = json_data.get("business_id", None)
    status = json_data.get("status", None)

    if g.user.level != 1:
        return jsonify(OPERATE_LEVEL_ERROR)

    select_sql = """
                    select draw_record.draw_no,
                    draw_record.bill_date,
                    draw_record.real_total,
                    draw_record.status,
                    draw_record.draw_time,
                    draw_record.created_at,
                    draw_record.updated_at,
                    draw_record.id,
                    draw_record.user_id,
                    draw_record.user_no,
                    admin_account.user_name
                    
                    """
    count_sql = " select count(draw_record.id) as total_count "

    from_sql = """
                    FROM
                        draw_record
                    left join admin_account on admin_account.id = draw_record.user_id
                    """

    where_sql = " WHERE draw_record.status <> '-1' "

    if start_date is not None:
        where_sql += " and draw_record.bill_date > '{}'".format(start_date)
    if end_date is not None:
        where_sql += " and draw_record.bill_date <= '{}'".format(end_date)

    if status is not None:
        where_sql += " and draw_record.status = '{}'".format(status)

    if business_id is not None:
        where_sql += " and draw_record.business_id = '{}'".format(business_id)

    order_sql = " ORDER BY draw_record.created_at DESC, draw_record.status asc"
    limit_sql = " LIMIT {offset} , {page_size}".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count

    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    if result:
        for info in result:
            tmp = {
                "bill_date": info.bill_date,
                "real_total": info.real_total, "status": info.status,
                "id": info.id,
                "user_id": info.user_id,
                "user_no": info.user_no,
                "user_name": info.user_name,
                "create_time": info.created_at.strftime("%Y-%m-%d %H:%M:%S"),
                "draw_time": info.draw_time.strftime("%Y-%m-%d %H:%M:%S") if info.draw_time else "",
            }
            return_data.append(tmp)

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@rent_route.route("approve_draw", methods=["POST"])
def run_approve_draw():
    """

    :return:
    """
    json_data = request.get_json()
    draw_id = json_data["draw_id"]

    if g.user.level != 1:
        return jsonify(OPERATE_LEVEL_ERROR)

    draw_record = DrawRecord.query.filter_by(id=draw_id, status=0).first()
    if not draw_record:
        return jsonify(NO_DRAW_RECORD_ERROR)

    admin_account = AdminAccount.query.filter_by(id=draw_record.user_id, status=1).first()
    if not admin_account:
        return jsonify(ACCOUNT_NOT_EXISTS_ERROR)
    admin_openid = AdminOpenid.query.filter_by(user_id=admin_account.id, status=1).all()
    if not admin_openid:
        return jsonify(ADMIN_OPENID_NOT_EXIST_ERROR)
    openid_list = [{"openid": x.openid, "real_name": x.real_name} for x in admin_openid]

    draw_money = int(draw_record.real_total / len(openid_list))
    draw_money_list = [draw_money for i in range(len(openid_list) - 1)]
    draw_money_list.append(draw_record.real_total - draw_money * (len(openid_list) - 1))
    random.shuffle(draw_money_list)
    return_data = []
    for i in range(len(openid_list)):
        draw_money = draw_money_list[i]
        open_id = openid_list[i]["openid"]
        real_name = openid_list[i]["real_name"]

        data = {
            "user_id": open_id,
            "amount": draw_money,
            "out_trade_no": RentService.create_order_no(prefix="DR"),
            "desc": draw_record.bill_date + "个人提现",
            "real_name": real_name
        }
        result = WeChatPayService(app_id=platform_appid_config_list[2],
                                  config_name=pay_config_list[1]).do_transfer(data)
        if result:
            draw_record.status = 1
            draw_record.check_admin_id = g.user.id
            draw_record.draw_time = datetime.datetime.now()
            db.session.add(draw_record)
            db.session.commit()

            dd = DrawDetail()
            dd.draw_id = draw_record.id
            dd.open_id = open_id
            dd.draw_no = result["partner_trade_no"]
            dd.payment_no = result["payment_no"]
            dd.payment_time = result["payment_time"]
            dd.bill_date = draw_record.bill_date
            dd.total = draw_record.real_total
            dd.real_total = draw_money
            dd.status = 1
            db.session.add(dd)
            db.session.commit()

            return_data.append({"id": dd.id,
                                "draw_id": dd.draw_id,
                                "open_id": dd.open_id,
                                "draw_no": dd.draw_no,
                                "payment_no": dd.payment_no,
                                "bill_date": dd.bill_date,
                                "total": dd.total,
                                "real_total": dd.real_total,
                                "payment_time": dd.payment_time.strftime("%Y-%m-%d %H:%M:%S"),
                                "status": dd.status,
                                })

    return BaseResponse(data={"list": return_data})


@rent_route.route("draw_detail", methods=["POST"])
def run_draw_detail():
    """

    :return:
    """
    json_data = request.get_json()
    draw_id = json_data["draw_id"]

    return_data = []
    draw_detail = DrawDetail.query.filter_by(draw_id=draw_id, status=1).all()
    for i in draw_detail:
        return_data.append({"id": i.id,
                            "draw_id": i.draw_id,
                            "open_id": i.open_id,
                            "draw_no": i.draw_no,
                            "payment_no": i.payment_no,
                            "bill_date": i.bill_date,
                            "total": i.total,
                            "real_total": i.real_total,
                            "payment_time": i.payment_time.strftime("%Y-%m-%d %H:%M:%S"),
                            "status": i.status,
                            })
    return BaseResponse(data={"list": return_data})


@rent_route.route("all_draw_money", methods=["POST"])
def run_all_draw_money():
    """

    :return:
    """

    sql = """
            select ifnull(sum(real_total),0) as real_total from (SELECT 
                SUM(tab1.real_total) AS real_total,
                tab1.bill_date,
                IFNULL(draw_record.status, - 2) as status,
                IFNULL(draw_record.real_total, 0) AS drawed_total
            FROM
                (SELECT 
                    SUM(total * rate / 100) AS real_total,
                        rent.business_id,
                        DATE_FORMAT(rent.created_at, '%Y-%m-%d') AS bill_date,
                        admin_business.rate AS rate,
                        business.business_name AS business_name
                FROM
                    rent
                LEFT JOIN admin_business ON admin_business.business_id = rent.business_id
                LEFT JOIN business ON business.id = rent.business_id
                WHERE
                    0 = 0
                        AND rent.created_at < '{}'
                        AND admin_business.user_id = '{}'
                        AND admin_business.status = 1
                        AND admin_business.rate > 0
                GROUP BY DATE_FORMAT(rent.created_at, '%Y-%m-%d') , rent.business_id) AS tab1
                    LEFT JOIN
                draw_record ON draw_record.bill_date = tab1.bill_date
                    AND draw_record.status != - 1
            WHERE
                tab1.real_total > '0'
            GROUP BY tab1.bill_date) as tab2
            where tab2.status = -2
    """.format(datetime.datetime.now().date().strftime("%Y-%m-%d %H:%M:%S"), g.user.id)

    result = int(db.session.execute(sql).fetchone()["real_total"])
    return BaseResponse(data={"all_draw_money": result})
