#!usr/bin/env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2022/01/12
@file: machine_portal.py
@function:
@modify:
"""
import logging

from flask import Blueprint, g, request, jsonify

from config.commen_config import DISCOUNTS_TYPES
from models.base_model import db
from models.models import AdminMachine, Machine, AdminAccount, AdminBusiness, TallymanMachine
from service.admin_service import AdminService
from utils.error_code import MACHINE_NOT_EXIST_ERROR, ACCOUNT_NOT_EXISTS_ERROR, ADMIN_BUSINESS_NOT_EXIST
from utils.my_response import BaseResponse
from utils.mytools import json2obj

logger = logging.getLogger(__name__)

machine_route = Blueprint('machine', __name__)


@machine_route.route("machine_list", methods=["POST"])
def run_machine_list():
    """

    :return:
    """
    json_data = request.get_json()
    page = json_data.get("page", 1)
    page_size = json_data.get("pageSize", 10)
    keyword = json_data.get("keyword", None)

    admin = g.user
    select_sql = """select machine.id, machine.machine_no, machine.device_id, machine.qrcode_no,machine.status,
                        machine.mac, machine.power, machine.hatch_number, machine.type,machine.place_id, 
                        place.place_name, machine.discounts_id, machine.business_id,business.business_name
        """
    count_sql = "select count(machine.id) as total_count"
    from_sql = """ from machine  
                        left join place on machine.place_id = place.id
                        left join business on machine.business_id = business.id
                         
                         """
    if g.user.level == 1:
        where_sql = " where 0=0 "
    else:
        where_sql = """ where machine.machine_no in ( select machine_no from admin_machine where  
                        admin_machine.user_id = '{user_id}' and admin_machine.status = 1)""".format(user_id=admin.id)
    if keyword is not None:
        where_sql += """
                        and CONCAT(machine.machine_no,ifnull(machine.qrcode_no,'')) LIKE '%{keyword}%'

                            """.format(keyword=keyword)
    order_sql = "  ORDER BY machine.id ASC, machine.status ASC"
    limit_sql = " LIMIT {offset} , {page_size} ".format(offset=(page - 1) * page_size, page_size=page_size)

    count_result = db.session.execute(count_sql + from_sql + where_sql).fetchone()

    if not count_result:
        return BaseResponse(data={"list": [], "page": page, "pageSize": page_size, "total_count": 0})
    else:
        total_count = count_result.total_count
    result = db.session.execute(select_sql + from_sql + where_sql + order_sql + limit_sql).fetchall()

    return_data = []
    for info in result:
        return_data.append(
            {"machine_no": info.machine_no, "device_id": info.device_id, "place_name": info.place_name,
             "mac": info.mac, "power": info.power, "hatch_number": info.hatch_number, "type": info.type,
             "status": info.status, "place_id": info.place_id,
             "discounts_id": info.discounts_id,
             "discounts_name": DISCOUNTS_TYPES.get(int(info.discounts_id), "无此优惠"),
             "business_id": info.business_id, "business_name": info.business_name
             })

    return BaseResponse({"list": return_data, "page": page, "pageSize": page_size, "total_count": total_count})


@machine_route.route("add_machine", methods=["POST"])
def run_add_machine():
    """

    :return:
    """
    json_data = request.get_json()
    machine_no = json_data.get("machine_no", None)
    address = json_data.get("address", None)
    device_id = json_data.get("device_id", None)
    qrcode_no = json_data.get("qrcode_no", None)
    mac = json_data["mac"]
    power = json_data.get("power", None)
    hatch_number = json_data.get("hatch_number", None)
    place_id = json_data.get("place_id", None)
    type = json_data.get("type", 1)
    discounts_id = json_data.get("discounts_id", 0)
    status = int(json_data.get("status", 1))

    machine_model = Machine()
    machine_model.machine_no = machine_no
    machine_model.device_id = device_id
    machine_model.qrcode_no = qrcode_no
    machine_model.mac = mac
    machine_model.power = power
    machine_model.place_id = place_id
    machine_model.address = address
    machine_model.mch_platform = 1
    machine_model.hatch_number = hatch_number
    machine_model.type = type
    machine_model.discounts_id = discounts_id
    machine_model.status = status
    db.session.add(machine_model)

    admin_machine = AdminMachine()
    admin_machine.user_id = g.user.id
    admin_machine.user_no = g.user.user_no
    admin_machine.machine_no = machine_model.machine_no
    db.session.add(admin_machine)

    db.session.commit()
    return BaseResponse()


@machine_route.route("edit_machine", methods=["POST"])
def run_edit_machine():
    """

    :return:
    """
    json_data = request.get_json()
    machine_no = json_data["machine_no"]
    address = json_data.get("address", None)
    device_id = json_data.get("device_id", None)
    qrcode_no = json_data.get("qrcode_no", None)
    mac = json_data.get("mac", None)
    power = json_data.get("power", None)
    hatch_number = json_data.get("hatch_number", None)
    place_id = json_data.get("place_id", None)
    type = json_data.get("type", None)
    status = json_data.get("status", None)
    discounts_id = json_data.get("discounts_id", None)

    machine_model = Machine.query.filter_by(machine_no=machine_no).first()
    if not machine_model:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    if device_id is not None:
        machine_model.device_id = device_id
    if qrcode_no is not None:
        machine_model.qrcode_no = qrcode_no
    if mac is not None:
        machine_model.mac = mac
    if power is not None:
        machine_model.power = power
    if place_id is not None:
        machine_model.place_id = place_id
    if address is not None:
        machine_model.address = address
    if hatch_number is not None:
        machine_model.hatch_number = hatch_number
    if type is not None:
        machine_model.type = type
    if status is not None:
        machine_model.status = status
    if discounts_id is not None:
        machine_model.discounts_id = discounts_id
    db.session.add(machine_model)

    db.session.commit()
    return BaseResponse()


@machine_route.route("machine_detail", methods=["POST"])
def get_machine_detail():
    """

    :return:
    """
    json_data = request.get_json()
    machine_no = json_data["machine_no"]

    admin = g.user
    select_sql = """select machine.id, machine.machine_no, machine.device_id, machine.qrcode_no,machine.status,
                            machine.mac, machine.power, machine.hatch_number, machine.type,machine.place_id, 
                            place.place_name, machine.discounts_id,machine.business_id,business.business_name
            """
    from_sql = """ from machine  
                                left join place on machine.place_id = place.id
                                left join business on machine.business_id = business.id
                             """

    if g.user.level == 1:
        where_sql = " where 0=0 "
    else:
        where_sql = """ where machine.machine_no in ( select machine_no from admin_machine where  
                        admin_machine.user_id = '{user_id}' and admin_machine.status = 1)  """.format(user_id=admin.id)

    where_sql += " and machine.machine_no = '{}'".format(machine_no)

    result = db.session.execute(select_sql + from_sql + where_sql).fetchall()
    if not result or len(result) != 1:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    info = result[0]
    return BaseResponse(data={"machine_no": info.machine_no, "device_id": info.device_id, "place_name": info.place_name,
                              "mac": info.mac, "power": info.power, "hatch_number": info.hatch_number,
                              "type": info.type, "status": info.status, "place_id": info.place_id,
                              "discounts_id": info.discounts_id,
                              "discounts_name": DISCOUNTS_TYPES.get(int(info.discounts_id), "无此优惠"),
                              "business_id": info.business_id, "business_name": info.business_name
                              })


@machine_route.route("distribute_machine", methods=["POST"])
def run_distribute_machine():
    """

    :return:
    """
    json_data = request.get_json()
    machine_nos = json_data["machine_nos"]
    user_id = json_data["user_id"]
    business_id = json_data["business_id"]

    result = AdminService.get_admin_account_list(user_id=user_id)
    if result["total_count"] != 1:
        return jsonify(ACCOUNT_NOT_EXISTS_ERROR)
    admin_info = json2obj(result["list"][0])

    if g.user.level != 1:
        admin_business = AdminBusiness.query.filter_by(user_id=g.user.id, business_id=business_id, status=1).first()
        if not admin_business:
            return jsonify(ADMIN_BUSINESS_NOT_EXIST)

    return_machine_no = []
    for i in machine_nos:
        if g.user.level != 1:
            admin_machines = AdminMachine.query.filter_by(user_id=g.user.id, machine_no=i, status=1).first()
            if not admin_machines:
                continue
        machine = Machine.query.filter_by(machine_no=i).first()
        if not machine:
            continue
        insert_sql = " insert into admin_machine (user_id, user_no, machine_no) values "

        insert_sql += "('{}','{}','{}'),".format(admin_info.id, admin_info.user_no, i)
        insert_sql = insert_sql[:-1]
        insert_sql += "  ON DUPLICATE KEY UPDATE status = 1"
        db.session.execute(insert_sql)
        if admin_info.level in (4,5):
            machine.business_id = business_id
        db.session.commit()
        return_machine_no.append(i)

    return BaseResponse(data={"add_machine_nos": return_machine_no})


@machine_route.route("distribute_tallyman_machine", methods=["POST"])
def run_distribute_tallyman_machine():
    """

    :return:
    """
    json_data = request.get_json()
    machine_nos = json_data["machine_nos"]
    user_id = json_data["user_id"]

    result = AdminService.get_tallyman_account_list(user_id=user_id)
    if result["total_count"] != 1:
        return jsonify(ACCOUNT_NOT_EXISTS_ERROR)
    admin_info = json2obj(result["list"][0])

    return_machine_no = []
    for i in machine_nos:
        if g.user.level != 1:
            admin_machines = AdminMachine.query.filter_by(user_id=g.user.id, machine_no=i, status=1).first()
            if not admin_machines:
                continue
        machine = Machine.query.filter_by(machine_no=i).first()
        if not machine:
            continue
        insert_sql = " insert into tallyman_machine (user_id, machine_no) values "
        insert_sql += "('{}','{}'),".format(admin_info.id, i)
        insert_sql = insert_sql[:-1]
        insert_sql += "  ON DUPLICATE KEY UPDATE status = 1"
        db.session.execute(insert_sql)
        db.session.commit()
        return_machine_no.append(i)

    return BaseResponse(data={"add_machine_nos": return_machine_no})
