#!usr/bin/env python
# -*- coding:utf-8 _*-
import os
import json
import logging
import time
from flask import Blueprint, request, jsonify, g
from models.base_model import db
from utils.my_response import BaseResponse
from models.models import Machine, Hatch, Place,Management
from utils.error_code import MACHINE_NOT_EXIST_ERROR, NO_PLACE_ERROR,TOKEN_NOT_VALID_ERROR
from utils.jwt_util import verify_jwt
logger = logging.getLogger(__name__)
# 创建蓝图
machine_query_route = Blueprint('machine', __name__)
# 修改机器信息
@machine_query_route.route("query_edit",methods=["post"])
def query_edit():
    json_date = request.get_json()
    machine_no = json_date["machine_no"]
    address = json_date["address"]
    short_address = json_date["short_address"]
    status = json_date["status"]
    machine_not = Machine.query.filter_by(machine_no=machine_no).first()
    if not machine_not:
        return MACHINE_NOT_EXIST_ERROR
    machine_result = Machine.query.filter_by(machine_no=machine_no).update(
        {"address": address, "short_address": short_address, "status": status}
    )
    db.session.commit()

    return BaseResponse(data=True)
# 显出机柜数量
@machine_query_route.route("hatch_query",methods=["post"])
def hatch_query():
    json_date = request.get_json()
    machine_no = json_date["machine_no"]
    machine_not = Machine.query.filter_by(machine_no=machine_no).first()
    if not machine_not:
        return MACHINE_NOT_EXIST_ERROR
    machine_result = Hatch.query.filter_by(machine_no=machine_no).all()
    result_date = []
    hatch_having = []
    for res in machine_result:
        date={
            "hatch_no": res.hatch_no,
            "status": res.status
        }
        hatch_having.append(date)
    result_date.append({"power": machine_not.power})
    result_date.append(hatch_having)
    return BaseResponse(data=result_date)
# 查询信息
@machine_query_route.route("query", methods=["post"])
def query():
    json_date = request.get_json()
    page = json_date["page"]
    page_size = json_date["page_size"]
    # 判断有没有machine_no
    if "number" in json_date:
        get_number =str(json_date["number"])
    else:
        get_number =""

    machine_not = Machine.query.filter(Machine.machine_no.like("%" + get_number + "%")).first()
    if not machine_not:  # 没有
        add_not = Machine.query.filter(Machine.address.like("%"+get_number+"%")).first()  # 判断有没有add
        if not add_not:  # 没有返回空
            return BaseResponse(data=[])
        else:  # 有返回add信息
            add_result = Machine.query.filter(Machine.address.like("%"+get_number+"%")).offset((page-1)*page_size).limit(
                page_size
            )
            result_date = []
            for add in add_result:
                date = {
                    "machine_no": add.machine_no,
                    "address": add.address,
                    "short_address": add.short_address,
                    "hatch_number": add.hatch_number,
                    "status": add.status
                }
                result_date.append(date)
            return BaseResponse(data=result_date, page=page, page_size=page_size)
    else:
            machine_result = Machine.query.filter(Machine.machine_no.like("%"+get_number+"%")).offset((page-1)*page_size).\
                limit(page_size)
            result_date = []
            for machine in machine_result:
                date = {
                    "machine_no": machine.machine_no,
                    "address": machine.address,
                    "short_address": machine.short_address,
                    "hatch_number": machine.hatch_number,
                    "status": machine.status
                }
                result_date.append(date)
            return BaseResponse(data=result_date, page=page, page_size=page_size)

# 机器查询machine_query
@machine_query_route.route("machine_query", methods=["post"])
def machine_query():
    token = request.headers.get('Authorization')
    json_date = request.get_json()
    page = json_date["page"]
    page_size = json_date["page_size"]
    if token:
        SECRET_KEY = os.getenv('SECRET_KEY')
        payload = verify_jwt(token, SECRET_KEY)
        # return str(payload.get("user_id"))
        # 这边是拿到了user_id,接下来链表查询即可
        if not payload:
            return TOKEN_NOT_VALID_ERROR
        else:
            user_id = payload.get("user_id")
            if not user_id:
                return TOKEN_NOT_VALID_ERROR
            user_info = Management.query.filter_by().first()
            if not user_info:
                return TOKEN_NOT_VALID_ERROR
            machine_no = json_date["machine_no"] if "machine_no" in json_date else ""
            machine_mac = json_date["machine_mac"] if "machine_mac" in json_date else ""
            place_name = json_date["place_name"] if "place_name" in json_date else ""
            if "status" in json_date:
                status = json_date["status"]
                query1 = "select a.* ,b.management_id FROM machine as a JOIN management_machine as b ON " \
                     "a.machine_no = b.machine_no WHERE management_id='{}' and a.machine_no  like '{}' and " \
                     "a.mac like '{}' and a.address like '{}' and a.status ={} limit {},{}".\
                     format(user_id, "%"+machine_no+"%", "%"+machine_mac+"%", "%"+place_name+"%", status,
                            (page-1)*page_size, page*page_size)
            else:
                query1 = "select a.* ,b.management_id FROM machine as a JOIN management_machine as b ON " \
                         "a.machine_no = b.machine_no WHERE management_id='{}' and a.machine_no  like '{}' and " \
                         "a.mac like '{}' and a.address like '{}'  limit {},{}". \
                    format(user_id, "%" + machine_no + "%", "%" + machine_mac + "%", "%" + place_name + "%",
                           (page - 1) * page_size, page * page_size)
            machine_result = db.session.execute(query1).fetchall()
            result_date = []
            # # 将数据遍历和筛选
            for i in machine_result:
                date = {
                        "machine_no": i.machine_no,
                        "machine_mac": i.mac,
                        "status": i.status,
                        "short_address": i.short_address,
                        "address": i.address,
                        "address_id": i.place_id
                }
                result_date.append(date)
            return BaseResponse(date=result_date)
    else:
        return "no_token"

# 编辑机柜edit_machine
@machine_query_route.route("edit_machine", methods=["post"])
def update_machine():
    json_data = request.get_json()

    machine_no = json_data["machine_no"]
    machine_mac = json_data["machine_mac"]
    short_address = json_data["short_address"] if "short_address" in json_data else None
    address_id = json_data["address_id"]
    address_result = Place.query.filter_by(id=address_id).first()
    if not address_result:
        return NO_PLACE_ERROR
    machine_result = Machine.query.filter_by(mac=machine_mac).first()
    if not machine_result:
        return MACHINE_NOT_EXIST_ERROR
    machine_result.no = machine_no
    machine_result.place_id = address_id
    machine_result.short_address = address_result.place_name
    machine_result.short_address = short_address
    db.session.add(machine_result)
    db.session.commit()
    return BaseResponse(date={"success": True})


# 更换机器状态change_machine_status
@machine_query_route.route("change_machine_status", methods=["post"])
def update_status():
    json_data = request.get_json()
    machine_mac = json_data["machine_mac"]
    status = json_data["status"]
    machine_result = Machine.query.filter_by(mac=machine_mac).first()
    if not machine_result:
        return MACHINE_NOT_EXIST_ERROR
    machine_result.status = status
    db.session.add(machine_result)
    db.session.commit()
    return BaseResponse(date={"success":True})
