 # -*- coding: utf-8 -*-
import datetime
import logging
import time
import os
from flask import Blueprint, jsonify, request, g
from sqlalchemy import func

from config.base_config import MONGO_DATABASE_URI
from config.commen_config import LOGIN_TYPE

from models.base_model import db
from models.models import TallymanAccount, TallymanMachine, TallymanLoginRecord, Machine, Hatch, TallyRecord,\
    TallymanPlace, Management, TallymanMachine
from service.tallyman_service import TallymanService
from utils.error_code import TALLYMAN_ACCOUNT_EXIST, PHONE_NOT_VALID_ERROR, TOKEN_NOT_VALID_ERROR, PASSWORD_ERROR, \
    TALLYMAN_ACCOUNT_NOT_EXIST, MACHINE_NOT_EXIST_ERROR, HATCH_NOT_EXIST_ERROR, MACHINE_ACTIVATED_ERROR,\
    USER_ALREADY_REGISTER_ERROR
from utils.jwt_util import verify_jwt, generate_jwt
from utils.my_response import BaseResponse
logger = logging.getLogger(__name__)

tallyman_route = Blueprint('tallyman', __name__)

@tallyman_route.route('/add_man', methods=['GET', 'POST'])
def add_man():  # 添加补货员账号
    json_data = request.get_json()
    user_name = json_data['name']
    phone = json_data['phone']
    password = json_data['password']
    comment = json_data['comment'] if 'comment' in json_data else None
    # 是否存在手机号码
    tallyman = TallymanAccount.query.filter_by(phone=phone).first()
    if tallyman:
        if tallyman.status != -1:
            return jsonify(TALLYMAN_ACCOUNT_EXIST)
    else:
        tallyman = TallymanAccount()
    tallyman.user_no = "todo"
    tallyman.level =1
    tallyman.user_name = user_name
    tallyman.phone = phone
    tallyman.status = 1
    tallyman.comment = comment
    tallyman.created_at = datetime.datetime.now()
    tallyman.updated_at = datetime.datetime.now()
    if password:
        tallyman.password = password
    db.session.add(tallyman)
    db.session.commit()
    tallyman.user_no = "SK" + str(tallyman.id).zfill(6)
    db.session.add(tallyman)
    db.session.commit()
    return BaseResponse(date={"success": True})

# 删除补货员
@tallyman_route.route('/del_man', methods=['GET', 'POST'])
def del_man():
    json_date = request.get_json()
    tallyman_id = json_date["tallyman_id"]
    tall_result = TallymanAccount.query.filter_by(id=tallyman_id).first()
    if not tall_result:
        return TALLYMAN_ACCOUNT_NOT_EXIST
    tall_result.status = -1
    db.session.add(tall_result)
    db.session.commit()
    return BaseResponse(date={"success": True})

# 查询补货员list
@tallyman_route.route("/query_man",methods=['POST'])
def tallyman():
    token = request.headers.get('Authorization')
    json_date = request.get_json()
    tallyman = json_date['tallyman'] if "tallyman" in json_date else ""
    place_name = json_date["place_name"] if "place_name" in json_date else ""
    page = json_date["page"]
    page_size = json_date["page_size"]
    if not token:
        return TOKEN_NOT_VALID_ERROR
    SECRET_KEY = os.getenv('SECRET_KEY')
    payload = verify_jwt(token, SECRET_KEY)
    if not payload:
        return TOKEN_NOT_VALID_ERROR
    user_id = payload.get("user_id")
    user_res = Management.query.filter_by(id=user_id)
    if not user_res:
        return TOKEN_NOT_VALID_ERROR
    # 多表查询
    if "status" in json_date:
        status = json_date["status"]
        query1 = "SELECT a.*,b.management_id,c.place_id , d.place_name FROM ((tallyman_account as a JOIN " \
                 "management_tallyman as b on a.id = b.tallyman_id) JOIN tallyman_place as c on c.user_id = a.id) " \
                 "JOIN place as d ON d.id = c.place_id WHERE b.management_id = {} and a.user_name like '{}' and" \
                 " d.place_name like '{}' and a.status = {}  LIMIT {},{}" \
            .format(user_id, "%" + tallyman + "%", "%" + place_name + "%", status,(page - 1) * page_size, page * page_size)
    else:
        query1 = "SELECT a.*,b.management_id,c.place_id , d.place_name FROM ((tallyman_account as a JOIN " \
                 "management_tallyman as b on a.id = b.tallyman_id) JOIN tallyman_place as c on c.user_id = a.id) " \
                 "JOIN place as d ON d.id = c.place_id WHERE b.management_id = {} and a.user_name like '{}' and" \
                 " d.place_name like '{}'  LIMIT {},{}" \
            .format(user_id, "%" + tallyman + "%", "%" + place_name + "%", (page - 1) * page_size,
                    page * page_size)
    tallyman_result = db.session.execute(query1).fetchall()
    result_date = []
    for i in tallyman_result:
        date = {
            "tallyman_id": i.id,
            "user_no": i.user_no,
            "user_name": i.user_name,
            "level": i.level,
            "phone": i.phone,
            "status": i.status,
            "last_login": i.last_login,
            "address_name": i.place_name,
            "address_id": i.place_id
        }
        result_date.append(date)
    return BaseResponse(date=result_date)

# 编辑补货员信息
@tallyman_route.route("/edit_man",methods=["POST"])
def edit_man():
    json_date = request.get_json()
    tallyman_id = json_date["tallyman_id"]
    phone = json_date["phone"]
    t_name = json_date["t_name"]
    level = json_date["level"]
    man_result = TallymanAccount.query.filter_by(id=tallyman_id).first()
    if not man_result:
        return TALLYMAN_ACCOUNT_NOT_EXIST
    phone_not = TallymanAccount.query.filter_by(phone=phone, status=1).first()
    if phone_not:
        return USER_ALREADY_REGISTER_ERROR
    man_result.phone = phone
    man_result.user_name = t_name
    man_result.level = level
    db.session.add(man_result)
    return BaseResponse(date={"success": True})

# 为补货员添加机器,需要tally_id,machine,place_id
@tallyman_route.route("/give_machine", methods=["POST"])
def for_machine():
    json_date = request.get_json()
    tallyman_id = json_date["tallyman_id"]
    machine = json_date["machine"]
    place_id = json_date["place_id"]
    for i in machine:
        tallYman_machine = TallymanMachine()
        tallYman_machine.user_id = tallyman_id
        tallYman_machine.machine_no = i
        tallYman_machine.status = 1
        db.session.add(tallYman_machine)
        db.session.commit()
    tallyman_place = TallymanPlace()
    tallyman_place.place_id = place_id
    tallyman_place.user_id = tallyman_id
    tallyman_place.status = 1
    db.session.add(tallyman_place)
    db.session.commit()
    return BaseResponse(date={"success": True})
