#!usr/bin/.env python
# -*- coding:utf-8 _*-
"""
@version:
author:Aeolus
@time: 2021/06/17
@file: __init__.py.py
@function:
@modify:
"""
import os
from pathlib import Path

from dotenv import load_dotenv
from flask import Flask
from flask_cors import CORS
from flask_log_request_id import RequestID

from models.base_model import db

from utils.my_redis_cache import redis_client
from utils.mylogger import set_logger


def create_app(config_name):
    from config.env_path_config import env_path
    load_dotenv(dotenv_path=env_path, verbose=True, override=True)
    set_logger()

    app = Flask('nfc_socket')
    from config.app_config import config
    app.config.from_object(config[config_name])
    CORS(app, supports_credentials=True)  # HTTP/HTTPS 跨域
    db.init_app(app)
    # redis_client.init_app(app)
    RequestID(app)
    from utils.middlewares import log_enter_interface, jwt_authentication, log_out_interface, close_db_session, \
        all_options_pass
    app.before_request(log_enter_interface)
    app.before_request(all_options_pass)
    app.before_request(jwt_authentication)
    app.after_request(log_out_interface)
    app.after_request(close_db_session)

    # todo register blueprint
    from myapps.nfc.socket_server.api.account_portal import account
    app.register_blueprint(account, url_prefix="/nfc/account")
    return app


if __name__ == '__main__':
    print(os.path.abspath('../../../config/.env'))
